/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.util.PropertyUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class InheritedValues
extends HashMap<String, Object>
implements ValueMap {
    public static final Object UNDEFINED = "";
    protected final Resource resource;
    protected final Type inheritanceType;
    protected transient Resource exitPoint;
    protected transient Resource entryPoint;
    protected transient String relativePath;

    public InheritedValues(Resource resource) {
        this(resource, Type.contentRelated);
    }

    public InheritedValues(Resource resource, Type inheritanceType) {
        Validate.notNull((Object)((Object)inheritanceType), (String)"Inheritance type null is not permitted.", (Object[])new Object[0]);
        Validate.isTrue((Type.useDefault != inheritanceType ? 1 : 0) != 0, (String)"useDefault is not a valid inheritance strategy", (Object[])new Object[0]);
        this.resource = resource;
        this.inheritanceType = inheritanceType;
    }

    @Deprecated
    public InheritedValues(Resource resource, boolean nodeInheritance) {
        this(resource, Type.sameContent);
    }

    @Deprecated
    public InheritedValues(Resource resource, boolean nodeInheritance, boolean restrictToSameContent) {
        this(resource, nodeInheritance ? (restrictToSameContent ? Type.sameContent : Type.nodeRelated) : Type.contentRelated);
    }

    public <T> T get(String name, Class<T> type) {
        Object value = this.get(name);
        if (value == null) {
            value = this.findInherited(name, type);
            if (value == null) {
                value = UNDEFINED;
            }
            this.put(name, value);
        }
        return value != UNDEFINED ? (T)type.cast(value) : null;
    }

    public <T> T get(String name, T defaultValue) {
        Class<T> type = PropertyUtil.getType(defaultValue);
        Class<T> value = this.get(name, (T)type);
        return (T)(value != null ? value : defaultValue);
    }

    protected <T> T findInherited(String name, Class<T> type) {
        HierarchyScanResult found = this.findOriginAndValue(name, type);
        return (T)(found != null ? found.value : null);
    }

    public HierarchyScanResult findOriginAndValue(String name, Class<?> type) {
        this.findEntryPoint();
        String path = this.getRelativePath(name);
        for (Resource parent = this.entryPoint; parent != null; parent = parent.getParent()) {
            Object value;
            ValueMap parentProps = (ValueMap)parent.adaptTo(ValueMap.class);
            if (parentProps != null && (value = parentProps.get(path, type)) != null) {
                return new HierarchyScanResult(parent, value);
            }
            if (this.exitPoint != null && parent.getPath().equals(this.exitPoint.getPath())) break;
        }
        return null;
    }

    protected String getRelativePath(String name) {
        String path = this.relativePath;
        if (!path.endsWith("/") && StringUtils.isNotBlank((CharSequence)path)) {
            path = path + "/";
        }
        path = path + name;
        path = path.replaceAll("^\\./", "");
        path = path.replaceAll("/\\./", "/");
        path = path.replaceAll("/[^/]+/\\.\\./", "/");
        return path;
    }

    protected void findEntryPoint() {
        if (this.entryPoint == null) {
            Resource parent;
            StringBuilder path = new StringBuilder();
            String name = null;
            for (parent = this.resource; parent != null && !"jcr:content".equals(name = parent.getName()); parent = parent.getParent()) {
                if (this.inheritanceType == Type.contentBased) continue;
                if (path.length() > 0) {
                    path.insert(0, '/');
                }
                path.insert(0, name);
            }
            if (this.inheritanceType != Type.nodeRelated && this.inheritanceType != Type.sameContent && parent != null && "jcr:content".equals(name)) {
                path.insert(0, '/');
                path.insert(0, "jcr:content");
                this.relativePath = path.toString();
                this.entryPoint = parent.getParent();
            } else {
                this.relativePath = "";
                this.entryPoint = this.resource.getParent();
                if (this.inheritanceType == Type.sameContent && parent != null && "jcr:content".equals(name)) {
                    this.exitPoint = parent;
                }
            }
        }
    }

    public static class HierarchyScanResult {
        public final Resource origin;
        public final Object value;

        public HierarchyScanResult(Resource origin, Object value) {
            this.origin = origin;
            this.value = value;
        }
    }

    public static enum Type {
        contentRelated,
        contentBased,
        nodeRelated,
        sameContent,
        useDefault;

    }
}

