/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.JobControlServlet;
import com.composum.sling.core.servlet.SystemServlet;
import com.composum.sling.core.util.ResourceUtil;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(label="Composum Core Configuration", description="the configuration service for all servlets in the core bundle", immediate=true, metatype=true)
@Service
public class CoreConfigImpl
implements CoreConfiguration {
    public static final int DEFAULT_FORWARDED_SSL_PORT = 80;
    @Property(name="network.forward.ssl.port", label="Forwarded SSL Port", description="the port number which has to be used to determin the default port nnumber", intValue={80})
    private int forwardedSslPort;
    @Property(name="errorpages.path", label="Errorpages", description="the path to the errorpages; e.g. 'meta/errorpages' for searching errorpages along the requested path")
    private String errorpagesPath;
    @Property(name="errorpages.default", label="Default Errorpages", description="the path to the systems default error pages")
    private String defaultErrorpages;
    public static final String JOBCONTROL_SERVLET_ENABLED = "jobcontrol.servlet.enabled";
    @Property(name="jobcontrol.servlet.enabled", label="Jobcontrol Servlet", description="the general on/off switch for the services of the Jobcontrol Servlet", boolValue={true})
    private boolean jobcontrolServletEnabled;
    @Property(name="system.servlet.enabled", label="System Servlet", description="the general on/off switch for the services of the System Servlet", boolValue={true})
    private boolean systemServletEnabled;
    private Map<String, Boolean> enabledServlets;
    protected Dictionary properties;

    @Override
    public int getForwardedSslPort() {
        return this.forwardedSslPort;
    }

    @Override
    public boolean isEnabled(AbstractServiceServlet servlet) {
        Boolean result = this.enabledServlets.get(((Object)((Object)servlet)).getClass().getSimpleName());
        return result != null ? result : false;
    }

    @Override
    public Resource getErrorpage(SlingHttpServletRequest request, int status) {
        Resource errorpage = null;
        ResourceResolver resolver = request.getResourceResolver();
        if (StringUtils.isNotBlank((CharSequence)this.errorpagesPath)) {
            if (this.errorpagesPath.startsWith("/")) {
                errorpage = resolver.getResource(this.errorpagesPath + "/" + status);
            } else {
                String path = request.getRequestPathInfo().getResourcePath();
                Resource resource = resolver.resolve((HttpServletRequest)request, path);
                while (ResourceUtil.isNonExistingResource((Resource)resource)) {
                    int lastSlash = path.lastIndexOf(47);
                    path = lastSlash > 0 ? path.substring(0, lastSlash) : "/";
                    resource = resolver.resolve((HttpServletRequest)request, path);
                }
                while (errorpage == null && resource != null) {
                    path = resource.getPath();
                    if ("/".equals(path)) {
                        path = "";
                    }
                    if ((errorpage = resolver.getResource(path + "/" + this.errorpagesPath + "/" + status)) != null) continue;
                    resource = resource.getParent();
                }
            }
        }
        if (errorpage == null && StringUtils.isNotBlank((CharSequence)this.defaultErrorpages)) {
            errorpage = resolver.getResource(this.defaultErrorpages + "/" + status);
        }
        return errorpage;
    }

    @Override
    public boolean forwardToErrorpage(SlingHttpServletRequest request, SlingHttpServletResponse response, int status) throws ServletException, IOException {
        Resource errorpage = this.getErrorpage(request, status);
        if (errorpage != null) {
            request.setAttribute("errorpage.status", (Object)status);
            RequestDispatcher dispatcher = request.getRequestDispatcher(errorpage);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    @Override
    public Dictionary getProperties() {
        return this.properties;
    }

    @Activate
    @Modified
    protected void activate(ComponentContext context) {
        this.properties = context.getProperties();
        this.forwardedSslPort = PropertiesUtil.toInteger(this.properties.get("network.forward.ssl.port"), (int)80);
        this.errorpagesPath = StringUtils.removeEnd((String)((String)this.properties.get("errorpages.path")), (String)"/");
        this.defaultErrorpages = StringUtils.removeEnd((String)((String)this.properties.get("errorpages.default")), (String)"/");
        this.enabledServlets = new HashMap<String, Boolean>();
        this.systemServletEnabled = (Boolean)this.properties.get("system.servlet.enabled");
        this.enabledServlets.put(SystemServlet.class.getSimpleName(), this.systemServletEnabled);
        this.jobcontrolServletEnabled = (Boolean)this.properties.get(JOBCONTROL_SERVLET_ENABLED);
        this.enabledServlets.put(JobControlServlet.class.getSimpleName(), this.jobcontrolServletEnabled);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.properties = null;
    }
}

