/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.ResourceHandle;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Composum Core Sling Library Adapters", description=" Adapts Resources to ResourceHandles")
@Properties(value={@Property(name="service.description", value={"Composum Core Sling Library Adapters"}), @Property(name="adaptables", value={"org.apache.sling.api.resource.Resource"}, propertyPrivate=true), @Property(name="adapters", value={"com.composum.sling.core.ResourceHandle"}, propertyPrivate=true)})
@Service
public class CoreAdapterFactory
implements AdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(CoreAdapterFactory.class);

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof ResourceHandle) {
            return CoreAdapterFactory.getAdapter((ResourceHandle)adaptable, type);
        }
        if (adaptable instanceof Resource) {
            return CoreAdapterFactory.getAdapter((Resource)adaptable, type);
        }
        log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    protected static <AdapterType> AdapterType getAdapter(ResourceHandle resourceHandle, Class<AdapterType> type) {
        if (type == ResourceHandle.class) {
            return type.cast(resourceHandle);
        }
        log.info("Unable to adapt resource on {} to type {}", (Object)resourceHandle.getPath(), (Object)type.getName());
        return null;
    }

    protected static <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (type == ResourceHandle.class) {
            return type.cast(new ResourceHandle(resource));
        }
        log.info("Unable to adapt resource on {} to type {}", (Object)resource.getPath(), (Object)type.getName());
        return null;
    }
}

