/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.servlet;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.servlet.AbstractClientlibServlet;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"composum/nodes/commons/clientlib"}, extensions={"js", "css"}, methods={"GET", "HEAD"})
public class ClientlibServlet
extends AbstractClientlibServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ClientlibServlet.class);
    protected static final Pattern FILENAME_PATTERN = Pattern.compile("[^/]*+$");
    protected static final Pattern HASHSUFFIX_PATTERN = Pattern.compile("/?([0-9a-zA-Z_-]++)/" + FILENAME_PATTERN.pattern());

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.serve(true, request, response);
    }

    protected void doHead(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.serve(false, request, response);
    }

    private void serve(boolean get, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        if (!this.dropRequest(request, response)) {
            try {
                RequestPathInfo pathInfo = request.getRequestPathInfo();
                String selectors = pathInfo.getSelectorString();
                String path = pathInfo.getResourcePath();
                String hash = ClientlibServlet.parseHashFromSuffix(pathInfo.getSuffix());
                Clientlib.Type type = Clientlib.Type.valueOf(pathInfo.getExtension().toLowerCase());
                ClientlibRef clientlibref = new ClientlibRef(type, path, false, null);
                this.deliverClientlib(get, request, response, clientlibref, hash, this.isMinified(selectors));
            }
            catch (RepositoryException | LoginException ex) {
                throw new ServletException(ex);
            }
        }
    }

    public static String makePath(String path, Clientlib.Type type, boolean minified, String hash) {
        StringBuilder builder = new StringBuilder(path);
        if (minified) {
            builder.append(".min");
        }
        if (!path.endsWith("." + type.name()) && type != Clientlib.Type.img && type != Clientlib.Type.link) {
            builder.append('.').append(type.name());
        }
        return ClientlibServlet.appendHashSuffix(builder.toString(), hash);
    }

    @Override
    protected String makeUri(boolean minified, ClientlibLink link) {
        return ClientlibServlet.makePath(link.path, link.type, minified, link.hash);
    }

    public static String appendHashSuffix(String url, String hash) {
        if (null == hash) {
            return url;
        }
        Matcher matcher = FILENAME_PATTERN.matcher(url);
        String fname = "";
        if (matcher.find()) {
            fname = matcher.group(0);
        }
        return url + "/" + hash + "/" + fname;
    }

    public static String parseHashFromSuffix(String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix)) {
            return null;
        }
        Matcher matcher = HASHSUFFIX_PATTERN.matcher(suffix);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        LOG.warn("Could not parse hash suffix {}", (Object)suffix);
        return null;
    }
}

