/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.servlet;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibCategory;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibExternalUri;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.clientlibs.processor.AbstractClientlibVisitor;
import com.composum.sling.clientlibs.service.ClientlibService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"GET"}, paths={"/bin/cpm/nodes/debug/clientlibstructure"})
public class ClientlibDebugServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ClientlibDebugServlet.class);
    @Reference
    private ClientlibService clientlibService;

    protected void printUsage(SlingHttpServletRequest request, PrintWriter writer) {
        String url = request.getRequestURL().toString().replaceAll("\\.[^/]+$", "") + ".css.html";
        writer.println("<h2>Usage:</h2>");
        writer.println("Please give the type of the client library as extension and one or more");
        writer.println("client libraries or -categories as parameter lib. Some examples:<ul>");
        this.printLinkItem(writer, url + "?lib=category:composum.core.console.browser");
        this.printLinkItem(writer, url + "?lib=/libs/composum/nodes/console/clientlibs/base");
        this.printLinkItem(writer, url + "?lib=composum/nodes/console/clientlibs/base");
        writer.println("</ul>This prints the files and other included client libraries.");
        writer.println("It does not check for duplicated elements, as the normal rendering process does.</p>");
        writer.println("This prints all libraries of the type given as extension:<ul>");
        this.printLinkItem(writer, url);
        writer.println("</ul>");
        writer.flush();
    }

    protected void printLinkItem(PrintWriter writer, String url) {
        writer.println("<li><a href=\"" + url + "\">" + url + "</a></li>");
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<html><body><h1>Rough structure of client libraries</h1>");
        String typeString = request.getRequestPathInfo().getSelectorString();
        if (StringUtils.isBlank((CharSequence)typeString) || null == request.getParameter("lib")) {
            this.printUsage(request, writer);
            if (StringUtils.isNotBlank((CharSequence)typeString)) {
                this.printAllLibs(request, writer, typeString);
            }
            return;
        }
        Clientlib.Type type = Clientlib.Type.valueOf(typeString);
        for (String lib : request.getParameterValues("lib")) {
            ClientlibRef ref = null;
            ref = lib.startsWith("category:") ? ClientlibRef.forCategory(type, lib.substring("category:".length()), false, null) : new ClientlibRef(type, lib, false, null);
            this.displayClientlibStructure(request, writer, ref);
        }
        writer.println("<hr/></body></html>");
    }

    private void printAllLibs(SlingHttpServletRequest request, PrintWriter writer, String typeString) throws ServletException, IOException {
        try {
            ResourceResolver resolver = request.getResourceResolver();
            QueryManager querymanager = ((Session)resolver.adaptTo(Session.class)).getWorkspace().getQueryManager();
            String statement = "//element(*)[sling:resourceType='composum/nodes/commons/clientlib']/" + typeString + "/..";
            NodeIterator clientlibs = null;
            clientlibs = querymanager.createQuery(statement, "xpath").execute().getNodes();
            while (clientlibs.hasNext()) {
                this.displayClientlibStructure(request, writer, new Clientlib(Clientlib.Type.valueOf(typeString), resolver.getResource(clientlibs.nextNode().getPath())).getRef());
            }
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void displayClientlibStructure(SlingHttpServletRequest request, PrintWriter writer, ClientlibRef ref) throws IOException, ServletException {
        ClientlibElement clientlib = this.clientlibService.resolve(ref, request.getResourceResolver());
        String normalizedPath = this.normalizePath(ref, clientlib, request.getResourceResolver());
        StringBuilder categories = new StringBuilder();
        if (clientlib instanceof Clientlib) {
            Clientlib thelib = (Clientlib)clientlib;
            if (thelib.getCategories().isEmpty()) {
                categories.append(" (no categories)");
            } else {
                categories.append(" (in categories ");
                for (String cat : thelib.getCategories()) {
                    categories.append("<a href=\"").append(request.getRequestURL()).append("?lib=category:").append(cat).append("\">").append(cat).append("</a>");
                }
                categories.append(")");
            }
        }
        Validate.notNull((Object)clientlib, (String)("Not found: " + ref), (Object[])new Object[0]);
        writer.println("<hr/>");
        writer.println("<h2>Structure of <a href=\"" + request.getRequestURL() + "?lib=" + normalizedPath + "\">" + ref + "</a>" + categories + "</h2>");
        writer.println("<code>&lt;cpn:clientlib type=\"" + ref.type.name() + "\" path=\"" + normalizedPath + "\"/&gt;</code><br/><hr/><pre>");
        try {
            new DebugVisitor(clientlib, this.clientlibService, request.getResourceResolver(), writer).execute();
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
        writer.println("</pre>");
    }

    private String normalizePath(ClientlibRef ref, ClientlibElement clientlib, ResourceResolver resolver) {
        if (ref.isCategory()) {
            return "category:" + ref.category;
        }
        if (!ref.path.startsWith("/")) {
            return ref.path;
        }
        for (String pathelement : resolver.getSearchPath()) {
            String normalizedPath;
            ClientlibElement lib2;
            if (!ref.path.startsWith(pathelement) || !((lib2 = this.clientlibService.resolve(new ClientlibRef(ref.type, normalizedPath = ref.path.substring(pathelement.length()), ref.optional, ref.properties), resolver)) instanceof Clientlib)) continue;
            Clientlib reresolvedLib = (Clientlib)lib2;
            if (!reresolvedLib.getRef().path.equals(clientlib.getRef().path)) continue;
            return normalizedPath;
        }
        return ref.path;
    }

    protected void bindClientlibService(ClientlibService clientlibService) {
        this.clientlibService = clientlibService;
    }

    protected void unbindClientlibService(ClientlibService clientlibService) {
        if (this.clientlibService == clientlibService) {
            this.clientlibService = null;
        }
    }

    protected class DebugVisitor
    extends AbstractClientlibVisitor {
        protected static final int INDENTAMOUNT = 8;
        protected int indentation;
        protected final PrintWriter writer;

        protected DebugVisitor(ClientlibElement owner, ClientlibService service, ResourceResolver resolver, PrintWriter writer) {
            super(owner, service, resolver, new LinkedHashSet<ClientlibLink>());
            this.writer = writer;
        }

        @Override
        protected ClientlibVisitor createVisitorFor(ClientlibElement element) {
            return this;
        }

        @Override
        protected boolean isNotProcessed(ClientlibRef ref) {
            return true;
        }

        @Override
        protected void markAsProcessed(ClientlibLink link, ClientlibResourceFolder parent, ClientlibVisitor.VisitorMode visitorMode) {
        }

        @Override
        protected void notPresent(ClientlibRef ref, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder folder) {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + (Object)((Object)mode) + " Not present: " + ref);
        }

        @Override
        public void visit(ClientlibCategory category, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + (Object)((Object)mode) + " " + category);
            ++this.indentation;
            super.visit(category, mode, parent);
            --this.indentation;
        }

        @Override
        public void visit(Clientlib clientlib, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
            String order = 0 != clientlib.getOrder() ? " [order=" + clientlib.getOrder() + "]" : "";
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + (Object)((Object)mode) + " " + clientlib + order);
            ++this.indentation;
            super.visit(clientlib, mode, parent);
            --this.indentation;
        }

        @Override
        public void visit(ClientlibResourceFolder folder, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + (Object)((Object)mode) + " " + folder + (folder.getOptional() ? "[Opt]" : ""));
            ++this.indentation;
            super.visit(folder, mode, parent);
            --this.indentation;
        }

        @Override
        public void visit(ClientlibFile file, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws RepositoryException, IOException {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + (Object)((Object)mode) + " " + file);
            ++this.indentation;
            super.visit(file, mode, parent);
            --this.indentation;
        }

        @Override
        public void visit(ClientlibExternalUri externalUri, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + (Object)((Object)mode) + " " + externalUri);
            ++this.indentation;
            super.visit(externalUri, mode, parent);
            --this.indentation;
        }
    }
}

