/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.servlet;

import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.core.util.HttpUtil;
import com.composum.sling.core.util.LinkUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class AbstractClientlibServlet
extends SlingSafeMethodsServlet {
    private final Logger LOG = LoggerFactory.getLogger(AbstractClientlibServlet.class);
    @Reference
    protected ClientlibService service;
    @Reference
    protected ClientlibConfiguration configuration;

    protected void deliverClientlib(boolean get, SlingHttpServletRequest request, SlingHttpServletResponse response, ClientlibRef clientlibRef, String requestedHash, boolean minified) throws RepositoryException, LoginException, IOException {
        ClientlibService.ClientlibInfo hints;
        String encoding = null;
        boolean refreshCache = false;
        String header = request.getHeader("Accept-Encoding");
        if (StringUtils.isNotBlank((CharSequence)header) && header.contains("gzip")) {
            encoding = "gzip";
        }
        if (StringUtils.isNotBlank((CharSequence)(header = request.getHeader("Cache-Control")))) {
            refreshCache = header.contains("no-cache");
        }
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        try {
            hints = this.service.prepareContent(request, clientlibRef, minified, encoding, refreshCache, requestedHash, ifModifiedSince);
        }
        catch (PersistenceException ex) {
            this.LOG.warn("2nd try for preparation of '" + clientlibRef + "' after exception: " + (Object)((Object)ex));
            hints = this.service.prepareContent(request, clientlibRef, minified, encoding, refreshCache, requestedHash, ifModifiedSince);
        }
        if (null == hints) {
            this.LOG.warn("Not found: " + request.getRequestURI());
            throw new FileNotFoundException(request.getRequestURI());
        }
        if (hints.hash.equals(requestedHash)) {
            boolean notModified = false;
            if (hints.mimeType != null) {
                response.setContentType(hints.mimeType + "; charset=" + "UTF-8");
            }
            if (hints.encoding != null) {
                response.setHeader("Content-Encoding", hints.encoding);
                response.setHeader("Vary", "Accept-Encoding");
            }
            if (hints.size != null) {
                response.setHeader("Content-Length", hints.size.toString());
            }
            if (hints.lastModified != null) {
                long timeInMillis = hints.lastModified.getTimeInMillis();
                response.setDateHeader("Last-Modified", timeInMillis);
                if (get) {
                    if (!HttpUtil.isModifiedSince(ifModifiedSince, timeInMillis)) {
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("Skipping retransmission because If-Modified-Since={} but modified {}", (Object)ifModifiedSince, (Object)timeInMillis);
                        }
                        notModified = true;
                    } else if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug("Transmitting because If-Modified-Since={} but modified {}", (Object)ifModifiedSince, (Object)timeInMillis);
                    }
                }
            }
            if (notModified) {
                response.setStatus(304);
            } else if (get) {
                this.service.deliverContent(request.getResourceResolver(), clientlibRef, minified, (OutputStream)response.getOutputStream(), encoding);
            }
        } else {
            response.setStatus(301);
            String url = this.makeUrl(request, hints.link, minified);
            response.setHeader("Location", url);
            this.LOG.debug("Redirecting because of hash other than {} to {}", (Object)hints.hash, (Object)url);
        }
    }

    protected String makeUrl(SlingHttpServletRequest request, ClientlibLink link, boolean minified) {
        String uri = this.makeUri(minified, link);
        String url = this.configuration.getMapClientlibURLs() ? LinkUtil.getUrl(request, uri) : LinkUtil.getUnmappedUrl(request, uri);
        return url;
    }

    protected abstract String makeUri(boolean var1, ClientlibLink var2);

    protected boolean isMinified(String selectors) {
        boolean minified = false;
        if (StringUtils.isNotBlank((CharSequence)selectors) && !(minified = "min".equals(selectors))) {
            this.LOG.warn("Cannot understand selectorstring {}", (Object)selectors);
        }
        return minified;
    }

    protected boolean dropRequest(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        String uri = request.getRequestURI();
        if (uri.endsWith(".map")) {
            this.LOG.info("request dropped: '{}'", (Object)uri);
            response.setStatus(410);
            return true;
        }
        return false;
    }

    protected void bindService(ClientlibService clientlibService) {
        this.service = clientlibService;
    }

    protected void unbindService(ClientlibService clientlibService) {
        if (this.service == clientlibService) {
            this.service = null;
        }
    }

    protected void bindConfiguration(ClientlibConfiguration clientlibConfiguration) {
        this.configuration = clientlibConfiguration;
    }

    protected void unbindConfiguration(ClientlibConfiguration clientlibConfiguration) {
        if (this.configuration == clientlibConfiguration) {
            this.configuration = null;
        }
    }
}

