/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.service;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibCategory;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibExternalUri;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.FileHandle;
import com.composum.sling.clientlibs.processor.CssProcessor;
import com.composum.sling.clientlibs.processor.CssUrlMapper;
import com.composum.sling.clientlibs.processor.GzipProcessor;
import com.composum.sling.clientlibs.processor.JavascriptProcessor;
import com.composum.sling.clientlibs.processor.LinkRenderer;
import com.composum.sling.clientlibs.processor.ProcessingVisitor;
import com.composum.sling.clientlibs.processor.ProcessorContext;
import com.composum.sling.clientlibs.processor.ProcessorPipeline;
import com.composum.sling.clientlibs.processor.RendererContext;
import com.composum.sling.clientlibs.processor.UpdateTimeVisitor;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import com.composum.sling.clientlibs.service.ClientlibProcessor;
import com.composum.sling.clientlibs.service.ClientlibRenderer;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.concurrent.LazyCreationService;
import com.composum.sling.core.concurrent.SequencerService;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Composum Core Clientlib Service 2", description="Delivers the composed clientlib content bundled and compressed.", immediate=true)
@Service
public class DefaultClientlibService
implements ClientlibService {
    public static final String MINIFIED_SELECTOR = ".min";
    public static final Pattern UNMINIFIED_PATTERN = Pattern.compile("^(.+/)([^/]+)(\\.min)?(\\.[^.]+)$");
    public static final Pattern MINIFIED_PATTERN = Pattern.compile("^(.+/)([^/]+)(\\.min)(\\.[^.]+)?$");
    public static final String PROP_HASH = "jcr:description";
    public static final Map<String, Object> CRUD_CACHE_FOLDER_PROPS = new HashMap<String, Object>();
    private static final Logger LOG;
    @Reference
    protected ClientlibConfiguration clientlibConfig;
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Reference
    protected SequencerService sequencer;
    @Reference
    protected LazyCreationService lazyCreationService;
    @Reference
    protected JavascriptProcessor javascriptProcessor;
    @Reference
    protected CssProcessor cssProcessor;
    @Reference
    protected LinkRenderer linkRenderer;
    @Reference
    protected GzipProcessor gzipProcessor;
    protected ThreadPoolExecutor executorService = null;
    protected EnumMap<Clientlib.Type, ClientlibRenderer> rendererMap;
    protected EnumMap<Clientlib.Type, ClientlibProcessor> processorMap;
    protected final LRUMap categoryToPathCache = new LRUMap(100);
    protected static final Comparator<Resource> orderResourceComparator;

    @Modified
    @Activate
    protected void activate(ComponentContext context) {
        this.executorService = new ThreadPoolExecutor(this.clientlibConfig.getThreadPoolMin(), this.clientlibConfig.getThreadPoolMax(), 200L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.rendererMap = new EnumMap(Clientlib.Type.class);
        this.rendererMap.put(Clientlib.Type.js, this.javascriptProcessor);
        this.rendererMap.put(Clientlib.Type.css, this.cssProcessor);
        this.rendererMap.put(Clientlib.Type.link, this.linkRenderer);
        this.processorMap = new EnumMap(Clientlib.Type.class);
        this.processorMap.put(Clientlib.Type.js, this.javascriptProcessor);
        this.processorMap.put(Clientlib.Type.css, this.getClientlibConfig().getMapClientlibURLs() ? new ProcessorPipeline(new CssUrlMapper(), this.cssProcessor) : this.cssProcessor);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    @Override
    public ClientlibElement resolve(ClientlibRef ref, ResourceResolver resolver) {
        if (ref != null) {
            if (ref.isCategory()) {
                List<Resource> resources = this.retrieveCategoryResources(ref.category, resolver);
                if (!resources.isEmpty()) {
                    return new ClientlibCategory(ref, resources);
                }
            } else {
                if (ref.isExternalUri()) {
                    return new ClientlibExternalUri(ref.type, ref.externalUri, ref.properties);
                }
                Resource resource = this.retrieveResource(ref.path, resolver);
                if (null != resource) {
                    if (resource.isResourceType("composum/nodes/commons/clientlib")) {
                        return new Clientlib(ref.type, resource);
                    }
                    if (ClientlibFile.isFile(resource)) {
                        resource = this.minificationVariant(resource);
                        return new ClientlibFile(ref, ref.type, resource, ref.properties);
                    }
                    LOG.warn("Ignored resource {} with unknown type {}", (Object)resource.getPath(), (Object)resource.getResourceType());
                }
            }
            if (ref.optional) {
                LOG.debug("Could not resolve {}", (Object)ref);
            } else {
                LOG.warn("Could not resolve {}", (Object)ref);
            }
        } else {
            try {
                throw new RuntimeException("Clientlib ref is NULL!");
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    protected Resource minificationVariant(Resource resource) {
        if (this.getClientlibConfig().getUseMinifiedFiles()) {
            return this.getMinifiedSibling(resource);
        }
        return resource;
    }

    protected Resource retrieveResource(String path, ResourceResolver resolver) {
        Resource pathResource = this.retrieveResourceRaw(path, resolver);
        if (null == pathResource) {
            String minifiedPath;
            String unminifiedPath = this.getUnminifiedSibling(path);
            if (!path.equals(unminifiedPath)) {
                pathResource = this.retrieveResourceRaw(unminifiedPath, resolver);
            }
            if (null == pathResource && !(minifiedPath = this.getMinifiedSibling(path)).equals(path)) {
                pathResource = this.retrieveResourceRaw(minifiedPath, resolver);
            }
        }
        if (pathResource != null) {
            LOG.debug("retrieveResource {} uses {}", (Object)path, (Object)pathResource);
        } else {
            LOG.debug("retrieveResource.failed: {}", (Object)path);
        }
        return pathResource;
    }

    protected Resource retrieveResourceRaw(String path, ResourceResolver resolver) {
        Resource pathResource = null;
        if (path.startsWith("/")) {
            pathResource = resolver.getResource(path);
        } else {
            String[] searchPath = resolver.getSearchPath();
            for (int i = 0; pathResource == null && i < searchPath.length; ++i) {
                String absolutePath = searchPath[i] + path;
                pathResource = resolver.getResource(absolutePath);
            }
        }
        return pathResource;
    }

    protected String getMinifiedSibling(String path) {
        Matcher matcher = UNMINIFIED_PATTERN.matcher(path);
        if (matcher.matches() && StringUtils.isBlank((CharSequence)matcher.group(3))) {
            String ext = matcher.group(4);
            String minified = matcher.group(1) + matcher.group(2) + MINIFIED_SELECTOR;
            if (StringUtils.isNotBlank((CharSequence)ext)) {
                minified = minified + ext;
            }
            return minified;
        }
        return path;
    }

    protected String getUnminifiedSibling(String path) {
        Matcher matcher = MINIFIED_PATTERN.matcher(path);
        if (matcher.matches() && StringUtils.isNotBlank((CharSequence)matcher.group(3))) {
            String ext = matcher.group(4);
            String unminified = matcher.group(1) + matcher.group(2);
            if (StringUtils.isNotBlank((CharSequence)ext)) {
                unminified = unminified + ext;
            }
            return unminified;
        }
        return path;
    }

    @Override
    public Resource getMinifiedSibling(Resource resource) {
        Resource minified;
        String minifiedPath;
        String path = resource.getPath();
        if (!path.equals(minifiedPath = this.getMinifiedSibling(path)) && (minified = resource.getResourceResolver().getResource(minifiedPath)) != null) {
            return minified;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> retrieveCategoryResources(String category, ResourceResolver resolver) {
        long cacheTime = TimeUnit.SECONDS.toMillis(this.clientlibConfig.getResolverCachetime());
        if (cacheTime <= 0L) {
            return this.retrieveResourcesForCategoryUncached(category, resolver);
        }
        List<String> paths = null;
        long currentTimeMillis = System.currentTimeMillis();
        LRUMap lRUMap = this.categoryToPathCache;
        synchronized (lRUMap) {
            Pair cacheEntry = (Pair)this.categoryToPathCache.get((Object)category);
            if (null != cacheEntry && (Long)cacheEntry.getLeft() >= currentTimeMillis - cacheTime) {
                paths = (List)cacheEntry.getRight();
            }
        }
        if (null == paths) {
            paths = new ArrayList();
            try (ResourceResolver administrativeResolver = this.createAdministrativeResolver();){
                List<Resource> resourcesForAdmin = this.retrieveResourcesForCategoryUncached(category, administrativeResolver);
                for (Resource resource : resourcesForAdmin) {
                    paths.add(resource.getPath());
                }
            }
            LRUMap lRUMap2 = this.categoryToPathCache;
            synchronized (lRUMap2) {
                this.categoryToPathCache.put((Object)category, (Object)Pair.of((Object)currentTimeMillis, paths));
            }
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : paths) {
            Resource resource;
            resource = resolver.getResource(path);
            if (null == resource) continue;
            resources.add(resource);
        }
        return resources;
    }

    protected List<Resource> retrieveResourcesForCategoryUncached(String category, ResourceResolver resolver) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashSet<String> foundlibs = new HashSet<String>();
        for (String searchPathElement : resolver.getSearchPath()) {
            String xpath = "/jcr:root" + searchPathElement.replaceFirst("/+$", "") + "//element(*," + "sling:Folder" + ")[@" + "sling:resourceType" + "='" + "composum/nodes/commons/clientlib" + "' and @" + "category" + "='" + category + "']";
            Iterator iterator = resolver.findResources(xpath, "xpath");
            while (iterator.hasNext()) {
                Resource foundResource = (Resource)iterator.next();
                ResourceHandle handle = ResourceHandle.use(foundResource);
                String libPath = handle.getPath();
                String key = libPath.substring(libPath.indexOf(searchPathElement) + searchPathElement.length());
                if (foundlibs.contains(key)) continue;
                foundlibs.add(key);
                resources.add(foundResource);
            }
        }
        Collections.sort(resources, orderResourceComparator);
        return resources;
    }

    protected ResourceResolver createAdministrativeResolver() {
        try {
            return this.resolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            throw new SlingException("Configuration problem: we cannot get an administrative resolver ", (Throwable)e);
        }
    }

    @Override
    public ClientlibConfiguration getClientlibConfig() {
        return this.clientlibConfig;
    }

    @Override
    public void renderClientlibLinks(ClientlibElement clientlib, Writer writer, SlingHttpServletRequest request, RendererContext context) throws IOException, RepositoryException {
        Clientlib.Type type = clientlib.getType();
        ClientlibRenderer renderer = this.rendererMap.get((Object)type);
        if (renderer != null) {
            renderer.renderClientlibLinks(clientlib, writer, request, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientlibService.ClientlibInfo prepareContent(SlingHttpServletRequest request, ClientlibRef clientlibRef, boolean minified, String rawEncoding, boolean forceRefreshCache, String requestedHash, long ifModifiedSince) throws IOException, RepositoryException {
        boolean refreshForced;
        ClientlibElement element = this.resolve(clientlibRef, request.getResourceResolver());
        if (null == element) {
            LOG.error("No client libraries found for {}", (Object)clientlibRef);
            throw new FileNotFoundException("No client libraries for " + clientlibRef);
        }
        String encoding = this.adjustEncoding(rawEncoding);
        String cachePath = this.getCachePath(clientlibRef, minified, encoding);
        FileHandle cacheFile = new FileHandle(this.lazyCreationService.waitForInitialization(request.getResourceResolver(), cachePath));
        ClientlibService.ClientlibInfo fileHints = this.getFileHints(cacheFile, element.makeLink());
        boolean ifModifiedIsOlder = ifModifiedSince > 0L && null != cacheFile.getLastModified() && ifModifiedSince < cacheFile.getLastModified().getTimeInMillis();
        boolean cacheAssumedRecent = null != fileHints && null != fileHints.hash && (fileHints.hash.equals(requestedHash) || ifModifiedIsOlder);
        boolean bl = refreshForced = forceRefreshCache || null == fileHints || null == cacheFile.getLastModified();
        if (refreshForced || !cacheAssumedRecent) {
            ResourceResolver adminResolver = null;
            try {
                boolean refreshNeeded;
                adminResolver = this.createAdministrativeResolver();
                cacheFile = new FileHandle(adminResolver.getResource(cachePath));
                if (cacheFile.isValid() && null == request.getResourceResolver().getResource(cachePath)) {
                    this.refreshSession(request.getResourceResolver(), true);
                    if (null == request.getResourceResolver().getResource(cachePath)) {
                        LOG.warn("Cache file exists but is not accessible for user: {}", (Object)cachePath);
                        ClientlibService.ClientlibInfo clientlibInfo = null;
                        return clientlibInfo;
                    }
                }
                element = this.resolve(clientlibRef, adminResolver);
                UpdateTimeVisitor updateTimeVisitor = new UpdateTimeVisitor(element, this, request.getResourceResolver());
                updateTimeVisitor.execute();
                String hash = updateTimeVisitor.getHash();
                String cacheFileHash = cacheFile.getContent().getProperty(PROP_HASH);
                boolean bl2 = refreshNeeded = refreshForced || !hash.equals(cacheFileHash);
                if (null != cacheFile.getLastModified() && null != updateTimeVisitor.getLastUpdateTime() && updateTimeVisitor.getLastUpdateTime().after(cacheFile.getLastModified())) {
                    refreshNeeded = true;
                }
                if (refreshNeeded) {
                    LOG.info("prepare ''{}''...", (Object)clientlibRef);
                    Resource cacheEntry = adminResolver.getResource(cachePath);
                    if (cacheEntry != null) {
                        LOG.info("deleting to be refreshed ''{}''...", (Object)cacheEntry);
                        adminResolver.delete(cacheEntry);
                        adminResolver.commit();
                    }
                    ProcessorContext context = new ProcessorContext(request, adminResolver, this.executorService, this.getClientlibConfig().getMapClientlibURLs(), minified && this.clientlibConfig.getUseMinifiedFiles());
                    LazyCreationService.InitializationStrategy initializer = this.initializationStrategy(clientlibRef, encoding, hash, context);
                    Resource resource = this.lazyCreationService.getOrCreate(request.getResourceResolver(), cachePath, LazyCreationService.IDENTITY_RETRIEVER, this.creationStrategy(), initializer, CRUD_CACHE_FOLDER_PROPS);
                    cacheFile = new FileHandle(resource);
                }
                fileHints = this.getFileHints(cacheFile, element.makeLink());
            }
            finally {
                if (null != adminResolver) {
                    adminResolver.close();
                }
            }
        }
        LOG.debug("Hints: {}", (Object)fileHints);
        return fileHints;
    }

    protected LazyCreationService.CreationStrategy creationStrategy() {
        return new LazyCreationService.CreationStrategy(){

            @Override
            public Resource create(ResourceResolver adminResolver, Resource parent, String name) throws RepositoryException, PersistenceException {
                Resource cacheEntry = adminResolver.create(parent, name, FileHandle.CRUD_FILE_PROPS);
                ((Node)adminResolver.create(cacheEntry, "jcr:content", FileHandle.CRUD_CONTENT_PROPS).adaptTo(Node.class)).addMixin("mix:title");
                FileHandle cacheFile = new FileHandle(cacheEntry);
                cacheFile.storeContent(new ByteArrayInputStream("".getBytes()));
                return cacheEntry;
            }
        };
    }

    protected LazyCreationService.InitializationStrategy initializationStrategy(final ClientlibRef clientlibRef, final String encoding, final String hash, final ProcessorContext context) {
        return new LazyCreationService.InitializationStrategy(){

            @Override
            public void initialize(ResourceResolver adminResolver, Resource cacheEntry) throws RepositoryException, PersistenceException {
                try {
                    FileHandle cacheFile = new FileHandle(cacheEntry);
                    if (cacheFile.isValid()) {
                        LOG.debug("create clientlib cache content ''{}''...", (Object)cacheFile.getResource().getPath());
                        PipedOutputStream outputStream = new PipedOutputStream();
                        InputStream inputStream = new PipedInputStream(outputStream);
                        Future<Void> result = DefaultClientlibService.this.startProcessing(clientlibRef, encoding, context, outputStream);
                        if ("gzip".equals(encoding)) {
                            inputStream = DefaultClientlibService.this.gzipProcessor.processContent(inputStream, context);
                        }
                        cacheFile.storeContent(inputStream);
                        ModifiableValueMap contentValues = cacheFile.getContent().adaptTo(ModifiableValueMap.class);
                        contentValues.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
                        contentValues.putAll(context.getHints());
                        contentValues.put((Object)DefaultClientlibService.PROP_HASH, (Object)hash);
                        adminResolver.commit();
                        result.get();
                        LOG.info("clientlib cache content ''{}'' created", (Object)cacheFile.getResource().getPath());
                    } else {
                        LOG.error("can't create cache content in '{}'!", (Object)(cacheFile != null ? cacheFile.getResource().getPath() : "null"));
                    }
                }
                catch (Exception e) {
                    LOG.error("Error when initializing content in " + cacheEntry + "; deleting the file", (Throwable)e);
                    DefaultClientlibService.this.refreshSession(adminResolver, false);
                    adminResolver.delete(cacheEntry);
                    throw new PersistenceException("" + e, (Throwable)e);
                }
            }
        };
    }

    protected Future<Void> startProcessing(final ClientlibRef clientlibRef, String encoding, final ProcessorContext context, final OutputStream outputStream) throws IOException {
        final ClientlibProcessor processor = this.processorMap.get((Object)clientlibRef.type);
        Future<Void> callable = context.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                ResourceResolver processingAdminResolver = null;
                try {
                    processingAdminResolver = DefaultClientlibService.this.createAdministrativeResolver();
                    ClientlibElement adminElement = DefaultClientlibService.this.resolve(clientlibRef, processingAdminResolver);
                    ProcessingVisitor visitor = new ProcessingVisitor(adminElement, DefaultClientlibService.this, outputStream, processor, context);
                    visitor.execute();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    if (null != processingAdminResolver) {
                        processingAdminResolver.close();
                    }
                }
                return null;
            }
        });
        return callable;
    }

    protected ClientlibService.ClientlibInfo getFileHints(FileHandle file, ClientlibLink link) {
        if (file.isValid()) {
            ClientlibService.ClientlibInfo hints = new ClientlibService.ClientlibInfo();
            ValueMap contentValues = file.getContent().adaptTo(ValueMap.class);
            hints.lastModified = (Calendar)contentValues.get("jcr:lastModified", Calendar.class);
            hints.mimeType = (String)contentValues.get("jcr:mimeType", String.class);
            hints.encoding = (String)contentValues.get("jcr:encoding", String.class);
            hints.hash = (String)contentValues.get(PROP_HASH, String.class);
            hints.size = file.getSize();
            hints.link = link.withHash(hints.hash);
            return hints;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverContent(ResourceResolver resolver, ClientlibRef clientlibRef, boolean minified, OutputStream outputStream, String encoding) throws IOException, RepositoryException {
        String cachePath = this.getCachePath(clientlibRef, minified, encoding = this.adjustEncoding(encoding));
        Resource resource = this.lazyCreationService.waitForInitialization(resolver, cachePath);
        FileHandle file = new FileHandle(resource);
        if (file.isValid()) {
            InputStream content = file.getStream();
            if (content != null) {
                try {
                    IOUtils.copy((InputStream)content, (OutputStream)outputStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)content);
                }
            }
        } else {
            throw new FileNotFoundException("No cached file found for " + clientlibRef);
        }
    }

    protected String getCachePath(ClientlibRef ref, boolean minified, String encoding) {
        String cacheKey;
        String cacheRoot = this.clientlibConfig.getCacheRoot();
        String string = cacheKey = ref.isCategory() ? "/categorycache/" + ref.category : ref.path;
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            cacheKey = cacheKey + '.' + encoding.trim();
        }
        if (minified && this.clientlibConfig.getUseMinifiedFiles()) {
            cacheKey = cacheKey + MINIFIED_SELECTOR;
        }
        cacheKey = cacheKey + "." + ref.type.name();
        return cacheRoot + cacheKey;
    }

    protected String adjustEncoding(String encoding) {
        if ("gzip".equals(encoding) && !this.clientlibConfig.getGzipEnabled()) {
            encoding = null;
        }
        return encoding;
    }

    protected void refreshSession(ResourceResolver resolver, boolean logwarning) {
        block2: {
            try {
                ((Session)resolver.adaptTo(Session.class)).refresh(true);
            }
            catch (RepositoryException rex) {
                if (!logwarning) break block2;
                LOG.warn(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    static {
        CRUD_CACHE_FOLDER_PROPS.put("jcr:primaryType", "sling:Folder");
        LOG = LoggerFactory.getLogger(DefaultClientlibService.class);
        orderResourceComparator = new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                int order2;
                int order1 = ResourceHandle.use(o1).getProperty("order", 0);
                int res = Integer.compare(order1, order2 = ResourceHandle.use(o2).getProperty("order", 0).intValue());
                return res != 0 ? res : o1.getPath().compareTo(o2.getPath());
            }
        };
    }

    protected void bindClientlibConfig(ClientlibConfiguration clientlibConfiguration) {
        this.clientlibConfig = clientlibConfiguration;
    }

    protected void unbindClientlibConfig(ClientlibConfiguration clientlibConfiguration) {
        if (this.clientlibConfig == clientlibConfiguration) {
            this.clientlibConfig = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindSequencer(SequencerService sequencerService) {
        this.sequencer = sequencerService;
    }

    protected void unbindSequencer(SequencerService sequencerService) {
        if (this.sequencer == sequencerService) {
            this.sequencer = null;
        }
    }

    protected void bindLazyCreationService(LazyCreationService lazyCreationService) {
        this.lazyCreationService = lazyCreationService;
    }

    protected void unbindLazyCreationService(LazyCreationService lazyCreationService) {
        if (this.lazyCreationService == lazyCreationService) {
            this.lazyCreationService = null;
        }
    }

    protected void bindJavascriptProcessor(JavascriptProcessor javascriptProcessor) {
        this.javascriptProcessor = javascriptProcessor;
    }

    protected void unbindJavascriptProcessor(JavascriptProcessor javascriptProcessor) {
        if (this.javascriptProcessor == javascriptProcessor) {
            this.javascriptProcessor = null;
        }
    }

    protected void bindCssProcessor(CssProcessor cssProcessor) {
        this.cssProcessor = cssProcessor;
    }

    protected void unbindCssProcessor(CssProcessor cssProcessor) {
        if (this.cssProcessor == cssProcessor) {
            this.cssProcessor = null;
        }
    }

    protected void bindLinkRenderer(LinkRenderer linkRenderer) {
        this.linkRenderer = linkRenderer;
    }

    protected void unbindLinkRenderer(LinkRenderer linkRenderer) {
        if (this.linkRenderer == linkRenderer) {
            this.linkRenderer = null;
        }
    }

    protected void bindGzipProcessor(GzipProcessor gzipProcessor) {
        this.gzipProcessor = gzipProcessor;
    }

    protected void unbindGzipProcessor(GzipProcessor gzipProcessor) {
        if (this.gzipProcessor == gzipProcessor) {
            this.gzipProcessor = null;
        }
    }
}

