/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.service;

import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(label="Composum Core Clientlib Configuration", description="Delivers the composed clienlib content bundled and compressed.", immediate=true, metatype=true)
@Service
public class ClientlibConfigurationService
implements ClientlibConfiguration {
    public static final String TAGDEBUG = "tagdebug";
    @Property(name="tagdebug", label="Tag-Debug", description="Inserts HTML comments with the client libraries that have been called up into the page", boolValue={false})
    protected boolean tagdebug;
    public static final String DEBUG = "debug";
    @Property(name="debug", label="Debug", description="let files unchanged and unbundled if set to 'true'", boolValue={false})
    protected boolean debug;
    public static final String CSS_MINIMIZE = "css.minimize";
    @Property(name="css.minimize", label="CSS - Minimize", description="compress with the YUI compressor (if not 'debug' is set); default: true", boolValue={true})
    protected boolean cssMinimize;
    public static final String CSS_LINEBREAK = "css.lineBreak";
    @Property(name="css.lineBreak", label="CSS - Line Break", description="length of compressed CSS source lines (if not 'debug' is set); default: 0", intValue={0})
    protected int cssLineBreak;
    public static final String CSS_DEFAULT_TEMPLATE = "  <link rel=\"stylesheet\" href=\"{0}\" />";
    public static final String CSS_TEMPLATE = "css.template";
    @Property(name="css.template", label="CSS - Link Template", description="the HTML template for the CSS link rendering", value={"  <link rel=\"stylesheet\" href=\"{0}\" />"})
    protected String cssTemplate;
    public static final String JS_DEFAULT_TEMPLATE = "  <script type=\"text/javascript\" src=\"{0}\"></script>";
    public static final String JS_TEMPLATE = "javascript.template";
    @Property(name="javascript.template", label="JS - Template", description="the HTML template for the Javascript tag rendering", value={"  <script type=\"text/javascript\" src=\"{0}\"></script>"})
    protected String jsTemplate;
    public static final String LINK_DEFAULT_TEMPLATE = "  <link rel=\"{1}\" href=\"{0}\" />";
    public static final String LINK_TEMPLATE = "link.template";
    @Property(name="link.template", label="Link - Template", description="the HTML template for the general link rendering", value={"  <link rel=\"{1}\" href=\"{0}\" />"})
    protected String linkTemplate;
    public static final boolean DEFAULT_GZIP_ENABLED = false;
    public static final String GZIP_ENABLED = "gzip.enabled";
    @Property(name="gzip.enabled", label="General - GZip enabled", description="if 'true' the content is zippend if possible", boolValue={false})
    protected boolean gzipEnabled;
    public static final String DEFAULT_CACHE_ROOT = "/var/cache/clientlibs";
    public static final String CACHE_ROOT = "clientlibs.cache.root";
    @Property(name="clientlibs.cache.root", label="General - Cache Root", description="the root folder for the Javascript clientlib cache", value={"/var/cache/clientlibs"})
    protected String cacheRoot;
    public static final boolean DEFAULT_USE_MINIFIED_FILES = true;
    public static final String USE_MINIFIED_FILES = "clientlibs.files.minified";
    @Property(name="clientlibs.files.minified", label="General - Use minified CSS/JS", description="if 'on' for all clientlib files which have a '.min' sibling the '.min' files is used; default: 'on'", boolValue={true})
    protected boolean useMinifiedFiles;
    public static final boolean DEFAULT_MAP_CLIENTLIB_URLS = true;
    public static final String MAP_CLIENTLIB_URLS = "clientlibs.url.map";
    @Property(name="clientlibs.url.map", label="General - Map Clientlib URLs", description="if 'on' all clientlib URLs are mapped by the Resource Resolver; default: 'on'", boolValue={true})
    protected boolean mapClientlibURLs;
    public static final int DEFAULT_THREAD_POOL_MIN = 10;
    public static final String MIN_THREAD_POOL_SIZE = "clientlibs.threadpool.min";
    @Property(name="clientlibs.threadpool.min", label="General - Threadpool min", description="the minimum size of the thread pool for clientlib processing (must be 10 or greater)", intValue={10})
    protected int threadPoolMin;
    public static final int DEFAULT_THREAD_POOL_MAX = 20;
    public static final String MAX_THREAD_POOL_SIZE = "clientlibs.threadpool.max";
    @Property(name="clientlibs.threadpool.max", label="General - Threadpool max", description="the size (maximum) of the thread pool for clientlib processing (must be equal or greater than the minimum)", intValue={20})
    protected int threadPoolMax;
    public static final int DEFAULT_RESOLVER_CACHETIME = 60;
    public static final String RESOLVER_CACHETIME = "clientlibs.resolver.cachetime";
    @Property(name="clientlibs.resolver.cachetime", label="General - Resolver cachetime", description="the time (in seconds) the clientlib resolver caches the locations of all client libraries for a category. <=0 means no caching.", intValue={60})
    protected int resolverCachetime;

    @Override
    public boolean getCssMinimize() {
        return this.cssMinimize;
    }

    @Override
    public int getCssLineBreak() {
        return this.cssLineBreak;
    }

    @Override
    public String getCssTemplate() {
        return this.cssTemplate;
    }

    @Override
    public String getJavascriptTemplate() {
        return this.jsTemplate;
    }

    @Override
    public String getLinkTemplate() {
        return this.linkTemplate;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public boolean getMapClientlibURLs() {
        return this.mapClientlibURLs;
    }

    @Override
    public boolean getUseMinifiedFiles() {
        return this.useMinifiedFiles;
    }

    @Override
    public boolean getGzipEnabled() {
        return this.gzipEnabled;
    }

    @Override
    public String getCacheRoot() {
        return this.cacheRoot;
    }

    @Override
    public int getThreadPoolMin() {
        return this.threadPoolMin;
    }

    @Override
    public int getThreadPoolMax() {
        return this.threadPoolMax;
    }

    @Override
    public int getResolverCachetime() {
        return this.resolverCachetime;
    }

    @Override
    public boolean getTagDebug() {
        return this.tagdebug;
    }

    @Modified
    @Activate
    protected void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.debug = PropertiesUtil.toBoolean(properties.get(DEBUG), (boolean)false);
        this.cssMinimize = PropertiesUtil.toBoolean(properties.get(CSS_MINIMIZE), (boolean)true);
        this.cssLineBreak = PropertiesUtil.toInteger(properties.get(CSS_LINEBREAK), (int)0);
        this.cssTemplate = PropertiesUtil.toString(properties.get(CSS_TEMPLATE), (String)CSS_DEFAULT_TEMPLATE);
        this.jsTemplate = PropertiesUtil.toString(properties.get(JS_TEMPLATE), (String)JS_DEFAULT_TEMPLATE);
        this.linkTemplate = PropertiesUtil.toString(properties.get(LINK_TEMPLATE), (String)LINK_DEFAULT_TEMPLATE);
        this.mapClientlibURLs = PropertiesUtil.toBoolean(properties.get(MAP_CLIENTLIB_URLS), (boolean)true);
        this.useMinifiedFiles = !this.debug && PropertiesUtil.toBoolean(properties.get(USE_MINIFIED_FILES), (boolean)true);
        this.gzipEnabled = PropertiesUtil.toBoolean(properties.get(GZIP_ENABLED), (boolean)false);
        this.cacheRoot = PropertiesUtil.toString(properties.get(CACHE_ROOT), (String)DEFAULT_CACHE_ROOT);
        this.threadPoolMin = PropertiesUtil.toInteger(properties.get(MIN_THREAD_POOL_SIZE), (int)10);
        this.threadPoolMax = PropertiesUtil.toInteger(properties.get(MAX_THREAD_POOL_SIZE), (int)20);
        if (this.threadPoolMin < 10) {
            this.threadPoolMin = 10;
        }
        if (this.threadPoolMax < this.threadPoolMin) {
            this.threadPoolMax = this.threadPoolMin;
        }
        this.resolverCachetime = PropertiesUtil.toInteger(properties.get(RESOLVER_CACHETIME), (int)60);
    }
}

