/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.processor.AbstractClientlibRenderer;
import com.composum.sling.clientlibs.processor.CssProcessor;
import com.composum.sling.clientlibs.processor.ProcessorContext;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Clientlib CSS Processor (YUI)", description="Delivers CSS content bundled and minimized.", immediate=true)
@Service
public class YUICssProcessor
extends AbstractClientlibRenderer
implements CssProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(YUICssProcessor.class);
    @Reference
    private ClientlibConfiguration clientlibConfig;

    @Override
    protected String getLinkTemplate() {
        return this.clientlibConfig.getCssTemplate();
    }

    @Override
    public InputStream processContent(final InputStream source, ProcessorContext context) throws IOException {
        InputStream result = source;
        if (source != null) {
            context.hint("jcr:mimeType", "text/css");
            if (context.useMinifiedFiles() && this.clientlibConfig.getCssMinimize()) {
                final PipedOutputStream outputStream = new PipedOutputStream();
                result = new PipedInputStream(outputStream);
                context.execute(new Runnable(){

                    @Override
                    public void run() {
                        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                             InputStreamReader sourceReader = new InputStreamReader(source, "UTF-8");){
                            CssCompressor compressor = new CssCompressor((Reader)sourceReader);
                            compressor.compress((Writer)writer, YUICssProcessor.this.clientlibConfig.getCssLineBreak());
                            writer.flush();
                        }
                        catch (IOException ex) {
                            LOG.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                });
            }
        }
        return result;
    }

    protected void bindClientlibConfig(ClientlibConfiguration clientlibConfiguration) {
        this.clientlibConfig = clientlibConfiguration;
    }

    protected void unbindClientlibConfig(ClientlibConfiguration clientlibConfiguration) {
        if (this.clientlibConfig == clientlibConfiguration) {
            this.clientlibConfig = null;
        }
    }
}

