/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.clientlibs.processor.AbstractClientlibVisitor;
import com.composum.sling.clientlibs.service.ClientlibService;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedHashSet;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTimeVisitor
extends AbstractClientlibVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTimeVisitor.class);
    protected Calendar lastUpdateTime = null;

    public UpdateTimeVisitor(ClientlibElement owner, ClientlibService service, ResourceResolver resolver) {
        this(owner, service, resolver, null);
    }

    protected UpdateTimeVisitor(ClientlibElement owner, ClientlibService service, ResourceResolver resolver, LinkedHashSet<ClientlibLink> processedElements) {
        super(owner, service, resolver, processedElements);
    }

    @Override
    public UpdateTimeVisitor execute() throws IOException, RepositoryException {
        super.execute();
        return this;
    }

    public Calendar getLastUpdateTime() {
        if (null != this.lastUpdateTime && this.lastUpdateTime.after(Calendar.getInstance())) {
            LOG.warn("Last update time newer than now {} for {}", (Object)this.lastUpdateTime, (Object)this.owner);
            return null;
        }
        return this.lastUpdateTime;
    }

    @Override
    protected ClientlibVisitor createVisitorFor(ClientlibElement element) {
        return new UpdateTimeVisitor(element, this.service, this.resolver, this.processedElements);
    }

    @Override
    public void action(Clientlib clientlib, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
        this.updateTime(clientlib, clientlib.resource.getLastModified());
    }

    @Override
    public void action(ClientlibFile file, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
        if (ClientlibVisitor.VisitorMode.EMBEDDED == mode) {
            Calendar lastModified = file.handle.getLastModified();
            this.updateTime(file, lastModified);
        }
    }

    protected void updateTime(Object entity, Calendar resourceTime) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} modification on {}", entity, null != resourceTime ? resourceTime.getTime() : "null");
        }
        if (null == this.lastUpdateTime || null != resourceTime && resourceTime.after(this.lastUpdateTime)) {
            this.lastUpdateTime = resourceTime;
        }
    }
}

