/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.processor.ProcessorContext;
import com.composum.sling.clientlibs.service.ClientlibProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ProcessorPipeline
implements ClientlibProcessor {
    protected List<ClientlibProcessor> processors = new ArrayList<ClientlibProcessor>();

    public ProcessorPipeline(ClientlibProcessor ... processors) {
        for (ClientlibProcessor processor : processors) {
            this.addProcessor(processor);
        }
    }

    public void addProcessor(ClientlibProcessor processor) {
        if (processor != null) {
            this.processors.add(processor);
        }
    }

    public void addProcessor(int index, ClientlibProcessor processor) {
        if (processor != null) {
            if (index < 0) {
                index = 0;
            }
            if (index > this.processors.size()) {
                index = this.processors.size();
            }
            this.processors.add(index, processor);
        }
    }

    @Override
    public InputStream processContent(InputStream stream, ProcessorContext context) throws IOException {
        for (ClientlibProcessor processor : this.processors) {
            stream = processor.processContent(stream, context);
        }
        return stream;
    }
}

