/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.processor.AbstractClientlibRenderer;
import com.composum.sling.clientlibs.processor.JavascriptProcessor;
import com.composum.sling.clientlibs.processor.ProcessorContext;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import java.io.IOException;
import java.io.InputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Clientlib Default Javascript Processor", description="Delivers Javascript content bundled.", immediate=true)
@Service
public class DefaultJavascriptProcessor
extends AbstractClientlibRenderer
implements JavascriptProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJavascriptProcessor.class);
    @Reference
    private ClientlibConfiguration clientlibConfig;

    @Override
    protected String getLinkTemplate() {
        return this.clientlibConfig.getJavascriptTemplate();
    }

    @Override
    public InputStream processContent(InputStream source, ProcessorContext context) throws IOException {
        context.hint("jcr:mimeType", "application/javascript");
        return source;
    }

    protected void bindClientlibConfig(ClientlibConfiguration clientlibConfiguration) {
        this.clientlibConfig = clientlibConfiguration;
    }

    protected void unbindClientlibConfig(ClientlibConfiguration clientlibConfiguration) {
        if (this.clientlibConfig == clientlibConfiguration) {
            this.clientlibConfig = null;
        }
    }
}

