/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.processor.GzipProcessor;
import com.composum.sling.clientlibs.processor.ProcessorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=false)
@Service
public class DefaultGzipProcessor
implements GzipProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGzipProcessor.class);

    @Override
    public InputStream processContent(final InputStream source, ProcessorContext context) throws IOException {
        InputStream result = source;
        if (source != null) {
            context.hint("jcr:encoding", "gzip");
            PipedOutputStream outputStream = new PipedOutputStream();
            result = new PipedInputStream(outputStream);
            final GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
            context.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IOUtils.copy((InputStream)source, (OutputStream)gzipOutputStream);
                        gzipOutputStream.flush();
                    }
                    catch (IOException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)gzipOutputStream);
                    }
                }
            });
        }
        return result;
    }
}

