/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.handle;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.util.ResourceUtil;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHandle {
    private final Logger LOG = LoggerFactory.getLogger(FileHandle.class);
    public static final Map<String, Object> CRUD_FILE_PROPS = new HashMap<String, Object>();
    public static final Map<String, Object> CRUD_CONTENT_PROPS;
    protected final ResourceHandle resource;
    protected final ResourceHandle content;
    protected transient String name;
    protected transient String extension;
    protected transient String mimeType;
    protected transient String encoding;
    protected transient Calendar lastModified;

    public FileHandle(Resource resource) {
        this.resource = ResourceHandle.use(resource);
        this.content = this.retrieveContent();
    }

    public ResourceHandle getContent() {
        return this.content;
    }

    public ResourceHandle getResource() {
        return this.resource;
    }

    public boolean isValid() {
        return this.resource.isValid() && this.content.isValid();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getName() {
        if (this.name == null) {
            this.retrieveNameAndExt();
        }
        return this.name;
    }

    public String getExtension() {
        if (this.extension == null) {
            this.retrieveNameAndExt();
        }
        return this.extension;
    }

    public String getMimeType() {
        if (this.mimeType == null && this.content.isValid()) {
            this.mimeType = this.content.getProperty("jcr:mimeType", "");
        }
        return this.mimeType;
    }

    public String getEncoding() {
        if (this.encoding == null && this.content.isValid()) {
            this.encoding = this.content.getProperty("jcr:encoding", "");
        }
        return this.encoding;
    }

    public Calendar getLastModified() {
        if (this.lastModified == null) {
            if (this.content.isValid()) {
                this.lastModified = this.content.getLastModified();
            }
            if (null == this.lastModified && this.resource.isValid()) {
                this.lastModified = this.resource.getLastModified();
            }
        }
        return this.lastModified;
    }

    public Long getSize() {
        Long size = null;
        Binary binary = ResourceUtil.getBinaryData(this.resource);
        if (binary != null) {
            try {
                size = binary.getSize();
            }
            catch (RepositoryException ex) {
                this.LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return size;
    }

    public InputStream getStream() throws RepositoryException {
        InputStream stream = null;
        if (this.content.isValid()) {
            ValueMap values = this.content.adaptTo(ValueMap.class);
            stream = (InputStream)values.get("jcr:data", InputStream.class);
        }
        return stream;
    }

    public void storeContent(InputStream stream) throws RepositoryException {
        if (this.content.isValid()) {
            ModifiableValueMap values = this.content.adaptTo(ModifiableValueMap.class);
            values.put((Object)"jcr:data", (Object)stream);
        }
    }

    protected ResourceHandle retrieveContent() {
        Resource content = null;
        if (this.resource.isValid()) {
            if (this.resource.isResourceType("nt:file")) {
                content = this.resource.getChild("jcr:content");
            } else if (this.resource.isResourceType("nt:linkedFile")) {
                String uuid = this.resource.getProperty("jcr:content", "");
                if (StringUtils.isNotBlank((CharSequence)uuid)) {
                    ResourceResolver resolver = this.resource.getResourceResolver();
                    Session session = (Session)resolver.adaptTo(Session.class);
                    try {
                        FileHandle file;
                        Node node = session.getNodeByIdentifier(uuid);
                        if (node != null && (file = new FileHandle(resolver.getResource(node.getPath()))).isValid()) {
                            content = file.getContent();
                        }
                    }
                    catch (RepositoryException rex) {
                        this.LOG.error(rex.getMessage(), (Throwable)rex);
                    }
                }
            } else {
                ResourceResolver resolver;
                Resource referenced;
                FileHandle file;
                String fileRef = this.resource.getProperty("fileReference", "");
                if (StringUtils.isNotBlank((CharSequence)fileRef) && (file = new FileHandle(referenced = (resolver = this.resource.getResourceResolver()).getResource(fileRef))).isValid()) {
                    content = file.getContent();
                }
            }
        }
        return ResourceHandle.use(content);
    }

    protected void retrieveNameAndExt() {
        if (this.resource != null) {
            this.name = this.resource.getName();
            int lastDot = this.name.lastIndexOf(46);
            if (lastDot > 0) {
                this.extension = this.name.substring(lastDot + 1);
                this.name = this.name.substring(0, lastDot);
            } else {
                this.extension = "";
            }
        }
    }

    public String toString() {
        return "FileHandle, " + (this.isValid() ? this.resource.getPath() : "<invalid: " + this.resource + ">");
    }

    static {
        CRUD_FILE_PROPS.put("jcr:primaryType", "nt:file");
        CRUD_CONTENT_PROPS = new HashMap<String, Object>();
        CRUD_CONTENT_PROPS.put("jcr:primaryType", "nt:resource");
    }
}

