/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.handle;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.core.ResourceHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

public class ClientlibResourceFolder
implements ClientlibElement {
    public static final String PROP_EXPANDED = "expanded";
    public static final String PROP_OPTIONAL = "optional";
    public static final String PROP_DEPENDS = "depends";
    public static final String PROP_EMBED = "embed";
    public final ResourceHandle resource;
    protected final ClientlibResourceFolder parent;
    protected Map<String, String> additionalProperties;
    protected final Clientlib.Type type;
    protected Boolean expanded;
    protected Boolean optional;

    public ClientlibResourceFolder(Clientlib.Type type, Resource resource) {
        this(type, resource, null);
    }

    protected ClientlibResourceFolder(Clientlib.Type type, Resource resource, ClientlibResourceFolder parent) {
        this.type = type;
        this.resource = ResourceHandle.use(resource);
        this.parent = parent;
    }

    public boolean isValid() {
        return this.resource.isValid();
    }

    public boolean getExpanded() {
        if (null == this.expanded) {
            this.expanded = this.resource.getProperty(PROP_EXPANDED, Boolean.class);
        }
        if (null == this.expanded && null != this.parent) {
            this.expanded = this.parent.getExpanded();
        }
        if (null == this.expanded) {
            this.expanded = false;
        }
        return this.expanded;
    }

    public boolean getOptional() {
        if (null == this.optional) {
            this.optional = this.resource.getProperty(PROP_OPTIONAL, Boolean.class);
        }
        if (null == this.optional && null != this.parent) {
            this.optional = this.parent.getOptional();
        }
        if (null == this.optional) {
            this.optional = false;
        }
        return this.optional;
    }

    public List<ClientlibRef> getDependencies() {
        return this.getClientlib2Refs(PROP_DEPENDS);
    }

    public List<ClientlibRef> getEmbedded() {
        return this.getClientlib2Refs(PROP_EMBED);
    }

    @Override
    public Clientlib.Type getType() {
        return this.type;
    }

    protected List<ClientlibRef> getClientlib2Refs(String property) {
        ArrayList<ClientlibRef> res = new ArrayList<ClientlibRef>();
        for (String rule : this.resource.getProperty(property, new String[0])) {
            res.add(new ClientlibRef(this.type, rule.trim(), this.getOptional(), this.getAdditionalProperties()));
        }
        return res;
    }

    public List<ClientlibElement> getChildren() {
        ArrayList<ClientlibElement> children = new ArrayList<ClientlibElement>();
        for (Resource child : this.resource.getChildren()) {
            if (ClientlibResourceFolder.isFile(child)) {
                children.add(new ClientlibFile(null, this.type, child, this.getAdditionalProperties()));
                continue;
            }
            children.add(new ClientlibResourceFolder(this.type, child, this));
        }
        return children;
    }

    public Map<String, String> getAdditionalProperties() {
        if (null == this.additionalProperties) {
            this.additionalProperties = new HashMap<String, String>();
            ClientlibResourceFolder folder = this;
            while (null != folder) {
                for (String key : ClientlibLink.LINK_PROPERTIES) {
                    String property;
                    if (this.additionalProperties.containsKey(key) || null == (property = folder.resource.getProperty(key))) continue;
                    this.additionalProperties.put(key, property);
                }
                folder = folder.parent;
            }
        }
        return this.additionalProperties;
    }

    public static boolean isFile(Resource resource) {
        return resource.isResourceType("nt:file") || resource.isResourceType("nt:linkedFile");
    }

    @Override
    public void accept(ClientlibVisitor visitor, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
        visitor.visit(this, mode, parent);
    }

    public String toString() {
        return (Object)((Object)this.type) + ":" + this.resource.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientlibResourceFolder)) {
            return false;
        }
        ClientlibResourceFolder that = (ClientlibResourceFolder)o;
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.resource != null ? this.resource.getPath().hashCode() : 0;
        result = 92821 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public ClientlibLink makeLink() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public ClientlibRef getRef() {
        throw new UnsupportedOperationException("Not implemented.");
    }
}

