/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.handle;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientlibCategory
implements ClientlibElement {
    private static final Logger LOG = LoggerFactory.getLogger(ClientlibCategory.class);
    private final Clientlib.Type type;
    public final String category;
    public final boolean optional;
    public final List<Clientlib> clientlibs = new ArrayList<Clientlib>();

    public ClientlibCategory(ClientlibRef ref, List<Resource> clientlibResources) {
        this.category = ref.category;
        this.optional = ref.optional;
        this.type = ref.type;
        for (Resource resource : clientlibResources) {
            Clientlib clientlib = new Clientlib(this.getType(), resource);
            if (clientlib.isValid()) {
                this.clientlibs.add(clientlib);
                continue;
            }
            LOG.warn("Invalid clientlib for category {}: {}", (Object)this.category, (Object)resource);
        }
    }

    @Override
    public void accept(ClientlibVisitor visitor, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
        visitor.visit(this, mode, parent);
    }

    @Override
    public ClientlibRef getRef() {
        return new ClientlibRef(this.getType(), "category:" + this.category, this.optional, null);
    }

    public String toString() {
        return "category:" + this.category + this.clientlibs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientlibCategory)) {
            return false;
        }
        ClientlibCategory that = (ClientlibCategory)o;
        if (this.getType() != that.getType()) {
            return false;
        }
        return this.category != null ? this.category.equals(that.category) : that.category == null;
    }

    public int hashCode() {
        int result = this.getType() != null ? this.getType().hashCode() : 0;
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        return result;
    }

    @Override
    public ClientlibLink makeLink() {
        return ClientlibLink.forCategory(this.getType(), this.category);
    }

    @Override
    public Clientlib.Type getType() {
        return this.type;
    }
}

