/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;

public interface RestrictionProvider {
    public static final RestrictionProvider EMPTY = new RestrictionProvider(){

        @Override
        @Nonnull
        public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
            return Collections.emptySet();
        }

        @Override
        @Nonnull
        public Restriction createRestriction(@Nullable String oakPath, @Nonnull String oakName, @Nonnull Value value) throws AccessControlException, RepositoryException {
            throw new AccessControlException("This implementation doesn't support any restrictions");
        }

        @Override
        @Nonnull
        public Restriction createRestriction(@Nullable String oakPath, @Nonnull String oakName, Value ... values) throws AccessControlException, RepositoryException {
            throw new AccessControlException("This implementation doesn't support any restrictions");
        }

        @Override
        @Nonnull
        public Set<Restriction> readRestrictions(@Nullable String oakPath, @Nonnull Tree aceTree) {
            return Collections.emptySet();
        }

        @Override
        public void writeRestrictions(String oakPath, Tree aceTree, Set<Restriction> restrictions) {
        }

        @Override
        public void validateRestrictions(@Nullable String oakPath, @Nonnull Tree aceTree) {
        }

        @Override
        @Nonnull
        public RestrictionPattern getPattern(@Nullable String oakPath, @Nonnull Tree tree) {
            return RestrictionPattern.EMPTY;
        }

        @Override
        @Nonnull
        public RestrictionPattern getPattern(@Nullable String oakPath, @Nonnull Set<Restriction> restrictions) {
            return RestrictionPattern.EMPTY;
        }
    };

    @Nonnull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String var1);

    @Nonnull
    public Restriction createRestriction(@Nullable String var1, @Nonnull String var2, @Nonnull Value var3) throws AccessControlException, RepositoryException;

    @Nonnull
    public Restriction createRestriction(@Nullable String var1, @Nonnull String var2, Value ... var3) throws AccessControlException, RepositoryException;

    @Nonnull
    public Set<Restriction> readRestrictions(@Nullable String var1, @Nonnull Tree var2);

    public void writeRestrictions(String var1, Tree var2, Set<Restriction> var3) throws RepositoryException;

    public void validateRestrictions(@Nullable String var1, @Nonnull Tree var2) throws AccessControlException, RepositoryException;

    @Nonnull
    public RestrictionPattern getPattern(@Nullable String var1, @Nonnull Tree var2);

    @Nonnull
    public RestrictionPattern getPattern(@Nullable String var1, @Nonnull Set<Restriction> var2);
}

