/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util.fv;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.fv.LSHAnalyzer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimSearchUtils {
    private static final Logger log = LoggerFactory.getLogger(SimSearchUtils.class);

    public static String toDoubleString(byte[] bytes) {
        Double[] a = SimSearchUtils.toDoubleArray(bytes);
        StringBuilder builder = new StringBuilder();
        for (Double d : a) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(d);
        }
        return builder.toString();
    }

    private static Double[] toDoubleArray(byte[] array) {
        List<Double> doubles = SimSearchUtils.toDoubles(array);
        return doubles.toArray(new Double[doubles.size()]);
    }

    public static List<Double> toDoubles(byte[] array) {
        int blockSize = 8;
        ByteBuffer wrap = ByteBuffer.wrap(array);
        int capacity = array.length / blockSize;
        ArrayList<Double> doubles = new ArrayList<Double>(capacity);
        for (int i = 0; i < capacity; ++i) {
            double e = wrap.getDouble(i * blockSize);
            doubles.add(e);
        }
        return doubles;
    }

    private static Collection<String> getTokens(Analyzer analyzer, String field, String sampleTextString) throws IOException {
        LinkedList<String> tokens = new LinkedList<String>();
        TokenStream ts = analyzer.tokenStream(field, sampleTextString);
        ts.reset();
        ts.addAttribute(CharTermAttribute.class);
        while (ts.incrementToken()) {
            CharTermAttribute charTermAttribute = ts.getAttribute(CharTermAttribute.class);
            String token = new String(charTermAttribute.buffer(), 0, charTermAttribute.length());
            tokens.add(token);
        }
        ts.end();
        ts.close();
        return tokens;
    }

    static BooleanQuery getSimQuery(Analyzer analyzer, String fieldName, String text) throws IOException {
        Collection<String> tokens = SimSearchUtils.getTokens(analyzer, fieldName, text);
        BooleanQuery booleanQuery = new BooleanQuery(true);
        booleanQuery.setMinimumNumberShouldMatch(3);
        for (String token : tokens) {
            booleanQuery.add(new ConstantScoreQuery(new TermQuery(new Term(fieldName, token))), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    public static byte[] toByteArray(List<Double> values) {
        int blockSize = 8;
        byte[] bytes = new byte[values.size() * blockSize];
        int i = 0;
        int j = 0;
        while (i < values.size()) {
            ByteBuffer.wrap(bytes, j, blockSize).putDouble(values.get(i));
            ++i;
            j += blockSize;
        }
        return bytes;
    }

    public static byte[] toByteArray(String value) {
        LinkedList<Double> doubles = new LinkedList<Double>();
        for (String dv : value.split(",")) {
            doubles.add(Double.parseDouble(dv));
        }
        return SimSearchUtils.toByteArray(doubles);
    }

    public static Query getSimilarityQuery(List<PropertyDefinition> sp, IndexReader reader, String queryString) {
        try {
            log.debug("parsing similarity query on {}", (Object)queryString);
            BooleanQuery similarityQuery = null;
            String text = null;
            for (String param : queryString.split("&")) {
                String[] keyValuePair = param.split("=");
                if (keyValuePair.length != 2 || keyValuePair[0] == null || keyValuePair[1] == null) {
                    throw new RuntimeException("Unparsable native Lucene query for fv similarity: " + queryString);
                }
                if (!"stream.body".equals(keyValuePair[0])) continue;
                text = keyValuePair[1];
                break;
            }
            if (text != null && !sp.isEmpty()) {
                log.debug("generating similarity query for {}", text);
                BooleanQuery booleanQuery = new BooleanQuery(true);
                LSHAnalyzer analyzer = new LSHAnalyzer();
                IndexSearcher searcher = new IndexSearcher(reader);
                TermQuery q = new TermQuery(new Term(":path", text));
                TopDocs top = searcher.search((Query)q, 1);
                if (top.totalHits > 0) {
                    ScoreDoc d = top.scoreDocs[0];
                    Document doc = reader.document(d.doc);
                    for (PropertyDefinition pd : sp) {
                        log.debug("adding similarity clause for property {}", (Object)pd.name);
                        String similarityFieldName = FieldNames.createSimilarityFieldName(pd.name);
                        String fvString = doc.get(similarityFieldName);
                        if (fvString == null || fvString.trim().length() <= 0) continue;
                        log.trace("generating sim query on field {} and text {}", (Object)similarityFieldName, (Object)fvString);
                        BooleanQuery simQuery = SimSearchUtils.getSimQuery(analyzer, similarityFieldName, fvString);
                        booleanQuery.add(new BooleanClause(simQuery, BooleanClause.Occur.SHOULD));
                        log.trace("similarity query generated for {}", (Object)pd.name);
                    }
                }
                if (booleanQuery.clauses().size() > 0) {
                    similarityQuery = booleanQuery;
                    log.trace("final similarity query is {}", (Object)similarityQuery);
                }
            }
            return similarityQuery;
        }
        catch (Exception e) {
            throw new RuntimeException("could not handle similarity query " + queryString);
        }
    }
}

