/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionIndexProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionIndexProcessor.class);
    private String remaining;
    private static final PropertyState EMPTY_PROPERTY_STATE = EmptyPropertyState.emptyProperty((String)"empty", (Type)Type.STRINGS);

    private FunctionIndexProcessor(String function) {
        this.remaining = function;
    }

    public static String[] getProperties(String[] functionCode) {
        ArrayList<String> properties = new ArrayList<String>();
        for (String token : functionCode) {
            if (!token.startsWith("@")) continue;
            String propertyName = token.substring(1);
            properties.add(propertyName);
        }
        return properties.toArray(new String[0]);
    }

    public static PropertyState tryCalculateValue(String path, NodeState state, String[] functionCode) {
        ArrayDeque<PropertyState> stack = new ArrayDeque<PropertyState>();
        for (int i = functionCode.length - 1; i > 0; --i) {
            PropertyState ps;
            String token = functionCode[i];
            if (token.startsWith("@")) {
                String propertyName = token.substring(1);
                ps = FunctionIndexProcessor.getProperty(path, state, propertyName);
            } else {
                ps = FunctionIndexProcessor.calculateFunction(token, stack);
            }
            if (ps == null) {
                ps = EMPTY_PROPERTY_STATE;
            }
            stack.push(ps);
        }
        PropertyState ret = (PropertyState)stack.pop();
        return ret == EMPTY_PROPERTY_STATE ? null : ret;
    }

    public static String[] getFunctionCode(String functionDescription) {
        if (functionDescription == null) {
            return null;
        }
        return functionDescription.split("\\*");
    }

    private static PropertyState calculateFunction(String functionName, Deque<PropertyState> stack) {
        PropertyState result;
        PropertyState ps = stack.pop();
        if ("coalesce".equals(functionName)) {
            PropertyState ps2 = stack.pop();
            if (ps == EMPTY_PROPERTY_STATE) {
                ps = ps2;
            }
        }
        if (ps == EMPTY_PROPERTY_STATE) {
            return ps;
        }
        Type type = null;
        ArrayList<String> values = new ArrayList<String>(ps.count());
        for (int i = 0; i < ps.count(); ++i) {
            Object x;
            String s = (String)ps.getValue(Type.STRING, i);
            if ("lower".equals(functionName)) {
                x = s.toLowerCase();
                type = Type.STRING;
            } else if ("coalesce".equals(functionName)) {
                x = s;
                type = Type.STRING;
            } else if ("upper".equals(functionName)) {
                x = s.toUpperCase();
                type = Type.STRING;
            } else if ("length".equals(functionName)) {
                x = (long)s.length();
                type = Type.LONG;
            } else {
                LOG.debug("Unknown function {}", (Object)functionName);
                return null;
            }
            values.add((String)x);
        }
        if (values.size() == 1) {
            result = PropertyStates.createProperty((String)"value", values.get(0), (Type)type);
        } else {
            type = type.getArrayType();
            result = PropertyStates.createProperty((String)"value", values, (Type)type);
        }
        return result;
    }

    private static PropertyState getProperty(String path, NodeState state, String propertyName) {
        PropertyState ps;
        if (PathUtils.getDepth((String)propertyName) != 1) {
            for (String n : PathUtils.elements((String)PathUtils.getParentPath((String)propertyName))) {
                if ((state = state.getChildNode(n)).exists()) continue;
                return null;
            }
            propertyName = PathUtils.getName((String)propertyName);
        }
        if ((ps = ":localname".equals(propertyName) ? PropertyStates.createProperty((String)"value", (Object)FunctionIndexProcessor.getLocalName(PathUtils.getName((String)path)), (Type)Type.STRING) : (":name".equals(propertyName) ? PropertyStates.createProperty((String)"value", (Object)PathUtils.getName((String)path), (Type)Type.STRING) : state.getProperty(propertyName))) == null || ps.count() == 0) {
            return null;
        }
        return ps;
    }

    private static String getLocalName(String name) {
        int colon = name.indexOf(58);
        return colon < 0 ? name : name.substring(colon + 1);
    }

    public static String convertToPolishNotation(String function) {
        if (function == null) {
            return null;
        }
        FunctionIndexProcessor p = new FunctionIndexProcessor(function);
        return "function*" + p.parse();
    }

    String parse() {
        int comma;
        if (this.match("fn:local-name()") || this.match("localname()")) {
            return "@:localname";
        }
        if (this.match("fn:name()") || this.match("name()")) {
            return "@:name";
        }
        if (this.match("fn:upper-case(") || this.match("upper(")) {
            return "upper*" + this.parse() + this.read(")");
        }
        if (this.match("fn:lower-case(") || this.match("lower(")) {
            return "lower*" + this.parse() + this.read(")");
        }
        if (this.match("fn:coalesce(") || this.match("coalesce(")) {
            return "coalesce*" + this.parse() + this.readCommaAndWhitespace() + this.parse() + this.read(")");
        }
        if (this.match("fn:string-length(") || this.match("length(")) {
            return "length*" + this.parse() + this.read(")");
        }
        if (this.match("[")) {
            String prop = this.remaining;
            int indexOfComma = this.remaining.indexOf(",");
            if (indexOfComma > 0) {
                prop = this.remaining.substring(0, indexOfComma);
            }
            prop = prop.substring(0, prop.lastIndexOf(93));
            this.remaining = this.remaining.substring(prop.length() + 1);
            return this.property(prop.replaceAll("]]", "]"));
        }
        String prop = this.remaining;
        int paren = this.remaining.indexOf(41);
        int end = comma = this.remaining.indexOf(44);
        if (paren >= 0) {
            int n = end = end < 0 ? paren : Math.min(end, paren);
        }
        if (end >= 0) {
            prop = this.remaining.substring(0, end);
        }
        this.remaining = this.remaining.substring(prop.length());
        return this.property(prop.replaceAll("@", ""));
    }

    String property(String p) {
        return "@" + p;
    }

    private String read(String string) {
        this.match(string);
        return "";
    }

    private String readCommaAndWhitespace() {
        while (this.match(" ")) {
        }
        this.match(",");
        while (this.match(" ")) {
        }
        return "*";
    }

    private boolean match(String string) {
        if (this.remaining.startsWith(string)) {
            this.remaining = this.remaining.substring(string.length());
            return true;
        }
        return false;
    }
}

