/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.HybridPropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.PropertyQuery;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

class PropertyIndexQuery
implements PropertyQuery {
    private final NodeBuilder builder;

    public PropertyIndexQuery(NodeBuilder builder) {
        this.builder = builder;
    }

    @Override
    public Iterable<String> getIndexedPaths(String propertyRelativePath, String value) {
        NodeBuilder idxb = this.getIndexNode(propertyRelativePath);
        Preconditions.checkState((boolean)"unique".equals(idxb.getString("storageType")));
        NodeBuilder entry = idxb.child(value);
        return (Iterable)entry.getProperty("entry").getValue(Type.STRINGS);
    }

    private NodeBuilder getIndexNode(String propertyRelativePath) {
        NodeBuilder propertyIndex = this.builder.child(":property-index");
        String nodeName = HybridPropertyIndexUtil.getNodeName(propertyRelativePath);
        return propertyIndex.child(nodeName);
    }
}

