/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.PropertyQuery;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.PathStoredFieldVisitor;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexPropertyQuery
implements PropertyQuery {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexPropertyQuery.class);
    private final IndexTracker tracker;
    private final String indexPath;

    public LuceneIndexPropertyQuery(IndexTracker tracker, String indexPath) {
        this.tracker = tracker;
        this.indexPath = indexPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getIndexedPaths(String propertyRelativePath, String value) {
        ArrayList<String> indexPaths = new ArrayList<String>(2);
        IndexNode indexNode = this.tracker.acquireIndexNode(this.indexPath);
        if (indexNode != null) {
            try {
                TermQuery query = new TermQuery(new Term(propertyRelativePath, value));
                TopDocs docs = indexNode.getSearcher().search((Query)query, 10);
                IndexReader reader = indexNode.getSearcher().getIndexReader();
                for (ScoreDoc d : docs.scoreDocs) {
                    PathStoredFieldVisitor visitor = new PathStoredFieldVisitor();
                    reader.document(d.doc, visitor);
                    indexPaths.add(visitor.getPath());
                }
            }
            catch (IOException e) {
                log.warn("Error occurred while checking index {} for unique value [{}] for [{}]", new Object[]{this.indexPath, value, propertyRelativePath, e});
            }
            finally {
                indexNode.release();
            }
        }
        return indexPaths;
    }
}

