/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexMeta;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.MultiplexersLucene;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;

public class LuceneIndexDumper {
    private final NodeState rootState;
    private final String indexPath;
    private final File baseDir;
    private long size;
    private File indexDir;

    public LuceneIndexDumper(NodeState rootState, String indexPath, File baseDir) {
        this.rootState = rootState;
        this.indexPath = indexPath;
        this.baseDir = baseDir;
    }

    public void dump() throws IOException {
        try (Closer closer = Closer.create();){
            NodeState idx = NodeStateUtils.getNode((NodeState)this.rootState, (String)this.indexPath);
            IndexDefinition defn = IndexDefinition.newBuilder(this.rootState, idx, this.indexPath).build();
            this.indexDir = DirectoryUtils.createIndexDir(this.baseDir, this.indexPath);
            IndexMeta meta = new IndexMeta(this.indexPath);
            for (String dirName : idx.getChildNodeNames()) {
                if (!NodeStateUtils.isHidden((String)dirName) || !MultiplexersLucene.isIndexDirName(dirName) && !MultiplexersLucene.isSuggestIndexDirName(dirName)) continue;
                this.copyContent(idx, defn, meta, this.indexDir, dirName, closer);
            }
            DirectoryUtils.writeMeta(this.indexDir, meta);
        }
    }

    public long getSize() {
        return this.size;
    }

    public File getIndexDir() {
        return this.indexDir;
    }

    private void copyContent(NodeState idx, IndexDefinition defn, IndexMeta meta, File dir, String dirName, Closer closer) throws IOException {
        File idxDir = DirectoryUtils.createSubDir(dir, dirName);
        meta.addDirectoryMapping(dirName, idxDir.getName());
        OakDirectory sourceDir = new OakDirectory((NodeBuilder)new ReadOnlyBuilder(idx), dirName, defn, true);
        FSDirectory targetDir = FSDirectory.open(idxDir);
        closer.register((Closeable)sourceDir);
        closer.register((Closeable)targetDir);
        for (String file : ((Directory)sourceDir).listAll()) {
            sourceDir.copy(targetDir, file, file, IOContext.DEFAULT);
            this.size += ((Directory)sourceDir).fileLength(file);
        }
    }
}

