/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexMeta;

public final class LocalIndexDir
implements Comparable<LocalIndexDir> {
    final File dir;
    final IndexMeta indexMeta;

    public LocalIndexDir(File dir) throws IOException {
        this.dir = dir.getCanonicalFile();
        File indexDetails = new File(dir, "index-details.txt");
        Preconditions.checkState((boolean)LocalIndexDir.isIndexDir(dir), (String)"No file [%s] found in dir [%s]", (Object[])new Object[]{"index-details.txt", dir.getAbsolutePath()});
        this.indexMeta = new IndexMeta(indexDetails);
    }

    public long size() {
        return FileUtils.sizeOfDirectory((File)this.dir);
    }

    public boolean isEmpty() {
        String[] listing = this.dir.list();
        if (listing == null) {
            return false;
        }
        return listing.length == 1;
    }

    public String getJcrPath() {
        return this.indexMeta.indexPath;
    }

    public String getFSPath() {
        return this.dir.getAbsolutePath();
    }

    @Override
    public int compareTo(LocalIndexDir o) {
        return this.indexMeta.compareTo(o.indexMeta);
    }

    public String toString() {
        return String.format("%s (%s)", this.dir.getAbsolutePath(), this.indexMeta);
    }

    static boolean isIndexDir(File file) {
        File indexDetails = new File(file, "index-details.txt");
        return indexDetails.exists();
    }
}

