/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.ActiveDeletedBlobCollectorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.BufferedOakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakDirectory;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NoLockFactory;

public class DefaultDirectoryFactory
implements DirectoryFactory {
    private final IndexCopier indexCopier;
    private final GarbageCollectableBlobStore blobStore;
    private final ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback;

    public DefaultDirectoryFactory(@Nullable IndexCopier indexCopier, @Nullable GarbageCollectableBlobStore blobStore) {
        this(indexCopier, blobStore, ActiveDeletedBlobCollectorFactory.BlobDeletionCallback.NOOP);
    }

    public DefaultDirectoryFactory(@Nullable IndexCopier indexCopier, @Nullable GarbageCollectableBlobStore blobStore, @Nonnull ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback) {
        this.indexCopier = indexCopier;
        this.blobStore = blobStore;
        this.blobDeletionCallback = blobDeletionCallback;
    }

    @Override
    public Directory newInstance(IndexDefinition definition, NodeBuilder builder, String dirName, boolean reindex) throws IOException {
        Directory directory = this.newIndexDirectory(definition, builder, dirName);
        if (!(this.indexCopier == null || ":suggest-data".equals(dirName) && definition.getUniqueId() == null)) {
            directory = this.indexCopier.wrapForWrite(definition, directory, reindex, dirName);
        }
        return directory;
    }

    @Override
    public boolean remoteDirectory() {
        return this.indexCopier == null;
    }

    private Directory newIndexDirectory(IndexDefinition indexDefinition, NodeBuilder definition, String dirName) throws IOException {
        String path = null;
        if ("file".equalsIgnoreCase(definition.getString("persistence"))) {
            path = definition.getString("path");
        }
        if (path == null) {
            if (!this.remoteDirectory()) {
                return new BufferedOakDirectory(definition, dirName, indexDefinition, (BlobStore)this.blobStore, this.blobDeletionCallback);
            }
            return new OakDirectory(definition, dirName, indexDefinition, false, this.blobStore, this.blobDeletionCallback);
        }
        File file = new File(path);
        file.mkdirs();
        return FSDirectory.open(file, NoLockFactory.getNoLockFactory());
    }
}

