/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.lucene.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexEditor
implements IndexEditor,
Aggregate.AggregateRoot {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditor.class);
    public static final String TEXT_EXTRACTION_ERROR = "TextExtractionError";
    private final LuceneIndexEditorContext context;
    private final String name;
    private final LuceneIndexEditor parent;
    private String path;
    private boolean propertiesChanged = false;
    private List<PropertyState> propertiesModified = Lists.newArrayList();
    private final boolean isDeleted;
    private IndexDefinition.IndexingRule indexingRule;
    private List<Aggregate.Matcher> currentMatchers = Collections.emptyList();
    private final MatcherState matcherState;
    private final PathFilter.Result pathFilterResult;

    LuceneIndexEditor(LuceneIndexEditorContext context) throws CommitFailedException {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.context = context;
        this.isDeleted = false;
        this.matcherState = MatcherState.NONE;
        this.pathFilterResult = context.getDefinition().getPathFilter().filter("/");
    }

    private LuceneIndexEditor(LuceneIndexEditor parent, String name, MatcherState matcherState, PathFilter.Result pathFilterResult, boolean isDeleted) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.context = parent.context;
        this.isDeleted = isDeleted;
        this.matcherState = matcherState;
        this.pathFilterResult = pathFilterResult;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat((String)this.parent.getPath(), (String)this.name);
        }
        return this.path;
    }

    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        if (EmptyNodeState.MISSING_NODE == before && this.parent == null) {
            this.context.enableReindexMode();
        }
        if (this.pathFilterResult == PathFilter.Result.INCLUDE) {
            NodeState current = after.exists() ? after : before;
            this.indexingRule = this.getDefinition().getApplicableIndexingRule(current);
            if (this.indexingRule != null) {
                this.currentMatchers = this.indexingRule.getAggregate().createMatchers(this);
            }
        }
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        long indexed;
        Object path;
        if ((this.propertiesChanged || !before.exists()) && this.addOrUpdate((String)(path = this.getPath()), after, before.exists()) && (indexed = this.context.incIndexedNodes()) % 1000L == 0L) {
            log.debug("[{}] => Indexed {} nodes...", (Object)this.getIndexName(), (Object)indexed);
        }
        for (Aggregate.Matcher m : this.matcherState.affectedMatchers) {
            m.markRootDirty();
        }
        if (this.parent == null) {
            PropertyUpdateCallback callback = this.context.getPropertyUpdateCallback();
            if (callback != null) {
                callback.done();
            }
            try {
                this.context.closeWriter();
            }
            catch (IOException e) {
                CommitFailedException ce = new CommitFailedException("Lucene", 4, "Failed to close the Lucene index " + this.context.getIndexingContext().getIndexPath(), (Throwable)e);
                this.context.getIndexingContext().indexUpdateFailed((Exception)((Object)ce));
                throw ce;
            }
            if (this.context.getIndexedNodes() > 0L) {
                log.debug("[{}] => Indexed {} nodes, done.", (Object)this.getIndexName(), (Object)this.context.getIndexedNodes());
            }
        }
    }

    public void propertyAdded(PropertyState after) {
        this.markPropertyChanged(after.getName());
        this.checkAggregates(after.getName());
        this.propertyUpdated(null, after);
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
        this.markPropertyChanged(before.getName());
        this.propertiesModified.add(before);
        this.checkAggregates(before.getName());
        this.propertyUpdated(before, after);
    }

    public void propertyDeleted(PropertyState before) {
        this.markPropertyChanged(before.getName());
        this.propertiesModified.add(before);
        this.checkAggregates(before.getName());
        this.propertyUpdated(before, null);
    }

    public Editor childNodeAdded(String name, NodeState after) {
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult != PathFilter.Result.EXCLUDE) {
            return new LuceneIndexEditor(this, name, this.getMatcherState(name, after), filterResult, false);
        }
        return null;
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult != PathFilter.Result.EXCLUDE) {
            return new LuceneIndexEditor(this, name, this.getMatcherState(name, after), filterResult, false);
        }
        return null;
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        MatcherState ms;
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult == PathFilter.Result.EXCLUDE) {
            return null;
        }
        if (!this.isDeleted) {
            String path = PathUtils.concat((String)this.getPath(), (String)name);
            try {
                LuceneIndexWriter writer = this.context.getWriter();
                writer.deleteDocuments(path);
                this.context.indexUpdate();
            }
            catch (IOException e) {
                CommitFailedException ce = new CommitFailedException("Lucene", 5, "Failed to remove the index entries of the removed subtree " + path + "for index " + this.context.getIndexingContext().getIndexPath(), (Throwable)e);
                this.context.getIndexingContext().indexUpdateFailed((Exception)((Object)ce));
                throw ce;
            }
        }
        if (!(ms = this.getMatcherState(name, before)).isEmpty()) {
            return new LuceneIndexEditor(this, name, ms, filterResult, true);
        }
        return null;
    }

    LuceneIndexEditorContext getContext() {
        return this.context;
    }

    private boolean addOrUpdate(String path, NodeState state, boolean isUpdate) throws CommitFailedException {
        try {
            Document d = this.makeDocument(path, state, isUpdate);
            if (d != null) {
                if (log.isTraceEnabled()) {
                    log.trace("[{}] Indexed document for {} is {}", new Object[]{this.getIndexName(), path, d});
                }
                this.context.indexUpdate();
                this.context.getWriter().updateDocument(path, d);
                return true;
            }
        }
        catch (IOException e) {
            CommitFailedException ce = new CommitFailedException("Lucene", 3, "Failed to index the node " + path, (Throwable)e);
            this.context.getIndexingContext().indexUpdateFailed((Exception)((Object)ce));
            throw ce;
        }
        catch (IllegalArgumentException ie) {
            log.warn("Failed to index the node [{}]", (Object)path, (Object)ie);
        }
        return false;
    }

    private Document makeDocument(String path, NodeState state, boolean isUpdate) throws IOException {
        if (!this.isIndexable()) {
            return null;
        }
        return this.context.newDocumentMaker(this.indexingRule, path).makeDocument(state, isUpdate, this.propertiesModified);
    }

    @Override
    public void markDirty() {
        this.propertiesChanged = true;
    }

    private MatcherState getMatcherState(String name, NodeState after) {
        ArrayList matched = Lists.newArrayList();
        ArrayList inherited = Lists.newArrayList();
        for (Aggregate.Matcher m : Iterables.concat(this.matcherState.inherited, this.currentMatchers)) {
            Aggregate.Matcher result = m.match(name, after);
            if (result.getStatus() == Aggregate.Matcher.Status.MATCH_FOUND) {
                matched.add(result);
            }
            if (result.getStatus() == Aggregate.Matcher.Status.FAIL) continue;
            inherited.addAll(result.nextSet());
        }
        if (!matched.isEmpty() || !inherited.isEmpty()) {
            return new MatcherState(matched, inherited);
        }
        return MatcherState.NONE;
    }

    private void checkAggregates(String name) {
        for (Aggregate.Matcher m : this.matcherState.matched) {
            if (this.matcherState.affectedMatchers.contains(m) || !m.aggregatesProperty(name)) continue;
            this.matcherState.affectedMatchers.add(m);
        }
    }

    private void markPropertyChanged(String name) {
        if (this.isIndexable() && !this.propertiesChanged && this.indexingRule.isIndexed(name)) {
            this.propertiesChanged = true;
        }
    }

    private void propertyUpdated(PropertyState before, PropertyState after) {
        PropertyDefinition pd;
        String propertyName;
        PropertyUpdateCallback callback = this.context.getPropertyUpdateCallback();
        if (callback == null) {
            return;
        }
        String string = propertyName = before != null ? before.getName() : after.getName();
        if (this.isIndexable() && (pd = this.indexingRule.getConfig(propertyName)) != null) {
            callback.propertyUpdated(this.getPath(), propertyName, pd, before, after);
        }
        for (Aggregate.Matcher m : this.matcherState.matched) {
            Aggregate.Include i;
            if (!m.aggregatesProperty(propertyName) || !((i = m.getCurrentInclude()) instanceof Aggregate.PropertyInclude)) continue;
            PropertyDefinition pd2 = ((Aggregate.PropertyInclude)i).getPropertyDefinition();
            String propertyRelativePath = PathUtils.concat((String)m.getMatchedPath(), (String)propertyName);
            callback.propertyUpdated(m.getRootPath(), propertyRelativePath, pd2, before, after);
        }
    }

    private IndexDefinition getDefinition() {
        return this.context.getDefinition();
    }

    private boolean isIndexable() {
        return this.indexingRule != null;
    }

    private PathFilter.Result getPathFilterResult(String childNodeName) {
        return this.context.getDefinition().getPathFilter().filter(PathUtils.concat((String)this.getPath(), (String)childNodeName));
    }

    private String getIndexName() {
        return this.context.getDefinition().getIndexName();
    }

    private static class MatcherState {
        static final MatcherState NONE = new MatcherState(Collections.emptyList(), Collections.emptyList());
        final List<Aggregate.Matcher> matched;
        final List<Aggregate.Matcher> inherited;
        final Set<Aggregate.Matcher> affectedMatchers;

        public MatcherState(List<Aggregate.Matcher> matched, List<Aggregate.Matcher> inherited) {
            this.matched = matched;
            this.inherited = inherited;
            this.affectedMatchers = matched.isEmpty() ? Collections.emptySet() : Sets.newIdentityHashSet();
        }

        public boolean isEmpty() {
            return this.matched.isEmpty() && this.inherited.isEmpty();
        }
    }
}

