/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.binary.BinaryTextExtractor;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetsConfigProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FunctionIndexProcessor;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneDocumentMaker {
    private static final Logger log = LoggerFactory.getLogger(LuceneDocumentMaker.class);
    private final BinaryTextExtractor textExtractor;
    private final FacetsConfigProvider facetsConfigProvider;
    private final IndexDefinition definition;
    private final IndexDefinition.IndexingRule indexingRule;
    private final IndexAugmentorFactory augmentorFactory;
    private final String path;

    public LuceneDocumentMaker(@Nonnull IndexDefinition definition, @Nonnull IndexDefinition.IndexingRule indexingRule, @Nonnull String path) {
        this(null, null, null, definition, indexingRule, path);
    }

    public LuceneDocumentMaker(@Nullable BinaryTextExtractor textExtractor, @Nullable FacetsConfigProvider facetsConfigProvider, @Nullable IndexAugmentorFactory augmentorFactory, @Nonnull IndexDefinition definition, @Nonnull IndexDefinition.IndexingRule indexingRule, @Nonnull String path) {
        this.textExtractor = textExtractor;
        this.facetsConfigProvider = facetsConfigProvider;
        this.definition = (IndexDefinition)Preconditions.checkNotNull((Object)definition);
        this.indexingRule = (IndexDefinition.IndexingRule)Preconditions.checkNotNull((Object)indexingRule);
        this.augmentorFactory = augmentorFactory;
        this.path = (String)Preconditions.checkNotNull((Object)path);
    }

    @CheckForNull
    public Document makeDocument(NodeState state) throws IOException {
        return this.makeDocument(state, false, Collections.emptyList());
    }

    @CheckForNull
    public Document makeDocument(NodeState state, boolean isUpdate, List<PropertyState> propertiesModified) throws IOException {
        boolean facet = false;
        ArrayList<Field> fields = new ArrayList<Field>();
        boolean dirty = false;
        StringPropertyState nodenamePS = new StringPropertyState(":nodeName", PathUtils.getName((String)this.path));
        for (PropertyState property : Iterables.concat((Iterable)state.getProperties(), Collections.singleton(nodenamePS))) {
            PropertyDefinition pd;
            String pname = property.getName();
            if (!LuceneDocumentMaker.isVisible(pname) && !":nodeName".equals(pname) || (pd = this.indexingRule.getConfig(pname)) == null || !pd.index) continue;
            if (pd.ordered) {
                dirty |= this.addTypedOrderedFields(fields, property, pname, pd);
            }
            dirty |= this.indexProperty(this.path, fields, state, property, pname, pd);
            facet |= pd.facet;
        }
        boolean[] dirties = this.indexAggregates(this.path, fields, state);
        dirty |= dirties[0];
        facet |= dirties[1];
        dirty |= this.indexNullCheckEnabledProps(this.path, fields, state);
        dirty |= this.indexFunctionRestrictions(this.path, fields, state);
        dirty |= this.indexNotNullCheckEnabledProps(this.path, fields, state);
        if (!(dirty |= this.augmentCustomFields(this.path, fields, state))) {
            dirty = this.indexIfSinglePropertyRemoved(propertiesModified);
        }
        if (isUpdate && !dirty) {
            return null;
        }
        String name = PathUtils.getName((String)this.path);
        if (this.indexingRule.isNodeNameIndexed()) {
            LuceneDocumentMaker.addNodeNameField(fields, name);
            dirty = true;
        }
        if (!this.indexingRule.indexesAllNodesOfMatchingType() && !dirty) {
            return null;
        }
        Document document = new Document();
        document.add(FieldFactory.newPathField(this.path));
        if (this.indexingRule.isFulltextEnabled()) {
            document.add(FieldFactory.newFulltextField(name));
        }
        if (this.definition.evaluatePathRestrictions()) {
            document.add(FieldFactory.newAncestorsField(PathUtils.getParentPath((String)this.path)));
            document.add(FieldFactory.newDepthField(this.path));
        }
        Field suggestField = null;
        for (Field f : fields) {
            if (":suggest".equals(f.name())) {
                if (suggestField == null) {
                    suggestField = FieldFactory.newSuggestField(f.stringValue());
                    continue;
                }
                suggestField = FieldFactory.newSuggestField(suggestField.stringValue(), f.stringValue());
                continue;
            }
            document.add(f);
        }
        if (suggestField != null) {
            document.add(suggestField);
        }
        if (facet && this.isFacetingEnabled()) {
            document = this.getFacetsConfig().build(document);
        }
        return document;
    }

    private boolean addFacetFields(List<Field> fields, PropertyState property, String pname, PropertyDefinition pd) {
        String facetFieldName = FieldNames.createFacetFieldName(pname);
        this.getFacetsConfig().setIndexFieldName(pname, facetFieldName);
        int tag = property.getType().tag();
        int idxDefinedTag = pd.getType();
        if (tag != idxDefinedTag) {
            log.debug("[{}] Facet property defined with type {} differs from property {} with type {} in path {}", new Object[]{this.getIndexName(), Type.fromTag((int)idxDefinedTag, (boolean)false), property.toString(), Type.fromTag((int)tag, (boolean)false), this.path});
            tag = idxDefinedTag;
        }
        boolean fieldAdded = false;
        try {
            String value;
            if (tag == Type.STRINGS.tag() && property.isArray()) {
                this.getFacetsConfig().setMultiValued(pname, true);
                Iterable values = (Iterable)property.getValue(Type.STRINGS);
                for (String value2 : values) {
                    if (value2 == null || value2.length() <= 0) continue;
                    fields.add(new SortedSetDocValuesFacetField(pname, value2));
                }
                fieldAdded = true;
            } else if (tag == Type.STRING.tag() && (value = (String)property.getValue(Type.STRING)).length() > 0) {
                fields.add(new SortedSetDocValuesFacetField(pname, value));
                fieldAdded = true;
            }
        }
        catch (Throwable e) {
            log.warn("[{}] Ignoring facet property. Could not convert property {} of type {} to type {} for path {}", new Object[]{this.getIndexName(), pname, Type.fromTag((int)property.getType().tag(), (boolean)false), Type.fromTag((int)tag, (boolean)false), this.path, e});
        }
        return fieldAdded;
    }

    private boolean indexProperty(String path, List<Field> fields, NodeState state, PropertyState property, String pname, PropertyDefinition pd) {
        boolean includeTypeForFullText = this.indexingRule.includePropertyType(property.getType().tag());
        boolean dirty = false;
        if (Type.BINARY.tag() == property.getType().tag() && pd.useInSimilarity) {
            try {
                log.trace("indexing similarity binaries for {}", (Object)pd.name);
                fields.addAll(FieldFactory.newSimilarityFields(pd.name, (Blob)property.getValue(Type.BINARY)));
                dirty = true;
            }
            catch (Exception e) {
                log.error("could not index similarity field for property {} and definition {}", (Object)property, (Object)pd);
            }
        } else if (Type.BINARY.tag() == property.getType().tag() && includeTypeForFullText) {
            fields.addAll(this.newBinary(property, state, null, path + "@" + pname));
            dirty = true;
        } else {
            if (pd.propertyIndex && pd.includePropertyType(property.getType().tag())) {
                dirty |= this.addTypedFields(fields, property, pname, pd);
            }
            if (pd.fulltextEnabled() && includeTypeForFullText) {
                for (String value : (Iterable)property.getValue(Type.STRINGS)) {
                    if (!this.includePropertyValue(value, pd)) continue;
                    if (pd.analyzed && pd.includePropertyType(property.getType().tag())) {
                        String analyzedPropName = this.constructAnalyzedPropertyName(pname);
                        fields.add(FieldFactory.newPropertyField(analyzedPropName, value, !pd.skipTokenization(pname), pd.stored));
                    }
                    if (pd.useInSuggest) {
                        fields.add(FieldFactory.newSuggestField(value));
                    }
                    if (pd.useInSpellcheck) {
                        fields.add(FieldFactory.newPropertyField(":spellcheck", value, true, false));
                    }
                    if (pd.nodeScopeIndex) {
                        Field field = FieldFactory.newFulltextField(value);
                        fields.add(field);
                        if (pd.useInSimilarity) {
                            log.trace("indexing similarity strings for {}", (Object)pd.name);
                            fields.addAll(FieldFactory.newSimilarityFields(pd.name, value));
                        }
                    }
                    dirty = true;
                }
            }
            if (pd.facet && this.isFacetingEnabled()) {
                dirty |= this.addFacetFields(fields, property, pname, pd);
            }
        }
        return dirty;
    }

    private String constructAnalyzedPropertyName(String pname) {
        if (this.definition.getVersion().isAtLeast(IndexFormatVersion.V2)) {
            return FieldNames.createAnalyzedFieldName(pname);
        }
        return pname;
    }

    private boolean addTypedFields(List<Field> fields, PropertyState property, String pname, PropertyDefinition pd) {
        int tag = property.getType().tag();
        boolean fieldAdded = false;
        for (int i = 0; i < property.count(); ++i) {
            Field f;
            if (tag == Type.LONG.tag()) {
                f = new LongField(pname, (long)((Long)property.getValue(Type.LONG, i)), Field.Store.NO);
            } else if (tag == Type.DATE.tag()) {
                String date = (String)property.getValue(Type.DATE, i);
                f = new LongField(pname, (long)FieldFactory.dateToLong(date), Field.Store.NO);
            } else {
                f = tag == Type.DOUBLE.tag() ? new DoubleField(pname, (double)((Double)property.getValue(Type.DOUBLE, i)), Field.Store.NO) : (tag == Type.BOOLEAN.tag() ? new StringField(pname, ((Boolean)property.getValue(Type.BOOLEAN, i)).toString(), Field.Store.NO) : new StringField(pname, (String)property.getValue(Type.STRING, i), Field.Store.NO));
            }
            if (!this.includePropertyValue(property, i, pd)) continue;
            fields.add(f);
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean addTypedOrderedFields(List<Field> fields, PropertyState property, String pname, PropertyDefinition pd) {
        int idxDefinedTag;
        if (property.getType().isArray()) {
            log.warn("[{}] Ignoring ordered property {} of type {} for path {} as multivalued ordered property not supported", new Object[]{this.getIndexName(), pname, Type.fromTag((int)property.getType().tag(), (boolean)true), this.path});
            return false;
        }
        int tag = property.getType().tag();
        if (tag != (idxDefinedTag = pd.getType())) {
            log.debug("[{}] Ordered property defined with type {} differs from property {} with type {} in path {}", new Object[]{this.getIndexName(), Type.fromTag((int)idxDefinedTag, (boolean)false), property.toString(), Type.fromTag((int)tag, (boolean)false), this.path});
            tag = idxDefinedTag;
        }
        String name = FieldNames.createDocValFieldName(pname);
        boolean fieldAdded = false;
        Field f = null;
        try {
            if (tag == Type.LONG.tag()) {
                f = new NumericDocValuesField(name, (Long)property.getValue(Type.LONG));
            } else if (tag == Type.DATE.tag()) {
                String date = (String)property.getValue(Type.DATE);
                f = new NumericDocValuesField(name, FieldFactory.dateToLong(date));
            } else if (tag == Type.DOUBLE.tag()) {
                f = new DoubleDocValuesField(name, (Double)property.getValue(Type.DOUBLE));
            } else if (tag == Type.BOOLEAN.tag()) {
                f = new SortedDocValuesField(name, new BytesRef(((Boolean)property.getValue(Type.BOOLEAN)).toString()));
            } else if (tag == Type.STRING.tag()) {
                f = new SortedDocValuesField(name, new BytesRef((CharSequence)property.getValue(Type.STRING)));
            }
            if (f != null && this.includePropertyValue(property, 0, pd)) {
                fields.add(f);
                fieldAdded = true;
            }
        }
        catch (Exception e) {
            log.warn("[{}] Ignoring ordered property. Could not convert property {} of type {} to type {} for path {}", new Object[]{this.getIndexName(), pname, Type.fromTag((int)property.getType().tag(), (boolean)false), Type.fromTag((int)tag, (boolean)false), this.path, e});
        }
        return fieldAdded;
    }

    private boolean includePropertyValue(PropertyState property, int i, PropertyDefinition pd) {
        if (property.getType().tag() == 2) {
            return true;
        }
        if (pd.valuePattern.matchesAll()) {
            return true;
        }
        return this.includePropertyValue((String)property.getValue(Type.STRING, i), pd);
    }

    private boolean includePropertyValue(String value, PropertyDefinition pd) {
        return pd.valuePattern.matches(value);
    }

    private static boolean isVisible(String name) {
        return name.charAt(0) != ':';
    }

    private List<Field> newBinary(PropertyState property, NodeState state, String nodePath, String path) {
        if (this.textExtractor == null) {
            return Collections.emptyList();
        }
        return this.textExtractor.newBinary(property, state, nodePath, path);
    }

    private boolean augmentCustomFields(String path, List<Field> fields, NodeState document) {
        boolean dirty = false;
        if (this.augmentorFactory != null) {
            Iterable<Field> augmentedFields = this.augmentorFactory.getIndexFieldProvider(this.indexingRule.getNodeTypeName()).getAugmentedFields(path, document, this.definition.getDefinitionNodeState());
            for (Field field : augmentedFields) {
                fields.add(field);
                dirty = true;
            }
        }
        return dirty;
    }

    private boolean indexNotNullCheckEnabledProps(String path, List<Field> fields, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getNotNullCheckEnabledProperties()) {
            if (!this.isPropertyNotNull(state, pd)) continue;
            fields.add(new StringField(":notNullProps", pd.name, Field.Store.NO));
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean indexNullCheckEnabledProps(String path, List<Field> fields, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getNullCheckEnabledProperties()) {
            if (!this.isPropertyNull(state, pd)) continue;
            fields.add(new StringField(":nullProps", pd.name, Field.Store.NO));
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean indexFunctionRestrictions(String path, List<Field> fields, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getFunctionRestrictions()) {
            PropertyState functionValue = LuceneDocumentMaker.calculateValue(path, state, pd.functionCode);
            if (functionValue == null) continue;
            if (pd.ordered) {
                this.addTypedOrderedFields(fields, functionValue, pd.function, pd);
            }
            this.addTypedFields(fields, functionValue, pd.function, pd);
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private static PropertyState calculateValue(String path, NodeState state, String[] functionCode) {
        try {
            return FunctionIndexProcessor.tryCalculateValue(path, state, functionCode);
        }
        catch (RuntimeException e) {
            log.error("Failed to calculate function value for {} at {}", new Object[]{Arrays.toString(functionCode), path, e});
            throw e;
        }
    }

    private boolean indexIfSinglePropertyRemoved(List<PropertyState> propertiesModified) {
        boolean dirty = false;
        for (PropertyState ps : propertiesModified) {
            PropertyDefinition pd = this.indexingRule.getConfig(ps.getName());
            if (pd == null || !pd.index || !pd.includePropertyType(ps.getType().tag()) && !this.indexingRule.includePropertyType(ps.getType().tag())) continue;
            dirty = true;
            break;
        }
        return dirty;
    }

    private boolean isPropertyNull(NodeState state, PropertyDefinition pd) {
        NodeState propertyNode = LuceneDocumentMaker.getPropertyNode(state, pd);
        if (!propertyNode.exists()) {
            return false;
        }
        return !propertyNode.hasProperty(pd.nonRelativeName);
    }

    private boolean isPropertyNotNull(NodeState state, PropertyDefinition pd) {
        NodeState propertyNode = LuceneDocumentMaker.getPropertyNode(state, pd);
        if (!propertyNode.exists()) {
            return false;
        }
        return propertyNode.hasProperty(pd.nonRelativeName);
    }

    private static NodeState getPropertyNode(NodeState nodeState, PropertyDefinition pd) {
        if (!pd.relative) {
            return nodeState;
        }
        NodeState node = nodeState;
        for (String name : pd.ancestors) {
            node = node.getChildNode(name);
        }
        return node;
    }

    private boolean[] indexAggregates(final String path, final List<Field> fields, final NodeState state) {
        final AtomicBoolean dirtyFlag = new AtomicBoolean();
        final AtomicBoolean facetFlag = new AtomicBoolean();
        this.indexingRule.getAggregate().collectAggregates(state, new Aggregate.ResultCollector(){

            @Override
            public void onResult(Aggregate.NodeIncludeResult result) {
                boolean dirty = LuceneDocumentMaker.this.indexAggregatedNode(path, fields, result);
                if (dirty) {
                    dirtyFlag.set(true);
                }
            }

            @Override
            public void onResult(Aggregate.PropertyIncludeResult result) {
                boolean dirty = false;
                if (result.pd.ordered) {
                    dirty |= LuceneDocumentMaker.this.addTypedOrderedFields(fields, result.propertyState, result.propertyPath, result.pd);
                }
                dirty |= LuceneDocumentMaker.this.indexProperty(path, fields, state, result.propertyState, result.propertyPath, result.pd);
                if (result.pd.facet) {
                    facetFlag.set(true);
                }
                if (dirty) {
                    dirtyFlag.set(true);
                }
            }
        });
        return new boolean[]{dirtyFlag.get(), facetFlag.get()};
    }

    private boolean indexAggregatedNode(String path, List<Field> fields, Aggregate.NodeIncludeResult result) {
        IndexDefinition.IndexingRule ruleAggNode = this.definition.getApplicableIndexingRule(ConfigUtil.getPrimaryTypeName(result.nodeState));
        boolean dirty = false;
        for (PropertyState property : result.nodeState.getProperties()) {
            String pname = property.getName();
            String propertyPath = PathUtils.concat((String)result.nodePath, (String)pname);
            if (!LuceneDocumentMaker.isVisible(pname)) continue;
            int type = property.getType().tag();
            if (ruleAggNode == null ? !this.indexingRule.includePropertyType(type) : !ruleAggNode.includePropertyType(type)) continue;
            PropertyDefinition pdForRootNode = this.indexingRule.getConfig(propertyPath);
            if (pdForRootNode != null && (!pdForRootNode.index || pdForRootNode.excludeFromAggregate)) continue;
            if (Type.BINARY == property.getType()) {
                String aggreagtedNodePath = PathUtils.concat((String)path, (String)result.nodePath);
                String nodePath = result.isRelativeNode() ? result.rootIncludePath : null;
                fields.addAll(this.newBinary(property, result.nodeState, nodePath, aggreagtedNodePath + "@" + pname));
                dirty = true;
                continue;
            }
            PropertyDefinition pd = null;
            if (ruleAggNode != null) {
                pd = ruleAggNode.getConfig(pname);
            }
            if (pd != null && !pd.nodeScopeIndex) continue;
            for (String value : (Iterable)property.getValue(Type.STRINGS)) {
                Field field;
                Field field2 = field = result.isRelativeNode() ? FieldFactory.newFulltextField(result.rootIncludePath, value) : FieldFactory.newFulltextField(value);
                if (pd != null) {
                    field.setBoost(pd.boost);
                }
                fields.add(field);
                dirty = true;
            }
        }
        return dirty;
    }

    private String getIndexName() {
        return this.definition.getIndexName();
    }

    private boolean isFacetingEnabled() {
        return this.facetsConfigProvider != null;
    }

    private FacetsConfig getFacetsConfig() {
        return this.facetsConfigProvider.getFacetsConfig();
    }

    private static void addNodeNameField(List<Field> fields, String name) {
        int colon = name.indexOf(58);
        String value = colon < 0 ? name : name.substring(colon + 1);
        fields.add(new StringField(":nodeName", value, Field.Store.NO));
    }
}

