/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexStatistics;
import org.apache.jackrabbit.oak.plugins.index.lucene.LucenePropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetHelper;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePatternUtil;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexPlanner {
    private static final String FLAG_ENTRY_COUNT = "oak.lucene.useActualEntryCount";
    private static final Logger log = LoggerFactory.getLogger(IndexPlanner.class);
    private final IndexDefinition definition;
    private final Filter filter;
    private final String indexPath;
    private final List<QueryIndex.OrderEntry> sortOrder;
    private IndexNode indexNode;
    private PlanResult result;
    private static boolean useActualEntryCount = false;

    public IndexPlanner(IndexNode indexNode, String indexPath, Filter filter, List<QueryIndex.OrderEntry> sortOrder) {
        this.indexNode = indexNode;
        this.indexPath = indexPath;
        this.definition = indexNode.getDefinition();
        this.filter = filter;
        this.sortOrder = sortOrder;
    }

    QueryIndex.IndexPlan getPlan() {
        QueryIndex.IndexPlan.Builder builder = this.getPlanBuilder();
        if (this.definition.isTestMode()) {
            if (builder == null) {
                if (this.notSupportedFeature()) {
                    return null;
                }
                String msg = String.format("No plan found for filter [%s] while using definition [%s] and testMode is found to be enabled", this.filter, this.definition);
                throw new IllegalStateException(msg);
            }
            builder.setEstimatedEntryCount(1L).setCostPerExecution(0.001).setCostPerEntry(0.001);
        }
        return builder != null ? builder.build() : null;
    }

    public String toString() {
        return "IndexPlanner{indexPath='" + this.indexPath + '\'' + ", filter=" + this.filter + ", sortOrder=" + this.sortOrder + '}';
    }

    static void setUseActualEntryCount(boolean useActualEntryCount) {
        IndexPlanner.useActualEntryCount = useActualEntryCount;
    }

    private QueryIndex.IndexPlan.Builder getPlanBuilder() {
        log.trace("Evaluating plan with index definition {}", (Object)this.definition);
        if (this.wrongIndex()) {
            return null;
        }
        FullTextExpression ft = this.filter.getFullTextConstraint();
        if (!this.definition.getVersion().isAtLeast(IndexFormatVersion.V2)) {
            log.trace("Index is old format. Not supported");
            return null;
        }
        if (ft != null && !this.definition.isFullTextEnabled()) {
            return null;
        }
        IndexDefinition.IndexingRule indexingRule = this.getApplicableRule();
        if (indexingRule == null) {
            return null;
        }
        if (ft != null && !indexingRule.isFulltextEnabled()) {
            return null;
        }
        if (!this.checkForQueryPaths()) {
            log.trace("Opting out due mismatch between path restriction {} and query paths {}", (Object)this.filter.getPath(), (Object)this.definition.getQueryPaths());
            return null;
        }
        this.result = new PlanResult(this.indexPath, this.definition, indexingRule);
        if (this.definition.hasFunctionDefined() && this.filter.getPropertyRestriction(this.definition.getFunctionName()) != null) {
            return this.getNativeFunctionPlanBuilder(indexingRule.getBaseNodeType());
        }
        List<Object> indexedProps = Lists.newArrayListWithCapacity((int)this.filter.getPropertyRestrictions().size());
        for (PropertyDefinition functionIndex : indexingRule.getFunctionRestrictions()) {
            for (Object pr : this.filter.getPropertyRestrictions()) {
                String f = functionIndex.function;
                if (!((Filter.PropertyRestriction)pr).propertyName.equals(f)) continue;
                indexedProps.add(f);
                this.result.propDefns.put(f, functionIndex);
            }
        }
        LinkedList<String> facetFields = new LinkedList<String>();
        boolean ntBaseRule = "nt:base".equals(indexingRule.getNodeTypeName());
        HashMap<String, PropertyDefinition> relativePropDefns = new HashMap<String, PropertyDefinition>();
        if (indexingRule.propertyIndexEnabled) {
            for (Filter.PropertyRestriction pr : this.filter.getPropertyRestrictions()) {
                String name = pr.propertyName;
                if (":localname".equals(name) || name.startsWith("function*")) continue;
                if ("rep:facet".equals(pr.propertyName)) {
                    String value = (String)pr.first.getValue(Type.STRING);
                    facetFields.add(FacetHelper.parseFacetField(value));
                }
                PropertyDefinition pd = indexingRule.getConfig(pr.propertyName);
                boolean relativeProps = false;
                if (pd == null && ntBaseRule) {
                    pd = IndexPlanner.getSimpleProperty(indexingRule, pr.propertyName);
                    boolean bl = relativeProps = pd != null;
                }
                if (pd == null || !pd.propertyIndexEnabled() || pr.isNullRestriction() && !pd.nullCheckEnabled || !this.matchesValuePattern(pr, pd)) continue;
                if (pd.weight != 0 && !relativeProps) {
                    indexedProps.add(name);
                }
                if (relativeProps) {
                    relativePropDefns.put(name, pd);
                    continue;
                }
                this.result.propDefns.put(name, pd);
            }
        }
        boolean evalNodeTypeRestrictions = this.canEvalNodeTypeRestrictions(indexingRule);
        boolean evalPathRestrictions = this.canEvalPathRestrictions(indexingRule);
        boolean canEvalAlFullText = this.canEvalAllFullText(indexingRule, ft);
        boolean canEvalNodeNameRestriction = this.canEvalNodeNameRestriction(indexingRule);
        if (ft != null && !canEvalAlFullText) {
            return null;
        }
        if (indexedProps.isEmpty() && !relativePropDefns.isEmpty() && !canEvalAlFullText) {
            indexedProps = this.planForRelativeProperties(relativePropDefns);
        }
        List<QueryIndex.OrderEntry> sortOrder = this.createSortOrder(indexingRule);
        boolean canSort = IndexPlanner.canSortByProperty(sortOrder);
        if (!indexedProps.isEmpty() || canSort || ft != null || evalPathRestrictions || evalNodeTypeRestrictions || canEvalNodeNameRestriction) {
            boolean uniqueIndexFound;
            int maxPossibleNumDocs;
            int costPerEntryFactor = 1;
            costPerEntryFactor += sortOrder.size();
            QueryIndex.IndexPlan.Builder plan = this.defaultPlan();
            if (!sortOrder.isEmpty()) {
                plan.setSortOrder(sortOrder);
            }
            if (facetFields.size() > 0) {
                plan.setAttribute("oak.facet.fields", facetFields);
            }
            if (ft == null) {
                this.result.enableNonFullTextConstraints();
            }
            if (evalNodeTypeRestrictions) {
                this.result.enableNodeTypeEvaluation();
            }
            if (canEvalNodeNameRestriction) {
                this.result.enableNodeNameRestriction();
            }
            if (useActualEntryCount && !this.definition.isEntryCountDefined() && (maxPossibleNumDocs = this.getMaxPossibleNumDocs(this.result.propDefns)) >= 0) {
                plan.setEstimatedEntryCount((long)maxPossibleNumDocs);
            }
            if (sortOrder.isEmpty() && ft == null && (uniqueIndexFound = this.planForSyncIndexes(indexingRule))) {
                plan.setEstimatedEntryCount(1L);
            }
            return plan.setCostPerEntry(this.definition.getCostPerEntry() / (double)costPerEntryFactor);
        }
        return null;
    }

    private boolean matchesValuePattern(Filter.PropertyRestriction pr, PropertyDefinition pd) {
        String prefix;
        Set values;
        return pd.valuePattern.matchesAll() || !((values = ValuePatternUtil.getAllValues((Filter.PropertyRestriction)pr)) == null ? !pd.valuePattern.matchesPrefix(prefix = ValuePatternUtil.getLongestPrefix((Filter)this.filter, (String)pr.propertyName)) : !pd.valuePattern.matchesAll(values));
    }

    private boolean wrongIndex() {
        Filter.PropertyRestriction indexTag;
        Filter.PropertyRestriction indexName = this.filter.getPropertyRestriction(":indexName");
        boolean wrong = false;
        if (indexName != null && indexName.first != null) {
            String name = (String)indexName.first.getValue(Type.STRING);
            String thisName = this.definition.getIndexName();
            if (thisName != null && (thisName = PathUtils.getName((String)thisName)).equals(name)) {
                return false;
            }
            wrong = true;
        }
        if ((indexTag = this.filter.getPropertyRestriction(":indexTag")) != null && indexTag.first != null) {
            String[] tags = this.definition.getIndexTags();
            if (tags == null) {
                return true;
            }
            String tag = (String)indexTag.first.getValue(Type.STRING);
            for (String t : tags) {
                if (!t.equals(tag)) continue;
                return false;
            }
            return true;
        }
        return wrong;
    }

    private QueryIndex.IndexPlan.Builder getNativeFunctionPlanBuilder(String indexingRuleBaseNodeType) {
        boolean canHandleNativeFunction = true;
        PropertyValue pv = this.filter.getPropertyRestriction((String)this.definition.getFunctionName()).first;
        String query = (String)pv.getValue(Type.STRING);
        if (query.startsWith("suggest?term=")) {
            canHandleNativeFunction = this.definition.isSuggestEnabled() ? indexingRuleBaseNodeType.equals(this.filter.getNodeType()) : false;
        } else if (query.startsWith("spellcheck?term=")) {
            canHandleNativeFunction = this.definition.isSpellcheckEnabled() ? indexingRuleBaseNodeType.equals(this.filter.getNodeType()) : false;
        }
        if (canHandleNativeFunction) {
            this.result.disableUniquePaths();
        }
        return canHandleNativeFunction ? this.defaultPlan().setEstimatedEntryCount(1L) : null;
    }

    private boolean checkForQueryPaths() {
        String[] queryPaths = this.definition.getQueryPaths();
        if (queryPaths == null) {
            return true;
        }
        String pathRestriction = this.filter.getPath();
        for (String queryPath : queryPaths) {
            if (!queryPath.equals(pathRestriction) && !PathUtils.isAncestor((String)queryPath, (String)pathRestriction)) continue;
            return true;
        }
        return false;
    }

    private boolean canEvalNodeNameRestriction(IndexDefinition.IndexingRule indexingRule) {
        Filter.PropertyRestriction pr = this.filter.getPropertyRestriction(":localname");
        if (pr == null) {
            return false;
        }
        return indexingRule.isNodeNameIndexed();
    }

    private static boolean canSortByProperty(List<QueryIndex.OrderEntry> sortOrder) {
        if (sortOrder.isEmpty()) {
            return false;
        }
        return sortOrder.size() != 1 || !"jcr:score".equals(sortOrder.get(0).getPropertyName());
    }

    private boolean canEvalAllFullText(final IndexDefinition.IndexingRule indexingRule, FullTextExpression ft) {
        if (ft == null) {
            return false;
        }
        final HashSet relPaths = new HashSet();
        final HashSet nonIndexedPaths = new HashSet();
        final AtomicBoolean relativeParentsFound = new AtomicBoolean();
        final AtomicBoolean nodeScopedCondition = new AtomicBoolean();
        ft.accept((FullTextVisitor)new FullTextVisitor.FullTextVisitorBase(){

            public boolean visit(FullTextContains contains) {
                this.visitTerm(contains.getPropertyName());
                return true;
            }

            public boolean visit(FullTextTerm term) {
                this.visitTerm(term.getPropertyName());
                return true;
            }

            private void visitTerm(String propertyName) {
                String p = propertyName;
                String propertyPath = null;
                String nodePath = null;
                if (p == null) {
                    relPaths.add("");
                } else if (p.startsWith("../") || p.startsWith("./")) {
                    relPaths.add(p);
                    relativeParentsFound.set(true);
                } else if (PathUtils.getDepth((String)p) > 1) {
                    String parent = PathUtils.getParentPath((String)p);
                    if (LucenePropertyIndex.isNodePath(p)) {
                        nodePath = parent;
                    } else {
                        propertyPath = p;
                    }
                    relPaths.add(parent);
                } else {
                    propertyPath = p;
                    relPaths.add("");
                }
                if (nodePath != null && !indexingRule.isAggregated(nodePath)) {
                    nonIndexedPaths.add(p);
                } else if (propertyPath != null) {
                    PropertyDefinition pd = indexingRule.getConfig(propertyPath);
                    if (pd == null) {
                        nonIndexedPaths.add(p);
                    } else if (!pd.analyzed) {
                        nonIndexedPaths.add(p);
                    }
                }
                if (IndexPlanner.nodeScopedTerm(propertyName)) {
                    nodeScopedCondition.set(true);
                }
            }
        });
        if (nodeScopedCondition.get() && !indexingRule.isNodeFullTextIndexed()) {
            return false;
        }
        if (relativeParentsFound.get()) {
            log.debug("Relative parents found {} which are not supported", relPaths);
            return false;
        }
        if (!nonIndexedPaths.isEmpty()) {
            if (relPaths.size() > 1) {
                log.debug("Following relative  property paths are not index", relPaths);
                return false;
            }
            this.result.setParentPath((String)Iterables.getOnlyElement(relPaths, (Object)""));
            IndexDefinition.IndexingRule rule = this.definition.getApplicableIndexingRule("nt:base");
            if (rule == null) {
                return false;
            }
            for (String p : nonIndexedPaths) {
                if (LucenePropertyIndex.isNodePath(p)) {
                    if (rule.isNodeFullTextIndexed()) continue;
                    return false;
                }
                String propertyName = PathUtils.getName((String)p);
                PropertyDefinition pd = rule.getConfig(propertyName);
                if (pd == null) {
                    return false;
                }
                if (pd.analyzed) continue;
                return false;
            }
        } else {
            this.result.setParentPath("");
        }
        return true;
    }

    private List<String> planForRelativeProperties(Map<String, PropertyDefinition> relativePropDefns) {
        ArrayListMultimap relpaths = ArrayListMultimap.create();
        int maxSize = 0;
        String maxCountedParent = null;
        for (Map.Entry<String, PropertyDefinition> e : relativePropDefns.entrySet()) {
            String relativePropertyPath = e.getKey();
            String parent = PathUtils.getParentPath((String)relativePropertyPath);
            relpaths.put((Object)parent, e);
            int count = relpaths.get((Object)parent).size();
            if (count <= maxSize) continue;
            maxSize = count;
            maxCountedParent = parent;
        }
        this.result.setParentPath(maxCountedParent);
        ArrayList<String> indexedProps = new ArrayList<String>(maxSize);
        for (Map.Entry e : relpaths.get(maxCountedParent)) {
            String relativePropertyPath = (String)e.getKey();
            this.result.propDefns.put(relativePropertyPath, e.getValue());
            this.result.relPropMapping.put(relativePropertyPath, PathUtils.getName((String)relativePropertyPath));
            if (((PropertyDefinition)e.getValue()).weight == 0) continue;
            indexedProps.add(relativePropertyPath);
        }
        return indexedProps;
    }

    @CheckForNull
    private static PropertyDefinition getSimpleProperty(IndexDefinition.IndexingRule indexingRule, String relativePropertyName) {
        String name = PathUtils.getName((String)relativePropertyName);
        if (name.equals(relativePropertyName)) {
            return null;
        }
        if (relativePropertyName.startsWith("../") || relativePropertyName.startsWith("./")) {
            return null;
        }
        return indexingRule.getConfig(name);
    }

    private boolean planForSyncIndexes(IndexDefinition.IndexingRule indexingRule) {
        PropertyDefinition pd;
        if (!this.definition.hasSyncPropertyDefinitions()) {
            return false;
        }
        if (this.result.propDefns.isEmpty() && !this.result.evaluateNodeTypeRestriction()) {
            return false;
        }
        ArrayList unique = Lists.newArrayList();
        ArrayList nonUnique = Lists.newArrayList();
        for (Filter.PropertyRestriction pr : this.filter.getPropertyRestrictions()) {
            String propertyName = this.result.getPropertyName(pr);
            PropertyDefinition pd2 = (PropertyDefinition)this.result.propDefns.get(pr.propertyName);
            if (pd2 == null) continue;
            PropertyIndexResult e = new PropertyIndexResult(propertyName, pr);
            if (pd2.unique) {
                unique.add(e);
                continue;
            }
            nonUnique.add(e);
        }
        boolean uniqueIndexFound = false;
        if (!unique.isEmpty()) {
            this.result.propertyIndexResult = (PropertyIndexResult)unique.get(0);
            uniqueIndexFound = true;
        } else if (!nonUnique.isEmpty()) {
            this.result.propertyIndexResult = (PropertyIndexResult)nonUnique.get(0);
        }
        if (this.result.propertyIndexResult == null && this.result.evaluateNodeTypeRestriction() && (pd = indexingRule.getConfig("jcr:primaryType")) != null && pd.sync) {
            this.result.syncNodeTypeRestrictions = true;
        }
        return uniqueIndexFound;
    }

    private boolean canEvalPathRestrictions(IndexDefinition.IndexingRule rule) {
        if (this.filter.getPathRestriction() == Filter.PathRestriction.NO_RESTRICTION || this.filter.getPathRestriction() == Filter.PathRestriction.ALL_CHILDREN && PathUtils.denotesRoot((String)this.filter.getPath())) {
            return false;
        }
        return this.definition.evaluatePathRestrictions() && rule.indexesAllNodesOfMatchingType();
    }

    private boolean canEvalNodeTypeRestrictions(IndexDefinition.IndexingRule rule) {
        if (this.filter.matchesAllTypes()) {
            return false;
        }
        return rule.indexesAllNodesOfMatchingType() && !rule.isBasedOnNtBase();
    }

    private QueryIndex.IndexPlan.Builder defaultPlan() {
        return new QueryIndex.IndexPlan.Builder().setCostPerExecution(this.definition.getCostPerExecution()).setCostPerEntry(this.definition.getCostPerEntry()).setFulltextIndex(this.definition.isFullTextEnabled()).setIncludesNodeData(false).setFilter(this.filter).setPathPrefix(this.getPathPrefix()).setSupportsPathRestriction(this.definition.evaluatePathRestrictions()).setDelayed(true).setAttribute("oak.lucene.planResult", (Object)this.result).setEstimatedEntryCount(this.estimatedEntryCount()).setPlanName(this.indexPath);
    }

    private long estimatedEntryCount() {
        int numOfDocs = this.getNumDocs();
        if (useActualEntryCount) {
            return this.definition.isEntryCountDefined() ? this.definition.getEntryCount() : (long)numOfDocs;
        }
        return this.estimatedEntryCount_Compat(numOfDocs);
    }

    private long estimatedEntryCount_Compat(int numOfDocs) {
        FullTextExpression ft = this.filter.getFullTextConstraint();
        if (ft != null && this.definition.isFullTextEnabled()) {
            return this.definition.getFulltextEntryCount(numOfDocs);
        }
        return Math.min(this.definition.getEntryCount(), (long)numOfDocs);
    }

    private String getPathPrefix() {
        String parentPath = PathUtils.getAncestorPath((String)this.indexPath, (int)2);
        return PathUtils.denotesRoot((String)parentPath) ? "" : parentPath;
    }

    private int getNumDocs() {
        return this.indexNode.getIndexStatistics().numDocs();
    }

    private int getMaxPossibleNumDocs(Map<String, PropertyDefinition> propDefns) {
        IndexStatistics indexStatistics = this.indexNode.getIndexStatistics();
        int minNumDocs = indexStatistics.numDocs();
        for (Map.Entry<String, PropertyDefinition> propDef : propDefns.entrySet()) {
            int docCntForField;
            String key = propDef.getKey();
            if (this.result.relPropMapping.containsKey(key)) {
                key = PathUtils.getName((String)key);
            }
            if ((docCntForField = indexStatistics.getDocCountFor(key)) == -1) continue;
            int weight = propDef.getValue().weight;
            if (weight > 1) {
                double scaledDocCnt = Math.ceil((double)docCntForField / (double)weight);
                if ((double)minNumDocs < scaledDocCnt) continue;
                minNumDocs = (int)scaledDocCnt;
                continue;
            }
            if (docCntForField >= minNumDocs) continue;
            minNumDocs = docCntForField;
        }
        return minNumDocs;
    }

    private List<QueryIndex.OrderEntry> createSortOrder(IndexDefinition.IndexingRule rule) {
        if (this.sortOrder == null) {
            return Collections.emptyList();
        }
        ArrayList orderEntries = Lists.newArrayListWithCapacity((int)this.sortOrder.size());
        for (QueryIndex.OrderEntry o : this.sortOrder) {
            PropertyDefinition pd = rule.getConfig(o.getPropertyName());
            if (pd != null && pd.ordered && o.getPropertyType() != null && !o.getPropertyType().isArray()) {
                orderEntries.add(o);
                this.result.sortedProperties.add(pd);
            } else if (o.getPropertyName().equals(IndexDefinition.NATIVE_SORT_ORDER.getPropertyName())) {
                orderEntries.add(IndexDefinition.NATIVE_SORT_ORDER);
            }
            for (PropertyDefinition functionIndex : rule.getFunctionRestrictions()) {
                if (!o.getPropertyName().equals(functionIndex.function)) continue;
                orderEntries.add(o);
                this.result.sortedProperties.add(functionIndex);
            }
        }
        return orderEntries;
    }

    @CheckForNull
    private IndexDefinition.IndexingRule getApplicableRule() {
        if (this.filter.matchesAllTypes()) {
            return this.definition.getApplicableIndexingRule("nt:base");
        }
        for (IndexDefinition.IndexingRule rule : this.definition.getDefinedRules()) {
            if (this.filter.getSupertypes().contains(rule.getNodeTypeName())) {
                IndexDefinition.IndexingRule matchingRule = this.definition.getApplicableIndexingRule(rule.getNodeTypeName());
                if (matchingRule == null && rule.getNodeTypeName().equals(this.filter.getNodeType())) {
                    matchingRule = rule;
                }
                if (matchingRule != null) {
                    log.debug("Applicable IndexingRule found {}", (Object)matchingRule);
                    return rule;
                }
            }
            if (!rule.getNodeTypeName().equals("nt:base")) continue;
            return rule;
        }
        log.trace("No applicable IndexingRule found for any of the superTypes {}", (Object)this.filter.getSupertypes());
        return null;
    }

    private boolean notSupportedFeature() {
        if (this.filter.getPathRestriction() == Filter.PathRestriction.NO_RESTRICTION && this.filter.matchesAllTypes() && this.filter.getPropertyRestrictions().isEmpty()) {
            return true;
        }
        boolean failTestOnMissingFunctionIndex = true;
        if (failTestOnMissingFunctionIndex) {
            return false;
        }
        for (Filter.PropertyRestriction r : this.filter.getPropertyRestrictions()) {
            if (r.propertyName.startsWith("function*")) continue;
            return false;
        }
        return true;
    }

    private static boolean nodeScopedTerm(String propertyName) {
        return propertyName == null || ".".equals(propertyName) || "*".equals(propertyName);
    }

    static {
        useActualEntryCount = Boolean.parseBoolean(System.getProperty(FLAG_ENTRY_COUNT, "true"));
        if (!useActualEntryCount) {
            log.info("System property {} found to be false. IndexPlanner would use a default entryCount of 1000 instead of using the actual entry count", (Object)FLAG_ENTRY_COUNT);
        }
    }

    public static class PropertyIndexResult {
        final String propertyName;
        final Filter.PropertyRestriction pr;

        public PropertyIndexResult(String propertyName, Filter.PropertyRestriction pr) {
            this.propertyName = propertyName;
            this.pr = pr;
        }
    }

    public static class PlanResult {
        final String indexPath;
        final IndexDefinition indexDefinition;
        final IndexDefinition.IndexingRule indexingRule;
        private final List<PropertyDefinition> sortedProperties = Lists.newArrayList();
        private final Map<String, PropertyDefinition> propDefns = Maps.newHashMap();
        private final Map<String, String> relPropMapping = Maps.newHashMap();
        private boolean nonFullTextConstraints;
        private int parentDepth;
        private String parentPathSegment;
        private boolean relativize;
        private boolean nodeTypeRestrictions;
        private boolean nodeNameRestriction;
        private boolean uniquePathsRequired = true;
        private PropertyIndexResult propertyIndexResult;
        private boolean syncNodeTypeRestrictions;

        public PlanResult(String indexPath, IndexDefinition defn, IndexDefinition.IndexingRule indexingRule) {
            this.indexPath = indexPath;
            this.indexDefinition = defn;
            this.indexingRule = indexingRule;
        }

        public PropertyDefinition getPropDefn(Filter.PropertyRestriction pr) {
            return this.propDefns.get(pr.propertyName);
        }

        public String getPropertyName(Filter.PropertyRestriction pr) {
            return this.relPropMapping.getOrDefault(pr.propertyName, pr.propertyName);
        }

        public boolean hasProperty(String propName) {
            return this.propDefns.containsKey(propName);
        }

        public PropertyDefinition getOrderedProperty(int index) {
            return this.sortedProperties.get(index);
        }

        public boolean isPathTransformed() {
            return this.relativize;
        }

        public boolean isUniquePathsRequired() {
            return this.uniquePathsRequired;
        }

        @CheckForNull
        public String transformPath(String path) {
            if (this.isPathTransformed()) {
                if (!path.endsWith(this.parentPathSegment)) {
                    return null;
                }
                return PathUtils.getAncestorPath((String)path, (int)this.parentDepth);
            }
            return path;
        }

        public boolean evaluateNonFullTextConstraints() {
            return this.nonFullTextConstraints;
        }

        public boolean evaluateNodeTypeRestriction() {
            return this.nodeTypeRestrictions;
        }

        public boolean evaluateSyncNodeTypeRestriction() {
            return this.syncNodeTypeRestrictions;
        }

        public boolean evaluateNodeNameRestriction() {
            return this.nodeNameRestriction;
        }

        @CheckForNull
        public PropertyIndexResult getPropertyIndexResult() {
            return this.propertyIndexResult;
        }

        public boolean hasPropertyIndexResult() {
            return this.propertyIndexResult != null;
        }

        private void setParentPath(String relativePath) {
            this.parentPathSegment = "/" + relativePath;
            if (relativePath.isEmpty()) {
                this.enableNonFullTextConstraints();
            } else {
                this.relativize = true;
                this.parentDepth = PathUtils.getDepth((String)relativePath);
            }
        }

        private void enableNonFullTextConstraints() {
            this.nonFullTextConstraints = true;
        }

        private void enableNodeTypeEvaluation() {
            this.nodeTypeRestrictions = true;
        }

        private void enableNodeNameRestriction() {
            this.nodeNameRestriction = true;
        }

        private void disableUniquePaths() {
            this.uniquePathsRequired = false;
        }
    }
}

