/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.core.impl.ScriptCacheImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Script Cache", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=scriptcache", "felix.webconsole.title=Script Cache Status", "felix.webconsole.category=Sling"}, service={Servlet.class})
public class ScriptCacheConsolePlugin
extends AbstractWebConsolePlugin {
    public static final String CONSOLE_LABEL = "scriptcache";
    public static final String CONSOLE_TITLE = "Script Cache Status";
    public static final String RESOURCES = "scriptcache/ui";
    private static final String SCRIPTCACHE_JS = "scriptcache.js";
    private static final String CTYPE_JAVASCRIPT = "application/javascript";
    private static final String POST_SCRIPT = "script";
    @Reference
    private ScriptCache scriptCache = null;

    public String getTitle() {
        return CONSOLE_TITLE;
    }

    public String getLabel() {
        return CONSOLE_LABEL;
    }

    protected void renderContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.scriptCache instanceof ScriptCacheImpl) {
            ScriptCacheImpl scriptCacheImpl = (ScriptCacheImpl)this.scriptCache;
            ArrayList<String> scripts = new ArrayList<String>(scriptCacheImpl.getCachedScripts());
            StringBuilder sb = new StringBuilder();
            sb.append("<script type='text/javascript' src='").append(RESOURCES).append("/").append(SCRIPTCACHE_JS).append("'></script>");
            sb.append("<div id='cached-scripts' class='ui-widget statline'>");
            if (scripts.size() > 0) {
                Collections.sort(scripts);
                sb.append("<p class='ui-widget-header'>Cached Scripts</p>");
                sb.append("<table class='nicetable ui-widget-content'>");
                int i = 0;
                for (String script : scripts) {
                    sb.append("<tr class='").append(i % 2 == 0 ? "even" : "odd").append(" ui-state-default'><td>").append(++i).append("<td><code>").append(script).append("</code></td><td><button type='button' data-script='").append(script).append("'>Remove</button></td></tr>");
                }
                sb.append("<tr><td colspan='3'><button type='button' id='clearcache'>Clear Cache</button></td></tr>");
                sb.append("</table>");
            } else {
                sb.append("<p class='ui-state-highlight'>The Script Cache doesn't contain any scripts.</p>");
            }
            sb.append("</div>");
            httpServletResponse.getWriter().write(sb.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().endsWith("scriptcache/ui/scriptcache.js")) {
            response.setContentType(CTYPE_JAVASCRIPT);
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scriptcache/ui/scriptcache.js"), (OutputStream)response.getOutputStream());
        } else {
            super.doGet(request, response);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String script = req.getParameter(POST_SCRIPT);
        if (script != null && !script.isEmpty()) {
            if ("all".equals(script)) {
                this.scriptCache.clear();
                this.renderContent(req, resp);
            } else {
                boolean success = this.scriptCache.removeScript(script);
                if (success) {
                    this.renderContent(req, resp);
                }
            }
            resp.setStatus(200);
        } else {
            resp.sendError(500);
        }
    }
}

