/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.util.Map;
import javax.script.Bindings;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.impl.utils.ScriptUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UseProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.impl.engine.extension.use.ScriptUseProvider"}, property={"service.ranking:Integer=0"})
public class ScriptUseProvider
implements UseProvider {
    private static final Logger log = LoggerFactory.getLogger(ScriptUseProvider.class);
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;

    public ProviderOutcome provide(String scriptName, RenderContext renderContext, Bindings arguments) {
        Bindings globalBindings = renderContext.getBindings();
        Bindings bindings = BindingsUtils.merge(globalBindings, arguments);
        String extension = this.scriptExtension(scriptName);
        if (extension == null || extension.equals("html")) {
            return ProviderOutcome.failure();
        }
        Resource scriptResource = ScriptUtils.resolveScript(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), renderContext, scriptName);
        if (scriptResource == null) {
            log.debug("Path does not match an existing resource: {}", (Object)scriptName);
            return ProviderOutcome.failure();
        }
        return this.evalScript(scriptResource, bindings);
    }

    private ProviderOutcome evalScript(Resource scriptResource, Bindings bindings) {
        SlingScript slingScript = (SlingScript)scriptResource.adaptTo(SlingScript.class);
        if (slingScript == null) {
            return ProviderOutcome.failure();
        }
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        Object scriptEval = slingScript.eval(slingBindings);
        return ProviderOutcome.notNullOrFailure((Object)scriptEval);
    }

    private String scriptExtension(String path) {
        String extension = StringUtils.substringAfterLast((String)path, (String)".");
        if (StringUtils.isEmpty((CharSequence)extension)) {
            extension = null;
        }
        return extension;
    }

    static @interface Configuration {
        @AttributeDefinition(name="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.")
        public int service_ranking() default 0;
    }
}

