/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.ReferenceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSupportImpl {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void orderNode(SlingHttpServletRequest request, Resource resource, List<Modification> changes) throws PersistenceException {
        block21: {
            String command = request.getParameter(":order");
            if (command == null || command.length() == 0) {
                return;
            }
            Node node = (Node)resource.adaptTo(Node.class);
            if (node == null) {
                return;
            }
            try {
                Node parent = node.getParent();
                String next = null;
                if (command.equals("first")) {
                    next = parent.getNodes().nextNode().getName();
                } else if (command.equals("last")) {
                    next = "";
                } else if (command.startsWith("before ")) {
                    next = command.substring("before ".length());
                } else if (command.startsWith("after ")) {
                    String name = command.substring("after ".length());
                    NodeIterator iter = parent.getNodes();
                    while (iter.hasNext()) {
                        Node n = iter.nextNode();
                        if (!n.getName().equals(name)) continue;
                        if (iter.hasNext()) {
                            next = iter.nextNode().getName();
                            continue;
                        }
                        next = "";
                    }
                } else {
                    try {
                        next = "";
                        NodeIterator iter = parent.getNodes();
                        for (int newPos = Integer.parseInt(command); iter.hasNext() && newPos >= 0; --newPos) {
                            Node n = iter.nextNode();
                            if (n.getName().equals(node.getName())) {
                                ++newPos;
                            }
                            if (newPos != 0) continue;
                            next = n.getName();
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("provided node ordering command is invalid: " + command);
                    }
                }
                if (next != null) {
                    if (next.equals("")) {
                        next = null;
                    }
                    parent.orderBefore(node.getName(), next);
                    changes.add(Modification.onOrder(node.getPath(), next));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Node {} moved '{}'", (Object)node.getPath(), (Object)command);
                    }
                    break block21;
                }
                throw new IllegalArgumentException("provided node ordering command is invalid: " + command);
            }
            catch (RepositoryException re) {
                throw new PersistenceException("Unable to order resource", (Throwable)re, resource.getPath(), null);
            }
        }
    }

    private boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    public boolean isVersionable(Resource rsrc) throws PersistenceException {
        try {
            Node node = (Node)rsrc.adaptTo(Node.class);
            return node != null && this.isVersionable(node);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re, rsrc.getPath(), null);
        }
    }

    public boolean checkin(Resource rsrc) throws PersistenceException {
        Node node = (Node)rsrc.adaptTo(Node.class);
        if (node != null) {
            try {
                if (node.isCheckedOut() && this.isVersionable(node)) {
                    node.getSession().getWorkspace().getVersionManager().checkin(node.getPath());
                    return true;
                }
            }
            catch (RepositoryException re) {
                throw new PersistenceException(re.getMessage(), (Throwable)re, rsrc.getPath(), null);
            }
        }
        return false;
    }

    private Node findVersionableAncestor(Node node) throws RepositoryException {
        if (this.isVersionable(node)) {
            return node;
        }
        try {
            node = node.getParent();
            return this.findVersionableAncestor(node);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public void checkoutIfNecessary(Resource resource, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        Node node;
        if (resource != null && versioningConfiguration.isAutoCheckout() && (node = (Node)resource.adaptTo(Node.class)) != null) {
            try {
                Node versionableNode = this.findVersionableAncestor(node);
                if (versionableNode != null && !versionableNode.isCheckedOut()) {
                    versionableNode.getSession().getWorkspace().getVersionManager().checkout(versionableNode.getPath());
                    changes.add(Modification.onCheckout(versionableNode.getPath()));
                }
            }
            catch (RepositoryException re) {
                throw new PersistenceException(re.getMessage(), (Throwable)re);
            }
        }
    }

    public boolean isNode(Resource rsrc) {
        return rsrc.adaptTo(Node.class) != null;
    }

    public boolean isNodeType(Resource rsrc, String typeHint) {
        Node node = (Node)rsrc.adaptTo(Node.class);
        if (node != null) {
            try {
                return node.isNodeType(typeHint);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public Boolean isFileNodeType(ResourceResolver resolver, String nodeType) {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session != null) {
            try {
                NodeTypeManager ntMgr = session.getWorkspace().getNodeTypeManager();
                NodeType nt = ntMgr.getNodeType(nodeType);
                return nt.isNodeType("nt:file");
            }
            catch (RepositoryException e) {
                return null;
            }
        }
        return false;
    }

    private PropertyDefinition searchPropertyDefinition(NodeType nodeType, String name) {
        if (nodeType.getPropertyDefinitions() != null) {
            for (PropertyDefinition pd : nodeType.getPropertyDefinitions()) {
                if (!pd.getName().equals(name)) continue;
                return pd;
            }
        }
        return null;
    }

    private PropertyDefinition searchPropertyDefinition(Node node, String name) throws RepositoryException {
        PropertyDefinition result = this.searchPropertyDefinition(node.getPrimaryNodeType(), name);
        if (result == null && node.getMixinNodeTypes() != null) {
            for (NodeType mt : node.getMixinNodeTypes()) {
                result = this.searchPropertyDefinition(mt, name);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public boolean isPropertyProtectedOrNewAutoCreated(Object n, String name) throws PersistenceException {
        Node node = (Node)n;
        try {
            PropertyDefinition pd = this.searchPropertyDefinition(node, name);
            if (pd != null && (node.isNew() && pd.isAutoCreated() || pd.isProtected())) {
                return true;
            }
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
        return false;
    }

    public boolean isNewNode(Object node) {
        return ((Node)node).isNew();
    }

    public boolean isPropertyMandatory(Object node, String name) throws PersistenceException {
        try {
            Property prop = ((Node)node).getProperty(name);
            return prop.getDefinition().isMandatory();
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public boolean isPropertyMultiple(Object node, String name) throws PersistenceException {
        try {
            Property prop = ((Node)node).getProperty(name);
            return prop.getDefinition().isMultiple();
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public Integer getPropertyType(Object node, String name) throws PersistenceException {
        try {
            if (((Node)node).hasProperty(name)) {
                return ((Node)node).getProperty(name).getType();
            }
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
        return null;
    }

    private boolean isWeakReference(int propertyType) {
        return propertyType == 10;
    }

    public Modification storeAsReference(Object n, String name, String[] values, int type, boolean multiValued) throws PersistenceException {
        try {
            Value v;
            Node node = (Node)n;
            if (multiValued) {
                Value[] array = ReferenceParser.parse(node.getSession(), values, this.isWeakReference(type));
                if (array != null) {
                    return Modification.onModified(node.setProperty(name, array).getPath());
                }
            } else if (values.length >= 1 && (v = ReferenceParser.parse(node.getSession(), values[0], this.isWeakReference(type))) != null) {
                return Modification.onModified(node.setProperty(name, v).getPath());
            }
            return null;
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public boolean hasSession(ResourceResolver resolver) {
        return resolver.adaptTo(Session.class) != null;
    }

    public void setTypedProperty(Object n, String name, String[] values, int type, boolean multiValued) throws PersistenceException {
        try {
            if (multiValued) {
                ((Node)n).setProperty(name, values, type);
            } else if (values.length >= 1) {
                ((Node)n).setProperty(name, values[0], type);
            }
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public Object getNode(Resource rsrc) {
        return rsrc.adaptTo(Node.class);
    }

    public Object getItem(Resource rsrc) {
        return rsrc.adaptTo(Item.class);
    }

    public void setPrimaryNodeType(Object node, String type) throws PersistenceException {
        try {
            ((Node)node).setPrimaryType(type);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public void move(Object src, Object dstParent, String name) throws PersistenceException {
        try {
            Session session = ((Item)src).getSession();
            Item source = (Item)src;
            String targetParentPath = ((Node)dstParent).getPath();
            String targetPath = (targetParentPath.equals("/") ? "" : targetParentPath) + '/' + name;
            session.move(source.getPath(), targetPath);
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    public String copy(Object src, Object dstParent, String name) throws PersistenceException {
        try {
            Item result = ((Item)src).isNode() ? this.copy((Node)src, (Node)dstParent, name) : this.copy((Property)src, (Node)dstParent, name);
            return result.getPath();
        }
        catch (RepositoryException re) {
            throw new PersistenceException(re.getMessage(), (Throwable)re);
        }
    }

    private Item copy(Node src, Node dstParent, String name) throws RepositoryException {
        if (JCRSupportImpl.isAncestorOrSameNode(src, dstParent)) {
            throw new RepositoryException("Cannot copy ancestor " + src.getPath() + " to descendant " + dstParent.getPath());
        }
        if (name == null) {
            name = src.getName();
        }
        if (dstParent.hasNode(name)) {
            dstParent.getNode(name).remove();
        }
        Node dst = dstParent.addNode(name, src.getPrimaryNodeType().getName());
        for (NodeType mix : src.getMixinNodeTypes()) {
            dst.addMixin(mix.getName());
        }
        PropertyIterator iter = src.getProperties();
        while (iter.hasNext()) {
            this.copy(iter.nextProperty(), dst, (String)null);
        }
        iter = src.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            if (n.getDefinition().isProtected()) continue;
            this.copy(n, dst, (String)null);
        }
        return dst;
    }

    public static boolean isAncestorOrSameNode(Node src, Node dest) throws RepositoryException {
        if (src.getPath().equals("/")) {
            return true;
        }
        if (src.getPath().equals(dest.getPath())) {
            return true;
        }
        return dest.getPath().startsWith(src.getPath() + "/");
    }

    private Item copy(Property src, Node dstParent, String name) throws RepositoryException {
        if (!src.getDefinition().isProtected()) {
            if (name == null) {
                name = src.getName();
            }
            if (dstParent.hasProperty(name)) {
                dstParent.getProperty(name).remove();
            }
            if (src.getDefinition().isMultiple()) {
                return dstParent.setProperty(name, src.getValues());
            }
            return dstParent.setProperty(name, src.getValue());
        }
        return null;
    }
}

