/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateParser {
    private static final Logger log = LoggerFactory.getLogger(DateParser.class);
    private final List<CalendarParserSupport> formats = new LinkedList<CalendarParserSupport>();

    public void register(String format) {
        CalendarParserSupport parser = "ISO8601".equalsIgnoreCase(format) ? new Iso8601ParserSupport() : new SimpleDateFormatParserSupport(format);
        this.formats.add(parser);
    }

    public Calendar parse(String source) {
        for (CalendarParserSupport fmt : this.formats) {
            try {
                Calendar c = fmt.parse(source);
                if (log.isDebugEnabled()) {
                    log.debug("Parsed " + source + " using " + fmt + " into " + c);
                }
                return c;
            }
            catch (ParseException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Failed parsing " + source + " using " + fmt);
            }
        }
        return null;
    }

    public Calendar[] parse(String[] sources) {
        Calendar[] ret = new Calendar[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            ret[i] = this.parse(sources[i]);
            if (ret[i] != null) continue;
            return null;
        }
        return ret;
    }

    private static class Iso8601ParserSupport
    implements CalendarParserSupport {
        static final String FORMAT_MARKER = "ISO8601";

        private Iso8601ParserSupport() {
        }

        @Override
        public Calendar parse(String dateTime) throws ParseException {
            try {
                Calendar c = ISO8601.parse(dateTime);
                if (c == null) {
                    throw new ParseException(dateTime + " cannot be parsed as ISO8601 formatted date string", 0);
                }
                return c;
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }

        public String toString() {
            return "ISO8601 Parser";
        }
    }

    private static class SimpleDateFormatParserSupport
    implements CalendarParserSupport {
        private final SimpleDateFormat dateFormat;

        SimpleDateFormatParserSupport(String format) {
            this.dateFormat = new SimpleDateFormat(format, Locale.US);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Calendar parse(String dateTime) throws ParseException {
            Date d;
            SimpleDateFormat simpleDateFormat = this.dateFormat;
            synchronized (simpleDateFormat) {
                d = this.dateFormat.parse(dateTime);
            }
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            return c;
        }

        public String toString() {
            return "SimpleDateFormat:" + this.dateFormat.toPattern();
        }
    }

    private static interface CalendarParserSupport {
        public Calendar parse(String var1) throws ParseException;
    }
}

