/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.json.JsonObject;
import javax.servlet.Servlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetEffectiveAcl;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractGetAclServlet;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class, GetEffectiveAcl.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET", "sling.servlet.selectors=eacl", "sling.servlet.selectors=tidy.eacl", "sling.servlet.extensions=json"})
public class GetEffectiveAclServlet
extends AbstractGetAclServlet
implements GetEffectiveAcl {
    @Override
    public JsonObject getEffectiveAcl(Session jcrSession, String resourcePath) throws RepositoryException {
        return this.internalGetAcl(jcrSession, resourcePath);
    }

    @Override
    protected AccessControlEntry[] getAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        AccessControlPolicy[] policies = accessControlManager.getEffectivePolicies(absPath);
        ArrayList<AccessControlEntry> allEntries = new ArrayList<AccessControlEntry>();
        for (AccessControlPolicy accessControlPolicy : policies) {
            AccessControlEntry[] accessControlEntries;
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            for (AccessControlEntry accessControlEntry : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                allEntries.add(accessControlEntry);
            }
        }
        return allEntries.toArray(new AccessControlEntry[allEntries.size()]);
    }
}

