/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.view;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.pckgmgr.PackageJobExecutor;
import com.composum.sling.core.pckgmgr.util.PackageUtil;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageBean
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(PackageBean.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String AUDIT_LOG_BASE = "/bin/browser.html" + PackageJobExecutor.AUDIT_BASE_PATH;
    protected String path;
    protected JcrPackageManager pckgMgr;
    protected JcrPackage pckg;
    protected JcrPackageDefinition pckgDef;
    private transient String group;
    private transient String name;
    private transient String version;
    private transient String description;
    private transient String filename;
    private transient String downloadUrl;
    private transient String auditLogUrl;
    private transient Calendar created;
    private transient String createdBy;
    private transient Calendar lastModified;
    private transient String lastModifiedBy;
    private transient Calendar lastUnpacked;
    private transient String lastUnpackedBy;
    private transient Calendar lastUnwrapped;
    private transient String lastUnwrappedBy;
    private transient Calendar lastWrapped;
    private transient String lastWrappedBy;
    private transient List<PathFilterSet> filterList;
    private transient String thumbnailUrl;

    public void initialize(BeanContext context, Resource resource) {
        SlingHttpServletRequest request = context.getRequest();
        this.path = PackageUtil.getPath(request);
        try {
            resource = PackageUtil.getResource(request, this.path);
        }
        catch (RepositoryException rex) {
            LOG.error(rex.getMessage(), (Throwable)rex);
        }
        super.initialize(context, resource);
        try {
            this.pckgMgr = PackageUtil.createPackageManager((SlingHttpServletRequest)this.getRequest());
            this.pckg = this.pckgMgr.open(this.getNode());
            if (this.pckg != null) {
                this.pckgDef = this.pckg.getDefinition();
            }
        }
        catch (RepositoryException rex) {
            LOG.error(rex.getMessage(), (Throwable)rex);
        }
    }

    protected String format(Calendar date) {
        return date != null ? new SimpleDateFormat(DATE_FORMAT).format(date.getTime()) : "";
    }

    public String getCssClasses() {
        return StringUtils.join(this.collectCssClasses(new ArrayList<String>()), (String)" ");
    }

    protected List<String> collectCssClasses(List<String> collection) {
        try {
            if (this.pckg != null) {
                if (this.pckg.isInstalled()) {
                    collection.add("installed");
                }
                if (this.pckg.isSealed()) {
                    collection.add("sealed");
                }
                if (this.pckg.isValid()) {
                    collection.add("valid");
                }
            }
        }
        catch (RepositoryException rex) {
            LOG.error(rex.getMessage(), (Throwable)rex);
        }
        return collection;
    }

    public String getUrl() {
        return LinkUtil.getUrl((SlingHttpServletRequest)this.getRequest(), (String)("/bin/packages.html" + this.getPath()));
    }

    public String getPath() {
        String path = PackageUtil.getPackagePath(this.pckgMgr, this.pckg);
        return path;
    }

    public String getGroup() {
        if (this.group == null) {
            int lastSlash;
            this.group = PackageUtil.getDefAttr(this.pckgDef, "group", "");
            if (StringUtils.isBlank((CharSequence)this.group) && this.path != null && (lastSlash = this.path.lastIndexOf(47)) >= 0) {
                this.group = this.path.substring(0, lastSlash);
            }
        }
        return this.group;
    }

    public String getName() {
        if (this.name == null) {
            this.name = PackageUtil.getDefAttr(this.pckgDef, "name", "");
            if (StringUtils.isBlank((CharSequence)this.name) && this.path != null) {
                this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
            }
        }
        return this.name;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = PackageUtil.getDefAttr(this.pckgDef, "version", "");
        }
        return this.version;
    }

    public String getDescription() {
        if (this.description == null) {
            if (this.pckgDef != null) {
                this.description = this.pckgDef.getDescription();
            }
            if (this.description == null) {
                this.description = "";
            }
        }
        return this.description;
    }

    public String getFilename() {
        if (this.filename == null) {
            this.filename = PackageUtil.getFilename(this.pckg);
        }
        return this.filename;
    }

    public String getDownloadUrl() {
        if (this.downloadUrl == null) {
            this.downloadUrl = LinkUtil.getUrl((SlingHttpServletRequest)this.getRequest(), (String)PackageUtil.getDownloadUrl(this.pckg));
        }
        return this.downloadUrl;
    }

    public String getCreated() {
        if (this.created == null) {
            this.created = PackageUtil.getCreated(this.pckg);
        }
        return this.created != null ? this.format(this.created) : "--";
    }

    public String getCreatedBy() {
        if (this.createdBy == null) {
            this.createdBy = PackageUtil.getCreatedBy(this.pckg);
        }
        return this.createdBy != null ? this.createdBy : "--";
    }

    public String getLastModified() {
        if (this.lastModified == null) {
            this.lastModified = PackageUtil.getLastModified(this.pckg);
        }
        return this.lastModified != null ? this.format(this.lastModified) : "--";
    }

    public String getLastModifiedBy() {
        if (this.lastModifiedBy == null) {
            this.lastModifiedBy = PackageUtil.getLastModifiedBy(this.pckg);
        }
        return this.lastModifiedBy != null ? this.lastModifiedBy : "--";
    }

    public String getLastUnpacked() {
        if (this.lastUnpacked == null && this.pckgDef != null) {
            this.lastUnpacked = this.pckgDef.getLastUnpacked();
        }
        return this.lastUnpacked != null ? this.format(this.lastUnpacked) : "--";
    }

    public String getLastUnpackedBy() {
        if (this.lastUnpackedBy == null && this.pckgDef != null) {
            this.lastUnpackedBy = this.pckgDef.getLastUnpackedBy();
        }
        return this.lastUnpackedBy != null ? this.lastUnpackedBy : "--";
    }

    public String getLastUnwrapped() {
        if (this.lastUnwrapped == null && this.pckgDef != null) {
            this.lastUnwrapped = this.pckgDef.getLastUnwrapped();
        }
        return this.lastUnwrapped != null ? this.format(this.lastUnwrapped) : "--";
    }

    public String getLastUnwrappedBy() {
        if (this.lastUnwrappedBy == null && this.pckgDef != null) {
            this.lastUnwrappedBy = this.pckgDef.getLastUnwrappedBy();
        }
        return this.lastUnwrappedBy != null ? this.lastUnwrappedBy : "--";
    }

    public String getLastWrapped() {
        if (this.lastWrapped == null && this.pckgDef != null) {
            this.lastWrapped = this.pckgDef.getLastWrapped();
        }
        return this.lastWrapped != null ? this.format(this.lastWrapped) : "--";
    }

    public String getLastWrappedBy() {
        if (this.lastWrappedBy == null && this.pckgDef != null) {
            this.lastWrappedBy = this.pckgDef.getLastWrappedBy();
        }
        return this.lastWrappedBy != null ? this.lastWrappedBy : "--";
    }

    public List<PathFilterSet> getFilterList() {
        if (this.filterList == null) {
            try {
                return PackageUtil.getFilterList(this.pckgDef);
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
                this.filterList = new ArrayList<PathFilterSet>();
            }
        }
        return this.filterList;
    }

    public String getThumbnailUrl() {
        if (this.thumbnailUrl == null) {
            StringBuilder builder = new StringBuilder();
            try {
                String path = PackageUtil.getThumbnailPath(this.pckgDef);
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    builder.append(LinkUtil.getUrl((SlingHttpServletRequest)this.request, (String)path));
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
            this.thumbnailUrl = builder.toString();
        }
        return this.thumbnailUrl;
    }

    public String getAuditLogUrl() {
        if (this.auditLogUrl == null) {
            this.auditLogUrl = LinkUtil.getUrl((SlingHttpServletRequest)this.getRequest(), (String)(AUDIT_LOG_BASE + this.getPath()));
        }
        return this.auditLogUrl;
    }

    public String getAcHandling() {
        AccessControlHandling acHandling = this.pckgDef.getAccessControlHandling();
        return acHandling != null ? acHandling.name() : "";
    }

    public String getAcHandlingLabel() {
        AccessControlHandling acHandling = this.pckgDef.getAccessControlHandling();
        return acHandling != null ? acHandling.name() : "-- -- ";
    }

    public boolean getRequiresRestart() {
        return this.pckgDef.getBoolean("requiresRestart");
    }

    public boolean getRequiresRoot() {
        return this.pckgDef.getBoolean("requiresRoot");
    }

    public String getProviderName() {
        return this.pckgDef.get("providerName");
    }

    public String getProviderUrl() {
        return this.pckgDef.get("providerUrl");
    }

    public String getProviderLink() {
        return this.pckgDef.get("providerLink");
    }

    public String[] getDependencies() {
        return PackageUtil.getMultiProperty(this.pckgDef, "dependencies");
    }

    public String[] getReplaces() {
        return PackageUtil.getMultiProperty(this.pckgDef, "replaces");
    }
}

