/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.mount;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.mount.FragmentMatcher;
import org.apache.jackrabbit.oak.spi.mount.Mount;

public final class MountInfo
implements Mount {
    private static final Function<String, String> SANITIZE_PATH = new Function<String, String>(){

        public String apply(String input) {
            if (input.endsWith("/") && input.length() > 1) {
                return input.substring(0, input.length() - 1);
            }
            return input;
        }
    };
    private final String name;
    private final boolean readOnly;
    private final String pathFragmentName;
    private final Set<String> pathsSupportingFragments;
    private final NavigableSet<String> includedPaths;

    MountInfo(String name, boolean readOnly, List<String> pathsSupportingFragments, List<String> includedPaths) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Mount name must not be null");
        this.readOnly = readOnly;
        this.pathFragmentName = "oak:mount-" + name;
        this.includedPaths = MountInfo.cleanCopy(includedPaths);
        this.pathsSupportingFragments = ImmutableSet.copyOf(pathsSupportingFragments);
    }

    @Override
    public boolean isUnder(String path) {
        String nextPath = this.includedPaths.higher(path = (String)SANITIZE_PATH.apply((Object)path));
        return nextPath != null && PathUtils.isAncestor((String)path, (String)nextPath);
    }

    @Override
    public boolean isDirectlyUnder(String path) {
        String nextPath = this.includedPaths.higher(path = (String)SANITIZE_PATH.apply((Object)path));
        return nextPath != null && path.equals(PathUtils.getParentPath((String)nextPath));
    }

    @Override
    public boolean isMounted(String path) {
        String previousPath;
        if (path.contains(this.pathFragmentName)) {
            String parent = path.substring(0, path.indexOf(this.pathFragmentName));
            if (this.isSupportFragment(parent = parent.substring(0, parent.lastIndexOf(47)))) {
                return true;
            }
        }
        return (previousPath = this.includedPaths.floor(path = (String)SANITIZE_PATH.apply((Object)path))) != null && (previousPath.equals(path) || PathUtils.isAncestor((String)previousPath, (String)path));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isSupportFragment(String path) {
        String subject = (String)SANITIZE_PATH.apply((Object)path);
        return this.pathsSupportingFragments.stream().map(pattern -> FragmentMatcher.startsWith(pattern, subject)).anyMatch(FragmentMatcher.Result.FULL_MATCH::equals);
    }

    @Override
    public boolean isSupportFragmentUnder(String path) {
        String subject = (String)SANITIZE_PATH.apply((Object)path);
        return this.pathsSupportingFragments.stream().map(pattern -> FragmentMatcher.startsWith(pattern, subject)).anyMatch(r -> r == FragmentMatcher.Result.PARTIAL_MATCH || r == FragmentMatcher.Result.FULL_MATCH);
    }

    @Override
    public String getPathFragmentName() {
        return this.pathFragmentName;
    }

    private static TreeSet<String> cleanCopy(Collection<String> includedPaths) {
        return Sets.newTreeSet((Iterable)Iterables.transform(includedPaths, SANITIZE_PATH));
    }

    public Set<String> getPathsSupportingFragments() {
        return Collections.unmodifiableSet(this.pathsSupportingFragments);
    }

    public Set<String> getIncludedPaths() {
        return Collections.unmodifiableSet(this.includedPaths);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String readAttr = this.readOnly ? "r" : "rw";
        pw.print(this.name + "(" + readAttr + ")");
        for (String path : this.includedPaths) {
            pw.printf("\t%s%n", path);
        }
        return sw.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MountInfo other = (MountInfo)obj;
        return this.name.equals(other.name);
    }
}

