/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.descriptors;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;

public class AggregatingDescriptors
implements Descriptors {
    private final Tracker<Descriptors> tracker;

    public AggregatingDescriptors(Tracker<Descriptors> tracker) {
        if (tracker == null) {
            throw new IllegalArgumentException("tracker must not be null");
        }
        this.tracker = tracker;
    }

    private List<Descriptors> getDescriptors() {
        List<Descriptors> descriptors = this.tracker.getServices();
        if (descriptors == null) {
            return Collections.emptyList();
        }
        return descriptors;
    }

    public String[] getKeys() {
        HashSet keys = new HashSet();
        for (Descriptors descriptors : this.getDescriptors()) {
            Collections.addAll(keys, descriptors.getKeys());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public boolean isStandardDescriptor(@Nonnull String key) {
        for (Descriptors descriptors : this.getDescriptors()) {
            if (!descriptors.isStandardDescriptor(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleValueDescriptor(@Nonnull String key) {
        for (Descriptors descriptors : this.getDescriptors()) {
            if (!descriptors.isSingleValueDescriptor(key)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public Value getValue(@Nonnull String key) {
        for (Descriptors descriptors : this.getDescriptors()) {
            Value value = descriptors.getValue(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @CheckForNull
    public Value[] getValues(@Nonnull String key) {
        for (Descriptors descriptors : this.getDescriptors()) {
            Value[] values = descriptors.getValues(key);
            if (values == null) continue;
            return values;
        }
        return null;
    }
}

