/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.sslfilter.internal;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class SslFilterRequest
extends HttpServletRequestWrapper {
    private static final String HTTP_SCHEME_PREFIX = "http://";
    private static final Pattern HEADER_TO_CERT = Pattern.compile("(?! CERTIFICATE)(?= ) ");

    SslFilterRequest(HttpServletRequest request, String clientCertHeader) throws CertificateException {
        super(request);
        if (clientCertHeader != null && !"".equals(clientCertHeader.trim())) {
            String clientCert = HEADER_TO_CERT.matcher(clientCertHeader).replaceAll("\n");
            try {
                CertificateFactory fac = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream instream = new ByteArrayInputStream(clientCert.getBytes("UTF-8"));
                Collection<? extends Certificate> certs = fac.generateCertificates(instream);
                request.setAttribute("javax.servlet.request.X509Certificate", (Object)certs.toArray(new X509Certificate[certs.size()]));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError("UTF-8 not supported?!");
            }
        }
    }

    void done() {
        this.getRequest().removeAttribute("javax.servlet.request.X509Certificate");
    }

    public String getScheme() {
        return "https";
    }

    public boolean isSecure() {
        return true;
    }

    public StringBuffer getRequestURL() {
        StringBuffer tmp = new StringBuffer(super.getRequestURL());
        if (tmp.indexOf(HTTP_SCHEME_PREFIX) == 0) {
            tmp.insert(4, 's');
        }
        return tmp;
    }

    public int getServerPort() {
        int port;
        try {
            String fwdPort = this.getHeader("X-Forwarded-Port");
            port = Integer.parseInt(fwdPort);
        }
        catch (Exception e) {
            port = 443;
        }
        return port;
    }
}

