/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.sslfilter.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.http.sslfilter.internal.SystemLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class LogServiceTracker
extends ServiceTracker {
    private final Map<ServiceReference, LogService> logServices = new TreeMap(Collections.reverseOrder());

    public LogServiceTracker(BundleContext context) {
        super(context, LogService.class.getName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        LogService result = (LogService)super.addingService(reference);
        if (result != null) {
            Map<ServiceReference, LogService> map = this.logServices;
            synchronized (map) {
                this.logServices.put(reference, result);
                SystemLogger.setLogService(this.logServices.values().iterator().next());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        Map<ServiceReference, LogService> map = this.logServices;
        synchronized (map) {
            this.logServices.remove(reference);
            Collection<LogService> services = this.logServices.values();
            if (services.isEmpty()) {
                SystemLogger.setLogService(null);
            } else {
                SystemLogger.setLogService(services.iterator().next());
            }
        }
        super.removedService(reference, service);
    }
}

