/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.rules;

import org.apache.sling.junit.Activator;
import org.apache.sling.junit.rules.ServiceGetter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.framework.BundleContext;

public class Service
implements TestRule {
    private final Class<?> serviceClass;
    private ServiceGetter<?> serviceGetter;

    public Service(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                BundleContext bundleContext = Activator.getBundleContext();
                if (bundleContext == null) {
                    base.evaluate();
                    return;
                }
                Service.this.serviceGetter = ServiceGetter.create(bundleContext, Service.this.serviceClass, null);
                try {
                    base.evaluate();
                }
                finally {
                    Service.this.serviceGetter.close();
                }
            }
        };
    }

    public <T> T getService(Class<T> serviceClass) {
        return serviceClass.cast(this.serviceGetter.getService());
    }
}

