/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererFactory;
import org.apache.sling.junit.TestSelector;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@Component(immediate=false)
@Service
public class PlainTextRenderer
extends RunListener
implements Renderer,
RendererFactory {
    public static final String EXTENSION = "txt";
    private PrintWriter output;

    @Override
    public Renderer createRenderer() {
        return new PlainTextRenderer();
    }

    @Override
    public boolean appliesTo(TestSelector selector) {
        return EXTENSION.equals(selector.getExtension());
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public void setup(HttpServletResponse response, String pageTitle) throws IOException, UnsupportedEncodingException {
        if (this.output != null) {
            throw new IllegalStateException("Output Writer already set");
        }
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        this.output = response.getWriter();
        this.title(1, pageTitle);
    }

    @Override
    public void cleanup() {
        this.output = null;
    }

    @Override
    public void info(String cssClass, String str) {
        this.output.println(str);
    }

    @Override
    public void list(String cssClass, Collection<String> data) {
        for (String str : data) {
            this.output.println(str);
        }
    }

    @Override
    public void title(int level, String title) {
        this.output.print(title);
        this.output.println(" ****");
    }

    @Override
    public void link(String info, String url, String method) {
        this.output.print("LINK: ");
        this.output.print(info);
        this.output.print(", url=");
        this.output.print(url);
        this.output.print(", method=");
        this.output.println(method);
    }

    @Override
    public RunListener getRunListener() {
        return this;
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        this.output.println("FAILURE " + failure);
        this.output.println("Stack Trace: " + failure.getTrace());
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        this.output.println("FINISHED " + description);
    }

    public void testIgnored(Description description) throws Exception {
        super.testIgnored(description);
        this.output.println("IGNORED " + description);
    }

    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
        this.output.println("TEST RUN FINISHED: tests:" + result.getRunCount() + ", failures:" + result.getFailureCount() + ", ignored:" + result.getIgnoreCount());
    }

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
    }

    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
    }
}

