/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererFactory;
import org.apache.sling.junit.SlingTestContextProvider;
import org.apache.sling.junit.TestSelector;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=false)
@Service
public class JsonRenderer
extends RunListener
implements Renderer,
RendererFactory {
    public static final String EXTENSION = "json";
    public static final String INFO_TYPE_KEY = "INFO_TYPE";
    public static final String INFO_SUBTYPE_KEY = "INFO_SUBTYPE";
    public static final String TEST_METADATA = "test_metadata";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JsonGenerator writer;

    @Override
    public Renderer createRenderer() {
        return new JsonRenderer();
    }

    @Override
    public boolean appliesTo(TestSelector selector) {
        return EXTENSION.equals(selector.getExtension());
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public void setup(HttpServletResponse response, String pageTitle) throws IOException, UnsupportedEncodingException {
        if (this.writer != null) {
            throw new IllegalStateException("Output Writer already set");
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        this.writer = Json.createGenerator((Writer)response.getWriter());
        try {
            this.writer.writeStartArray();
        }
        catch (JsonException jex) {
            throw (IOException)new IOException().initCause(jex);
        }
    }

    @Override
    public void cleanup() {
        if (this.writer != null) {
            try {
                this.writer.writeEnd();
                this.writer.flush();
            }
            catch (JsonException jex) {
                this.log.warn("JsonException in cleanup()", (Throwable)jex);
            }
        }
        this.writer = null;
    }

    @Override
    public void info(String cssClass, String info) {
        try {
            this.startItem("info");
            this.writer.write(INFO_SUBTYPE_KEY, cssClass);
            this.writer.write("info", info);
            this.endItem();
        }
        catch (JsonException jex) {
            this.log.warn("JsonException in info()", (Throwable)jex);
        }
    }

    @Override
    public void list(String cssClass, Collection<String> data) {
        try {
            this.startItem("list");
            this.writer.write(INFO_SUBTYPE_KEY, cssClass);
            this.writer.writeStartArray("data");
            for (String str : data) {
                this.writer.write(str);
            }
            this.writer.writeEnd();
            this.endItem();
        }
        catch (JsonException jex) {
            this.log.warn("JsonException in list()", (Throwable)jex);
        }
    }

    @Override
    public void title(int level, String title) {
    }

    @Override
    public void link(String info, String url, String method) {
        try {
            this.startItem("link");
            this.writer.write("info", info);
            this.writer.write("method", method);
            this.writer.write("url", url);
            this.endItem();
        }
        catch (JsonException jex) {
            this.log.warn("JsonException in link()", (Throwable)jex);
        }
    }

    @Override
    public RunListener getRunListener() {
        return this;
    }

    public void testStarted(Description description) throws Exception {
        super.testStarted(description);
        this.startItem("test");
        this.writer.write("description", description.toString());
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        if (SlingTestContextProvider.hasContext()) {
            this.outputContextMap(SlingTestContextProvider.getContext().output());
        }
        this.endItem();
    }

    public void testFailure(Failure failure) throws Exception {
        this.writer.write("failure", failure.toString());
        this.writer.write("trace", failure.getTrace());
    }

    public void testRunFinished(Result result) throws Exception {
    }

    void startItem(String name) throws JsonException {
        this.writer.writeStartObject();
        this.writer.write(INFO_TYPE_KEY, name);
    }

    void endItem() throws JsonException {
        this.writer.writeEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void outputContextMap(Map<String, Object> data) throws JsonException {
        this.writer.writeStartObject(TEST_METADATA);
        try {
            for (Map.Entry<String, Object> e : data.entrySet()) {
                Object value = e.getValue();
                if (value instanceof Long) {
                    this.writer.write(e.getKey(), ((Long)e.getValue()).longValue());
                    continue;
                }
                if (value instanceof Integer) {
                    this.writer.write(e.getKey(), ((Integer)e.getValue()).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    this.writer.write(e.getKey(), ((Double)e.getValue()).doubleValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    this.writer.write(e.getKey(), ((Boolean)e.getValue()).booleanValue());
                    continue;
                }
                if (value instanceof String) {
                    this.writer.write(e.getKey(), (String)e.getValue());
                    continue;
                }
                throw new IllegalArgumentException("Unexpected value for JSON: " + value);
            }
        }
        finally {
            this.writer.writeEnd();
        }
    }
}

