/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.api.execution.HealthCheckExecutor;
import org.apache.sling.hc.api.execution.HealthCheckSelector;
import org.apache.sling.hc.core.impl.servlet.ResultHtmlSerializer;
import org.apache.sling.hc.core.impl.servlet.ResultJsonSerializer;
import org.apache.sling.hc.core.impl.servlet.ResultTxtSerializer;
import org.apache.sling.hc.core.impl.servlet.ResultTxtVerboseSerializer;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Health Check Executor Servlet", description="Serializes health check results into html or json format", policy=ConfigurationPolicy.REQUIRE, metatype=true)
public class HealthCheckExecutorServlet
extends HttpServlet {
    private static final long serialVersionUID = 8013511523994541848L;
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckExecutorServlet.class);
    public static final String PARAM_SPLIT_REGEX = "[,;]+";
    static final Param PARAM_TAGS = new Param("tags", "Comma-separated list of health checks tags to select - can also be specified via path, e.g. /system/health/tag1,tag2.json. Exclusions can be done by prepending '-' to the tag name");
    static final Param PARAM_FORMAT = new Param("format", "Output format, html|json|jsonp|txt - an extension in the URL overrides this");
    static final Param PARAM_HTTP_STATUS = new Param("httpStatus", "Specify HTTP result code, for example CRITICAL:503 (status 503 if result >= CRITICAL) or CRITICAL:503,HEALTH_CHECK_ERROR:500,OK:418 for more specific HTTP status");
    static final Param PARAM_COMBINE_TAGS_WITH_OR = new Param("combineTagsWithOr", "Combine tags with OR, active by default. Set to false to combine with AND");
    static final Param PARAM_FORCE_INSTANT_EXECUTION = new Param("forceInstantExecution", "If true, forces instant execution by executing async health checks directly, circumventing the cache (2sec by default) of the HealthCheckExecutor");
    static final Param PARAM_OVERRIDE_GLOBAL_TIMEOUT = new Param("timeout", "(msec) a timeout status is returned for any health check still running after this period. Overrides the default HealthCheckExecutor timeout");
    static final Param PARAM_INCLUDE_DEBUG = new Param("hcDebug", "Include the DEBUG output of the Health Checks");
    static final Param PARAM_NAMES = new Param("names", "Comma-separated list of health check names to select. Exclusions can be done by prepending '-' to the health check name");
    static final String JSONP_CALLBACK_DEFAULT = "processHealthCheckResults";
    static final Param PARAM_JSONP_CALLBACK = new Param("callback", "name of the JSONP callback function to use, defaults to processHealthCheckResults");
    static final Param[] PARAM_LIST = new Param[]{PARAM_TAGS, PARAM_NAMES, PARAM_FORMAT, PARAM_HTTP_STATUS, PARAM_COMBINE_TAGS_WITH_OR, PARAM_FORCE_INSTANT_EXECUTION, PARAM_OVERRIDE_GLOBAL_TIMEOUT, PARAM_INCLUDE_DEBUG, PARAM_JSONP_CALLBACK};
    static final String FORMAT_HTML = "html";
    static final String FORMAT_JSON = "json";
    static final String FORMAT_JSONP = "jsonp";
    static final String FORMAT_TXT = "txt";
    static final String FORMAT_VERBOSE_TXT = "verbose.txt";
    private static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_TXT = "text/plain";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_JSONP = "application/javascript";
    private static final String STATUS_HEADER_NAME = "X-Health";
    private static final String CACHE_CONTROL_KEY = "Cache-control";
    private static final String CACHE_CONTROL_VALUE = "no-cache";
    private static final String SERVLET_PATH_DEFAULT = "/system/health";
    public static final String PROPERTY_SERVLET_PATH = "servletPath";
    @Property(name="servletPath", label="Path", description="Servlet path (defaults to /system/health in order to not be accessible via Apache/Internet)", value={"/system/health"})
    private String servletPath;
    private String[] servletPaths;
    public static final String PROPERTY_DISABLED = "disabled";
    @Property(name="disabled", label="Disabled", description="Allows to disable the servlet if required for security reasons", boolValue={false})
    private boolean disabled;
    private static final String CORS_ORIGIN_HEADER_NAME = "Access-Control-Allow-Origin";
    public static final String CORS_ORIGIN_HEADER_DEFAULT_VALUE = "*";
    public static final String PROPERTY_CORS_ORIGIN_HEADER_VALUE = "cors.accessControlAllowOrigin";
    @Property(name="cors.accessControlAllowOrigin", label="CORS Access-Control-Allow-Origin", description="Sets the Access-Control-Allow-Origin CORS header. If blank no header is sent.", value={"*"})
    private String corsAccessControlAllowOrigin;
    @Reference
    private HttpService httpService;
    @Reference
    HealthCheckExecutor healthCheckExecutor;
    @Reference
    ResultHtmlSerializer htmlSerializer;
    @Reference
    ResultJsonSerializer jsonSerializer;
    @Reference
    ResultTxtSerializer txtSerializer;
    @Reference
    ResultTxtVerboseSerializer verboseTxtSerializer;

    @Activate
    protected final void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.servletPath = PropertiesUtil.toString(properties.get(PROPERTY_SERVLET_PATH), (String)SERVLET_PATH_DEFAULT);
        this.disabled = PropertiesUtil.toBoolean(properties.get(PROPERTY_DISABLED), (boolean)false);
        this.corsAccessControlAllowOrigin = PropertiesUtil.toString(properties.get(PROPERTY_CORS_ORIGIN_HEADER_VALUE), (String)CORS_ORIGIN_HEADER_DEFAULT_VALUE);
        LinkedHashMap<String, HttpServlet> servletsToRegister = new LinkedHashMap<String, HttpServlet>();
        servletsToRegister.put(this.servletPath, this);
        servletsToRegister.put(this.servletPath + "." + FORMAT_HTML, new ProxyServlet(FORMAT_HTML));
        servletsToRegister.put(this.servletPath + "." + FORMAT_JSON, new ProxyServlet(FORMAT_JSON));
        servletsToRegister.put(this.servletPath + "." + FORMAT_JSONP, new ProxyServlet(FORMAT_JSONP));
        servletsToRegister.put(this.servletPath + "." + FORMAT_TXT, new ProxyServlet(FORMAT_TXT));
        servletsToRegister.put(this.servletPath + "." + FORMAT_VERBOSE_TXT, new ProxyServlet(FORMAT_VERBOSE_TXT));
        if (this.disabled) {
            LOG.info("Health Check Servlet is disabled by configuration");
            return;
        }
        for (Map.Entry servlet : servletsToRegister.entrySet()) {
            try {
                LOG.debug("Registering {} to path {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), servlet.getKey());
                this.httpService.registerServlet((String)servlet.getKey(), (Servlet)servlet.getValue(), null, null);
            }
            catch (Exception e) {
                LOG.error("Could not register health check servlet: " + e, (Throwable)e);
            }
        }
        this.servletPaths = servletsToRegister.keySet().toArray(new String[0]);
    }

    @Deactivate
    public void deactivate(ComponentContext componentContext) {
        if (this.disabled || this.servletPaths == null) {
            return;
        }
        for (String servletPath : this.servletPaths) {
            try {
                LOG.debug("Unregistering path {}", (Object)servletPath);
                this.httpService.unregister(servletPath);
            }
            catch (Exception e) {
                LOG.error("Could not unregister health check servlet: " + e, (Throwable)e);
            }
        }
        this.servletPaths = null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response, String format) throws ServletException, IOException {
        HealthCheckSelector selector = HealthCheckSelector.empty();
        String pathInfo = request.getPathInfo();
        String pathTokensStr = StringUtils.removeStart((String)this.splitFormat(pathInfo)[0], (String)"/");
        List<Object> tags = new ArrayList();
        List<String> names = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)pathTokensStr)) {
            String[] pathTokens;
            for (String pathToken : pathTokens = pathTokensStr.split(PARAM_SPLIT_REGEX)) {
                if (pathToken.indexOf(32) >= 0) {
                    names.add(pathToken);
                    continue;
                }
                tags.add(pathToken);
            }
        }
        if (tags.size() == 0) {
            tags = Arrays.asList(((String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter(HealthCheckExecutorServlet.PARAM_TAGS.name), (CharSequence)"")).split(PARAM_SPLIT_REGEX));
        }
        selector.withTags(tags.toArray(new String[0]));
        if (names.size() == 0) {
            names = Arrays.asList(((String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter(HealthCheckExecutorServlet.PARAM_NAMES.name), (CharSequence)"")).split(PARAM_SPLIT_REGEX));
        }
        selector.withNames(names.toArray(new String[0]));
        Boolean includeDebug = Boolean.valueOf(request.getParameter(HealthCheckExecutorServlet.PARAM_INCLUDE_DEBUG.name));
        Map<Result.Status, Integer> statusMapping = request.getParameter(HealthCheckExecutorServlet.PARAM_HTTP_STATUS.name) != null ? this.getStatusMapping(request.getParameter(HealthCheckExecutorServlet.PARAM_HTTP_STATUS.name)) : null;
        HealthCheckExecutionOptions executionOptions = new HealthCheckExecutionOptions();
        executionOptions.setCombineTagsWithOr(Boolean.valueOf(StringUtils.defaultString((String)request.getParameter(HealthCheckExecutorServlet.PARAM_COMBINE_TAGS_WITH_OR.name), (String)"true")).booleanValue());
        executionOptions.setForceInstantExecution(Boolean.valueOf(request.getParameter(HealthCheckExecutorServlet.PARAM_FORCE_INSTANT_EXECUTION.name)).booleanValue());
        String overrideGlobalTimeoutVal = request.getParameter(HealthCheckExecutorServlet.PARAM_OVERRIDE_GLOBAL_TIMEOUT.name);
        if (StringUtils.isNumeric((CharSequence)overrideGlobalTimeoutVal)) {
            executionOptions.setOverrideGlobalTimeout(Integer.valueOf(overrideGlobalTimeoutVal).intValue());
        }
        List executionResults = this.healthCheckExecutor.execute(selector, executionOptions);
        Result.Status mostSevereStatus = Result.Status.DEBUG;
        for (HealthCheckExecutionResult executionResult : executionResults) {
            Result.Status status = executionResult.getHealthCheckResult().getStatus();
            if (status.ordinal() <= mostSevereStatus.ordinal()) continue;
            mostSevereStatus = status;
        }
        Result overallResult = new Result(mostSevereStatus, "Overall status " + mostSevereStatus);
        this.sendNoCacheHeaders(response);
        this.sendCorsHeaders(response);
        if (statusMapping != null) {
            Integer httpStatus = statusMapping.get(overallResult.getStatus());
            response.setStatus(httpStatus.intValue());
        }
        if (FORMAT_HTML.equals(format)) {
            this.sendHtmlResponse(overallResult, executionResults, request, response, includeDebug);
        } else if (FORMAT_JSON.equals(format)) {
            this.sendJsonResponse(overallResult, executionResults, null, response, includeDebug);
        } else if (FORMAT_JSONP.equals(format)) {
            String jsonpCallback = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter(HealthCheckExecutorServlet.PARAM_JSONP_CALLBACK.name), (CharSequence)JSONP_CALLBACK_DEFAULT);
            this.sendJsonResponse(overallResult, executionResults, jsonpCallback, response, includeDebug);
        } else if (StringUtils.endsWith((CharSequence)format, (CharSequence)FORMAT_TXT)) {
            this.sendTxtResponse(overallResult, response, StringUtils.equals((CharSequence)format, (CharSequence)FORMAT_VERBOSE_TXT), executionResults, includeDebug);
        } else {
            response.setContentType(CONTENT_TYPE_TXT);
            response.getWriter().println("Invalid format " + format + " - supported formats: html|json|jsonp|txt|verbose.txt");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        String format = this.splitFormat(pathInfo)[1];
        if (StringUtils.isBlank((CharSequence)format)) {
            format = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter(HealthCheckExecutorServlet.PARAM_FORMAT.name), (CharSequence)FORMAT_HTML);
        }
        this.doGet(request, response, format);
    }

    private String[] splitFormat(String pathInfo) {
        for (String format : new String[]{FORMAT_HTML, FORMAT_JSON, FORMAT_JSONP, FORMAT_VERBOSE_TXT, FORMAT_TXT}) {
            String formatWithDot = "." + format;
            if (!StringUtils.endsWith((CharSequence)pathInfo, (CharSequence)formatWithDot)) continue;
            return new String[]{StringUtils.substringBeforeLast((String)pathInfo, (String)formatWithDot), format};
        }
        return new String[]{pathInfo, null};
    }

    private void sendTxtResponse(Result overallResult, HttpServletResponse response, boolean verbose, List<HealthCheckExecutionResult> executionResults, boolean includeDebug) throws IOException {
        response.setContentType(CONTENT_TYPE_TXT);
        response.setCharacterEncoding("UTF-8");
        if (verbose) {
            response.getWriter().write(this.verboseTxtSerializer.serialize(overallResult, executionResults, includeDebug));
        } else {
            response.getWriter().write(this.txtSerializer.serialize(overallResult));
        }
    }

    private void sendJsonResponse(Result overallResult, List<HealthCheckExecutionResult> executionResults, String jsonpCallback, HttpServletResponse response, boolean includeDebug) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)jsonpCallback)) {
            response.setContentType(CONTENT_TYPE_JSONP);
        } else {
            response.setContentType(CONTENT_TYPE_JSON);
        }
        response.setCharacterEncoding("UTF-8");
        String resultJson = this.jsonSerializer.serialize(overallResult, executionResults, jsonpCallback, includeDebug);
        PrintWriter writer = response.getWriter();
        writer.append(resultJson);
    }

    private void sendHtmlResponse(Result overallResult, List<HealthCheckExecutionResult> executionResults, HttpServletRequest request, HttpServletResponse response, boolean includeDebug) throws IOException {
        response.setContentType(CONTENT_TYPE_HTML);
        response.setCharacterEncoding("UTF-8");
        response.setHeader(STATUS_HEADER_NAME, overallResult.toString());
        response.getWriter().append(this.htmlSerializer.serialize(overallResult, executionResults, this.getHtmlHelpText(), includeDebug));
    }

    private void sendNoCacheHeaders(HttpServletResponse response) {
        response.setHeader(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
    }

    private void sendCorsHeaders(HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)this.corsAccessControlAllowOrigin)) {
            response.setHeader(CORS_ORIGIN_HEADER_NAME, this.corsAccessControlAllowOrigin);
        }
    }

    private String getHtmlHelpText() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>Supported URL parameters</h3>\n");
        for (Param p : PARAM_LIST) {
            sb.append("<b>").append(p.name).append("</b>:");
            sb.append(StringEscapeUtils.escapeHtml4((String)p.description));
            sb.append("<br/>");
        }
        return sb.toString();
    }

    Map<Result.Status, Integer> getStatusMapping(String mappingStr) throws ServletException {
        HashMap<Result.Status, Integer> statusMapping = new HashMap<Result.Status, Integer>();
        try {
            String[] bits;
            for (String bit : bits = mappingStr.split("[,]")) {
                String[] tuple = bit.split("[:]");
                statusMapping.put(Result.Status.valueOf((String)tuple[0]), Integer.parseInt(tuple[1]));
            }
        }
        catch (Exception e) {
            throw new ServletException("Invalid parameter httpStatus=" + mappingStr + " " + e, (Throwable)e);
        }
        if (!statusMapping.containsKey(Result.Status.OK)) {
            statusMapping.put(Result.Status.OK, 200);
        }
        if (!statusMapping.containsKey(Result.Status.WARN)) {
            statusMapping.put(Result.Status.WARN, (Integer)statusMapping.get(Result.Status.OK));
        }
        if (!statusMapping.containsKey(Result.Status.CRITICAL)) {
            statusMapping.put(Result.Status.CRITICAL, (Integer)statusMapping.get(Result.Status.WARN));
        }
        if (!statusMapping.containsKey(Result.Status.HEALTH_CHECK_ERROR)) {
            statusMapping.put(Result.Status.HEALTH_CHECK_ERROR, (Integer)statusMapping.get(Result.Status.CRITICAL));
        }
        return statusMapping;
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        this.healthCheckExecutor = healthCheckExecutor;
    }

    protected void unbindHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        if (this.healthCheckExecutor == healthCheckExecutor) {
            this.healthCheckExecutor = null;
        }
    }

    protected void bindHtmlSerializer(ResultHtmlSerializer resultHtmlSerializer) {
        this.htmlSerializer = resultHtmlSerializer;
    }

    protected void unbindHtmlSerializer(ResultHtmlSerializer resultHtmlSerializer) {
        if (this.htmlSerializer == resultHtmlSerializer) {
            this.htmlSerializer = null;
        }
    }

    protected void bindJsonSerializer(ResultJsonSerializer resultJsonSerializer) {
        this.jsonSerializer = resultJsonSerializer;
    }

    protected void unbindJsonSerializer(ResultJsonSerializer resultJsonSerializer) {
        if (this.jsonSerializer == resultJsonSerializer) {
            this.jsonSerializer = null;
        }
    }

    protected void bindTxtSerializer(ResultTxtSerializer resultTxtSerializer) {
        this.txtSerializer = resultTxtSerializer;
    }

    protected void unbindTxtSerializer(ResultTxtSerializer resultTxtSerializer) {
        if (this.txtSerializer == resultTxtSerializer) {
            this.txtSerializer = null;
        }
    }

    protected void bindVerboseTxtSerializer(ResultTxtVerboseSerializer resultTxtVerboseSerializer) {
        this.verboseTxtSerializer = resultTxtVerboseSerializer;
    }

    protected void unbindVerboseTxtSerializer(ResultTxtVerboseSerializer resultTxtVerboseSerializer) {
        if (this.verboseTxtSerializer == resultTxtVerboseSerializer) {
            this.verboseTxtSerializer = null;
        }
    }

    private class ProxyServlet
    extends HttpServlet {
        private final String format;

        private ProxyServlet(String format) {
            this.format = format;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            HealthCheckExecutorServlet.this.doGet(req, resp, this.format);
        }
    }

    static class Param {
        final String name;
        final String description;

        Param(String n, String d) {
            this.name = n;
            this.description = d;
        }
    }
}

