/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl.executor;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.core.impl.executor.ExecutionResult;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.hc.util.HealthCheckMetadata;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HealthCheckFuture
extends FutureTask<ExecutionResult> {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckFuture.class);
    private final HealthCheckMetadata metadata;
    private final Date createdTime = new Date();

    HealthCheckFuture(final HealthCheckMetadata metadata, final BundleContext bundleContext, final Callback callback) {
        super(new Callable<ExecutionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ExecutionResult call() throws Exception {
                ExecutionResult executionResult;
                block7: {
                    Thread.currentThread().setName("HealthCheck " + metadata.getTitle());
                    LOG.debug("Starting check {}", (Object)metadata);
                    StopWatch stopWatch = new StopWatch();
                    stopWatch.start();
                    Result resultFromHealthCheck = null;
                    executionResult = null;
                    HealthCheck healthCheck = (HealthCheck)bundleContext.getService(metadata.getServiceReference());
                    try {
                        if (healthCheck != null) {
                            resultFromHealthCheck = healthCheck.execute();
                            break block7;
                        }
                        throw new IllegalStateException("Service for " + metadata + " is gone");
                    }
                    catch (Exception e) {
                        resultFromHealthCheck = new Result(Result.Status.CRITICAL, "Exception during execution of '" + metadata.getName() + "': " + e, e);
                    }
                    finally {
                        bundleContext.ungetService(metadata.getServiceReference());
                        stopWatch.stop();
                        long elapsedTime = stopWatch.getTime();
                        if (resultFromHealthCheck != null) {
                            executionResult = new ExecutionResult(metadata, resultFromHealthCheck, elapsedTime);
                        }
                        LOG.debug("Time consumed for {}: {}", (Object)metadata, (Object)FormattingResultLog.msHumanReadable((long)elapsedTime));
                    }
                }
                callback.finished(executionResult);
                Thread.currentThread().setName("HealthCheck idle");
                return executionResult;
            }
        });
        this.metadata = metadata;
    }

    Date getCreatedTime() {
        return this.createdTime;
    }

    public HealthCheckMetadata getHealthCheckMetadata() {
        return this.metadata;
    }

    @Override
    public String toString() {
        return "[Future for " + this.metadata + ", createdTime=" + this.createdTime + "]";
    }

    public static interface Callback {
        public void finished(HealthCheckExecutionResult var1);
    }
}

