/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl.executor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.threads.ModifiableThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.api.execution.HealthCheckExecutor;
import org.apache.sling.hc.api.execution.HealthCheckSelector;
import org.apache.sling.hc.core.impl.executor.AsyncHealthCheckExecutor;
import org.apache.sling.hc.core.impl.executor.ExecutionResult;
import org.apache.sling.hc.core.impl.executor.ExtendedHealthCheckExecutor;
import org.apache.sling.hc.core.impl.executor.HealthCheckFuture;
import org.apache.sling.hc.core.impl.executor.HealthCheckResultCache;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.hc.util.HealthCheckFilter;
import org.apache.sling.hc.util.HealthCheckMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={HealthCheckExecutor.class, ExtendedHealthCheckExecutor.class})
@Component(label="Apache Sling Health Check Executor", description="Runs health checks for a given list of tags in parallel.", metatype=true, immediate=true)
public class HealthCheckExecutorImpl
implements ExtendedHealthCheckExecutor,
ServiceListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long TIMEOUT_DEFAULT_MS = 2000L;
    public static final String PROP_TIMEOUT_MS = "timeoutInMs";
    @Property(name="timeoutInMs", label="Timeout", description="Timeout in ms until a check is marked as timed out", longValue={2000L})
    private static final long LONGRUNNING_FUTURE_THRESHOLD_CRITICAL_DEFAULT_MS = 300000L;
    public static final String PROP_LONGRUNNING_FUTURE_THRESHOLD_CRITICAL_MS = "longRunningFutureThresholdForCriticalMs";
    @Property(name="longRunningFutureThresholdForCriticalMs", label="Timeout threshold for CRITICAL", description="Threshold in ms until a check is marked as 'exceedingly' timed out and will marked CRITICAL instead of WARN only", longValue={300000L})
    private static final long RESULT_CACHE_TTL_DEFAULT_MS = 2000L;
    public static final String PROP_RESULT_CACHE_TTL_MS = "resultCacheTtlInMs";
    @Property(name="resultCacheTtlInMs", label="Results Cache TTL in Ms", description="Result Cache time to live - results will be cached for the given time", longValue={2000L})
    private long timeoutInMs;
    private long longRunningFutureThresholdForRedMs;
    private long resultCacheTtlInMs;
    private HealthCheckResultCache healthCheckResultCache = new HealthCheckResultCache();
    private final Map<HealthCheckMetadata, HealthCheckFuture> stillRunningFutures = new HashMap<HealthCheckMetadata, HealthCheckFuture>();
    @Reference
    private AsyncHealthCheckExecutor asyncHealthCheckExecutor;
    @Reference
    private ThreadPoolManager threadPoolManager;
    private ThreadPool hcThreadPool;
    private BundleContext bundleContext;

    @Activate
    protected final void activate(Map<String, Object> properties, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        ModifiableThreadPoolConfig hcThreadPoolConfig = new ModifiableThreadPoolConfig();
        hcThreadPoolConfig.setMaxPoolSize(25);
        this.hcThreadPool = this.threadPoolManager.create((ThreadPoolConfig)hcThreadPoolConfig, "Health Check Thread Pool");
        this.modified(properties);
        try {
            this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + HealthCheck.class.getName() + ")");
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException("Unexpected exception occured.", ise);
        }
    }

    @Modified
    protected final void modified(Map<String, Object> properties) {
        this.timeoutInMs = PropertiesUtil.toLong((Object)properties.get(PROP_TIMEOUT_MS), (long)2000L);
        if (this.timeoutInMs <= 0L) {
            this.timeoutInMs = 2000L;
        }
        this.longRunningFutureThresholdForRedMs = PropertiesUtil.toLong((Object)properties.get(PROP_LONGRUNNING_FUTURE_THRESHOLD_CRITICAL_MS), (long)300000L);
        if (this.longRunningFutureThresholdForRedMs <= 0L) {
            this.longRunningFutureThresholdForRedMs = 300000L;
        }
        this.resultCacheTtlInMs = PropertiesUtil.toLong((Object)properties.get(PROP_RESULT_CACHE_TTL_MS), (long)2000L);
        if (this.resultCacheTtlInMs <= 0L) {
            this.resultCacheTtlInMs = 2000L;
        }
    }

    @Deactivate
    protected final void deactivate() {
        this.threadPoolManager.release(this.hcThreadPool);
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.bundleContext = null;
        this.healthCheckResultCache.clear();
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 4) {
            Long serviceId = (Long)event.getServiceReference().getProperty("service.id");
            this.healthCheckResultCache.removeCachedResult(serviceId);
        }
    }

    public List<HealthCheckExecutionResult> execute(HealthCheckSelector selector) {
        return this.execute(selector, new HealthCheckExecutionOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HealthCheckExecutionResult> execute(HealthCheckSelector selector, HealthCheckExecutionOptions options) {
        this.logger.debug("Starting executing checks for filter selector {} and execution options {}", (Object)selector, (Object)options);
        HealthCheckFilter filter = new HealthCheckFilter(this.bundleContext);
        try {
            ServiceReference[] healthCheckReferences = filter.getHealthCheckServiceReferences(selector, options.isCombineTagsWithOr());
            List<HealthCheckExecutionResult> list = this.execute(healthCheckReferences, options);
            return list;
        }
        finally {
            filter.dispose();
        }
    }

    public List<HealthCheckExecutionResult> execute(String ... tags) {
        return this.execute(new HealthCheckExecutionOptions(), tags);
    }

    public List<HealthCheckExecutionResult> execute(HealthCheckExecutionOptions options, String ... tags) {
        return this.execute(HealthCheckSelector.tags((String[])tags), options);
    }

    @Override
    public HealthCheckExecutionResult execute(ServiceReference ref) {
        HealthCheckMetadata metadata = this.getHealthCheckMetadata(ref);
        return this.createResultsForDescriptor(metadata);
    }

    private List<HealthCheckExecutionResult> execute(ServiceReference[] healthCheckReferences, HealthCheckExecutionOptions options) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ArrayList<HealthCheckExecutionResult> results = new ArrayList<HealthCheckExecutionResult>();
        List<HealthCheckMetadata> healthCheckDescriptors = this.getHealthCheckMetadata(healthCheckReferences);
        this.createResultsForDescriptors(healthCheckDescriptors, results, options);
        stopWatch.stop();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Time consumed for all checks: {}", (Object)FormattingResultLog.msHumanReadable((long)stopWatch.getTime()));
        }
        Collections.sort(results, new Comparator<HealthCheckExecutionResult>(){

            @Override
            public int compare(HealthCheckExecutionResult arg0, HealthCheckExecutionResult arg1) {
                return ((ExecutionResult)arg0).compareTo((ExecutionResult)arg1);
            }
        });
        return results;
    }

    private void createResultsForDescriptors(List<HealthCheckMetadata> healthCheckDescriptors, List<HealthCheckExecutionResult> results, HealthCheckExecutionOptions options) {
        if (!options.isForceInstantExecution()) {
            this.asyncHealthCheckExecutor.collectAsyncResults(healthCheckDescriptors, results, this.healthCheckResultCache);
        }
        if (!options.isForceInstantExecution()) {
            this.healthCheckResultCache.useValidCacheResults(healthCheckDescriptors, results, this.resultCacheTtlInMs);
        }
        List<HealthCheckFuture> futures = this.createOrReuseFutures(healthCheckDescriptors);
        this.waitForFuturesRespectingTimeout(futures, options);
        this.collectResultsFromFutures(futures, results);
        this.appendStickyResultLogIfConfigured(results);
    }

    private void appendStickyResultLogIfConfigured(List<HealthCheckExecutionResult> results) {
        ListIterator<HealthCheckExecutionResult> resultsIt = results.listIterator();
        while (resultsIt.hasNext()) {
            HealthCheckExecutionResult result = resultsIt.next();
            Long warningsStickForMinutes = result.getHealthCheckMetadata().getWarningsStickForMinutes();
            if (warningsStickForMinutes == null || warningsStickForMinutes <= 0L) continue;
            result = this.healthCheckResultCache.createExecutionResultWithStickyResults(result);
            resultsIt.set(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckExecutionResult createResultsForDescriptor(HealthCheckMetadata metadata) {
        HealthCheckExecutionResult result = this.healthCheckResultCache.getValidCacheResult(metadata, this.resultCacheTtlInMs);
        if (result == null) {
            HealthCheckFuture future;
            Map<HealthCheckMetadata, HealthCheckFuture> map = this.stillRunningFutures;
            synchronized (map) {
                future = this.createOrReuseFuture(metadata);
            }
            this.waitForFuturesRespectingTimeout(Collections.singletonList(future), null);
            result = this.collectResultFromFuture(future);
        }
        return result;
    }

    private List<HealthCheckMetadata> getHealthCheckMetadata(ServiceReference ... healthCheckReferences) {
        LinkedList<HealthCheckMetadata> descriptors = new LinkedList<HealthCheckMetadata>();
        for (ServiceReference serviceReference : healthCheckReferences) {
            HealthCheckMetadata descriptor = this.getHealthCheckMetadata(serviceReference);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    private HealthCheckMetadata getHealthCheckMetadata(ServiceReference healthCheckReference) {
        HealthCheckMetadata descriptor = new HealthCheckMetadata(healthCheckReference);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HealthCheckFuture> createOrReuseFutures(List<HealthCheckMetadata> healthCheckDescriptors) {
        LinkedList<HealthCheckFuture> futuresForResultOfThisCall = new LinkedList<HealthCheckFuture>();
        Map<HealthCheckMetadata, HealthCheckFuture> map = this.stillRunningFutures;
        synchronized (map) {
            for (HealthCheckMetadata md : healthCheckDescriptors) {
                futuresForResultOfThisCall.add(this.createOrReuseFuture(md));
            }
        }
        return futuresForResultOfThisCall;
    }

    private HealthCheckFuture createOrReuseFuture(final HealthCheckMetadata metadata) {
        HealthCheckFuture future = this.stillRunningFutures.get(metadata);
        if (future != null) {
            this.logger.debug("Found a future that is still running for {}", (Object)metadata);
        } else {
            this.logger.debug("Creating future for {}", (Object)metadata);
            future = new HealthCheckFuture(metadata, this.bundleContext, new HealthCheckFuture.Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void finished(HealthCheckExecutionResult result) {
                    HealthCheckExecutorImpl.this.healthCheckResultCache.updateWith(result);
                    HealthCheckExecutorImpl.this.asyncHealthCheckExecutor.updateWith(result);
                    Map map = HealthCheckExecutorImpl.this.stillRunningFutures;
                    synchronized (map) {
                        HealthCheckExecutorImpl.this.stillRunningFutures.remove(metadata);
                    }
                }
            });
            this.stillRunningFutures.put(metadata, future);
            final HealthCheckFuture newFuture = future;
            this.hcThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    newFuture.run();
                    Map map = HealthCheckExecutorImpl.this.stillRunningFutures;
                    synchronized (map) {
                        HealthCheckExecutorImpl.this.stillRunningFutures.notifyAll();
                    }
                }
            });
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFuturesRespectingTimeout(List<HealthCheckFuture> futuresForResultOfThisCall, HealthCheckExecutionOptions options) {
        boolean allFuturesDone;
        StopWatch callExcutionTimeStopWatch = new StopWatch();
        callExcutionTimeStopWatch.start();
        long effectiveTimeout = this.timeoutInMs;
        if (options != null && options.getOverrideGlobalTimeout() > 0) {
            effectiveTimeout = options.getOverrideGlobalTimeout();
        }
        if (futuresForResultOfThisCall.isEmpty()) {
            return;
        }
        do {
            try {
                Map<HealthCheckMetadata, HealthCheckFuture> map = this.stillRunningFutures;
                synchronized (map) {
                    this.stillRunningFutures.wait(50L);
                }
            }
            catch (InterruptedException ie) {
                this.logger.warn("Unexpected InterruptedException while waiting for healthCheckContributors", (Throwable)ie);
            }
            allFuturesDone = true;
            for (HealthCheckFuture healthCheckFuture : futuresForResultOfThisCall) {
                allFuturesDone &= healthCheckFuture.isDone();
            }
        } while (!allFuturesDone && callExcutionTimeStopWatch.getTime() < effectiveTimeout);
    }

    void collectResultsFromFutures(List<HealthCheckFuture> futuresForResultOfThisCall, Collection<HealthCheckExecutionResult> results) {
        HashSet<HealthCheckExecutionResult> resultsFromFutures = new HashSet<HealthCheckExecutionResult>();
        Iterator<HealthCheckFuture> futuresIt = futuresForResultOfThisCall.iterator();
        while (futuresIt.hasNext()) {
            HealthCheckFuture future = futuresIt.next();
            HealthCheckExecutionResult result = this.collectResultFromFuture(future);
            resultsFromFutures.add(result);
            futuresIt.remove();
        }
        this.logger.debug("Adding {} results from futures", (Object)resultsFromFutures.size());
        results.addAll(resultsFromFutures);
    }

    HealthCheckExecutionResult collectResultFromFuture(HealthCheckFuture future) {
        HealthCheckExecutionResult result;
        HealthCheckMetadata hcMetadata = future.getHealthCheckMetadata();
        if (future.isDone()) {
            this.logger.debug("Health Check is done: {}", (Object)hcMetadata);
            try {
                result = (HealthCheckExecutionResult)future.get();
            }
            catch (Exception e) {
                this.logger.warn("Unexpected Exception during future.get(): " + e, (Throwable)e);
                long futureElapsedTimeMs = new Date().getTime() - future.getCreatedTime().getTime();
                result = new ExecutionResult(hcMetadata, Result.Status.HEALTH_CHECK_ERROR, "Unexpected Exception during future.get(): " + e, futureElapsedTimeMs, false);
            }
        } else {
            this.logger.debug("Health Check timed out: {}", (Object)hcMetadata);
            long futureElapsedTimeMs = new Date().getTime() - future.getCreatedTime().getTime();
            FormattingResultLog resultLog = new FormattingResultLog();
            if (futureElapsedTimeMs < this.longRunningFutureThresholdForRedMs) {
                resultLog.warn("Timeout: Check still running after " + FormattingResultLog.msHumanReadable((long)futureElapsedTimeMs), new Object[0]);
            } else {
                resultLog.critical("Timeout: Check still running after " + FormattingResultLog.msHumanReadable((long)futureElapsedTimeMs) + " (exceeding the configured threshold for CRITICAL: " + FormattingResultLog.msHumanReadable((long)this.longRunningFutureThresholdForRedMs) + ")", new Object[0]);
            }
            HealthCheckExecutionResult lastCachedResult = this.healthCheckResultCache.getValidCacheResult(hcMetadata, 1471228928L);
            if (lastCachedResult != null) {
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
                resultLog.info("*** Result log of last execution finished at {} after {} ***", new Object[]{df.format(lastCachedResult.getFinishedAt()), FormattingResultLog.msHumanReadable((long)lastCachedResult.getElapsedTimeInMs())});
                for (ResultLog.Entry entry : lastCachedResult.getHealthCheckResult()) {
                    resultLog.add(entry);
                }
            }
            result = new ExecutionResult(hcMetadata, new Result((ResultLog)resultLog), futureElapsedTimeMs, true);
        }
        return result;
    }

    public void setTimeoutInMs(long timeoutInMs) {
        this.timeoutInMs = timeoutInMs;
    }

    public void setLongRunningFutureThresholdForRedMs(long longRunningFutureThresholdForRedMs) {
        this.longRunningFutureThresholdForRedMs = longRunningFutureThresholdForRedMs;
    }

    protected void bindAsyncHealthCheckExecutor(AsyncHealthCheckExecutor asyncHealthCheckExecutor) {
        this.asyncHealthCheckExecutor = asyncHealthCheckExecutor;
    }

    protected void unbindAsyncHealthCheckExecutor(AsyncHealthCheckExecutor asyncHealthCheckExecutor) {
        if (this.asyncHealthCheckExecutor == asyncHealthCheckExecutor) {
            this.asyncHealthCheckExecutor = null;
        }
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }
}

