/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl.executor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.api.execution.HealthCheckSelector;
import org.apache.sling.hc.core.impl.executor.ExecutionResult;
import org.apache.sling.hc.core.impl.executor.HealthCheckFuture;
import org.apache.sling.hc.core.impl.executor.HealthCheckResultCache;
import org.apache.sling.hc.util.HealthCheckFilter;
import org.apache.sling.hc.util.HealthCheckMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={AsyncHealthCheckExecutor.class})
@Component(immediate=true)
public class AsyncHealthCheckExecutor
implements ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncHealthCheckExecutor.class);
    @Reference
    private Scheduler scheduler;
    private Map<HealthCheckMetadata, ExecutionResult> asyncResultsByDescriptor = new ConcurrentHashMap<HealthCheckMetadata, ExecutionResult>();
    private Map<HealthCheckMetadata, HealthCheckAsyncJob> registeredJobs = new HashMap<HealthCheckMetadata, HealthCheckAsyncJob>();
    private BundleContext bundleContext;

    @Activate
    protected final void activate(ComponentContext componentContext) {
        ServiceReference[] healthCheckReferences;
        this.bundleContext = componentContext.getBundleContext();
        this.bundleContext.addServiceListener((ServiceListener)this);
        int count = 0;
        HealthCheckFilter healthCheckFilter = new HealthCheckFilter(this.bundleContext);
        for (ServiceReference serviceReference : healthCheckReferences = healthCheckFilter.getHealthCheckServiceReferences(HealthCheckSelector.empty())) {
            HealthCheckMetadata healthCheckMetadata = new HealthCheckMetadata(serviceReference);
            if (!this.isAsync(healthCheckMetadata) || !this.scheduleHealthCheck(healthCheckMetadata)) continue;
            ++count;
        }
        LOG.debug("Scheduled {} jobs for asynchronous health checks", (Object)count);
    }

    @Deactivate
    protected final void deactivate(ComponentContext componentContext) {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.bundleContext = null;
        LOG.debug("Unscheduling {} jobs for asynchronous health checks", (Object)this.registeredJobs.size());
        for (HealthCheckMetadata healthCheckDescriptor : new LinkedList<HealthCheckMetadata>(this.registeredJobs.keySet())) {
            this.unscheduleHealthCheck(healthCheckDescriptor);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.bundleContext == null) {
            return;
        }
        ServiceReference serviceReference = event.getServiceReference();
        boolean isHealthCheck = serviceReference.isAssignableTo(this.bundleContext.getBundle(), HealthCheck.class.getName());
        if (isHealthCheck) {
            HealthCheckMetadata healthCheckMetadata = new HealthCheckMetadata(serviceReference);
            int eventType = event.getType();
            LOG.debug("Received service event of type {} for health check {}", (Object)eventType, (Object)healthCheckMetadata);
            if (eventType == 1) {
                this.scheduleHealthCheck(healthCheckMetadata);
            } else if (eventType == 4) {
                this.unscheduleHealthCheck(healthCheckMetadata);
            } else if (eventType == 2) {
                this.unscheduleHealthCheck(healthCheckMetadata);
                this.scheduleHealthCheck(healthCheckMetadata);
            }
        }
    }

    private boolean scheduleHealthCheck(HealthCheckMetadata descriptor) {
        if (!this.isAsync(descriptor)) {
            return false;
        }
        try {
            HealthCheckAsyncJob healthCheckAsyncJob = new HealthCheckAsyncJob(descriptor);
            LOG.debug("Scheduling job {} with cron expression {}", (Object)healthCheckAsyncJob, (Object)descriptor.getAsyncCronExpression());
            boolean concurrent = false;
            this.scheduler.addJob(healthCheckAsyncJob.getJobId(), (Object)healthCheckAsyncJob, null, descriptor.getAsyncCronExpression(), false);
            this.registeredJobs.put(descriptor, healthCheckAsyncJob);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Could not schedule job for " + descriptor + ". Exception: " + e, (Throwable)e);
            return false;
        }
    }

    private boolean unscheduleHealthCheck(HealthCheckMetadata descriptor) {
        HealthCheckAsyncJob job = this.registeredJobs.remove(descriptor);
        try {
            if (job != null) {
                LOG.debug("Unscheduling job {} with cron expression '{}'", (Object)job, (Object)descriptor.getAsyncCronExpression());
                this.scheduler.removeJob(job.getJobId());
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Could not unschedule job " + job + ". Exception: " + e, (Throwable)e);
        }
        return false;
    }

    void collectAsyncResults(List<HealthCheckMetadata> healthCheckDescriptors, Collection<HealthCheckExecutionResult> results, HealthCheckResultCache cache) {
        Iterator<HealthCheckMetadata> checksIt = healthCheckDescriptors.iterator();
        TreeSet<ExecutionResult> asyncResults = new TreeSet<ExecutionResult>();
        while (checksIt.hasNext()) {
            HealthCheckMetadata healthCheckMetadata = checksIt.next();
            if (!this.isAsync(healthCheckMetadata)) continue;
            ExecutionResult result = this.asyncResultsByDescriptor.get(healthCheckMetadata);
            if (result == null) {
                result = new ExecutionResult(healthCheckMetadata, new Result(Result.Status.INFO, "Async Health Check with cron expression '" + healthCheckMetadata.getAsyncCronExpression() + "' has not yet been executed."), 0L);
                asyncResults.add(result);
            }
            asyncResults.add(result);
            checksIt.remove();
        }
        LOG.debug("Caching {} results from async results", (Object)asyncResults.size());
        for (ExecutionResult result : asyncResults) {
            cache.updateWith(result);
        }
        LOG.debug("Adding {} results from async results", (Object)asyncResults.size());
        results.addAll(asyncResults);
    }

    void updateWith(HealthCheckExecutionResult result) {
        if (this.isAsync(result.getHealthCheckMetadata())) {
            this.asyncResultsByDescriptor.put(result.getHealthCheckMetadata(), (ExecutionResult)result);
            LOG.debug("Updated result for async hc {} with {}", (Object)result.getHealthCheckMetadata(), (Object)result);
        }
    }

    private boolean isAsync(HealthCheckMetadata healthCheckMetadata) {
        return StringUtils.isNotBlank((CharSequence)healthCheckMetadata.getAsyncCronExpression());
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    private class HealthCheckAsyncJob
    implements Runnable {
        private final HealthCheckMetadata healthCheckDescriptor;

        public HealthCheckAsyncJob(HealthCheckMetadata healthCheckDescriptor) {
            this.healthCheckDescriptor = healthCheckDescriptor;
        }

        public String getJobId() {
            String jobId = "job-hc-" + this.healthCheckDescriptor.getServiceId();
            return jobId;
        }

        @Override
        public void run() {
            LOG.debug("Running job {}", (Object)this);
            HealthCheckFuture healthCheckFuture = new HealthCheckFuture(this.healthCheckDescriptor, AsyncHealthCheckExecutor.this.bundleContext, new HealthCheckFuture.Callback(){

                @Override
                public void finished(HealthCheckExecutionResult result) {
                    AsyncHealthCheckExecutor.this.updateWith(result);
                }
            });
            healthCheckFuture.run();
        }

        public String toString() {
            return "[Async job for " + this.healthCheckDescriptor + "]";
        }
    }
}

