/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class JmxAdjustableStatusForTesting {
    private static final Logger LOG = LoggerFactory.getLogger(JmxAdjustableStatusForTesting.class);
    private static final String OBJECT_NAME = "org.apache.sling.healthcheck:type=AdjustableHealthCheckForTesting";
    private BundleContext bundleContext;
    private ServiceRegistration mbeanRegistration = null;
    private ServiceRegistration healthCheckRegistration = null;

    @Activate
    protected final void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        this.registerMbean();
    }

    @Deactivate
    protected final void deactivate(ComponentContext context) {
        this.unregisterMbean();
        this.unregisterDynamicTestingHealthCheck();
    }

    private void registerMbean() {
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
        ((Dictionary)mbeanProps).put("jmx.objectname", OBJECT_NAME);
        AdjustableHealthCheckStatusMBean adjustableHealthCheckStatusMBean = new AdjustableHealthCheckStatusMBean();
        this.mbeanRegistration = this.bundleContext.registerService(DynamicMBean.class.getName(), (Object)adjustableHealthCheckStatusMBean, mbeanProps);
        LOG.debug("Registered mbean {} as {}", (Object)adjustableHealthCheckStatusMBean, (Object)OBJECT_NAME);
    }

    private void unregisterMbean() {
        if (this.mbeanRegistration != null) {
            this.mbeanRegistration.unregister();
            this.mbeanRegistration = null;
            LOG.debug("Unregistered mbean AdjustableHealthCheckStatusMBean");
        }
    }

    private synchronized void registerDynamicTestingHealthCheck(Result.Status status, String[] tags) {
        this.unregisterDynamicTestingHealthCheck();
        DynamicTestingHealthCheck healthCheck = new DynamicTestingHealthCheck(status);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("hc.name", "JMX-adjustable Testing Check");
        ((Dictionary)props).put("hc.tags", tags);
        this.healthCheckRegistration = this.bundleContext.registerService(HealthCheck.class.getName(), (Object)healthCheck, props);
    }

    private synchronized void unregisterDynamicTestingHealthCheck() {
        if (this.healthCheckRegistration != null) {
            this.healthCheckRegistration.unregister();
            this.healthCheckRegistration = null;
            LOG.debug("Unregistered DynamicTestingHealthCheck");
        }
    }

    private class AdjustableHealthCheckStatusMBean
    implements DynamicMBean {
        private static final String OP_RESET = "reset";
        private static final String OP_ADD_WARN_RESULT_FOR_TAGS = "addWarnResultForTags";
        private static final String OP_ADD_CRITICAL_RESULT_FOR_TAGS = "addCriticalResultForTags";
        private static final String ATT_TAGS = "tags";
        private static final String ATT_STATUS = "status";
        private static final String STATUS_INACTIVE = "INACTIVE";
        private final MBeanInfo mbeanInfo;
        private List<String> tags = new ArrayList<String>();
        private String status = "INACTIVE";

        public AdjustableHealthCheckStatusMBean() {
            this.mbeanInfo = this.createMBeanInfo();
        }

        @Override
        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (ATT_TAGS.equals(attribute)) {
                return StringUtils.join(this.tags, (String)",");
            }
            if (ATT_STATUS.equals(attribute)) {
                return this.status.toString();
            }
            throw new AttributeNotFoundException("Attribute " + attribute + " not found.");
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            AttributeList result = new AttributeList();
            for (String att : attributes) {
                try {
                    result.add(new Attribute(att, this.getAttribute(att)));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
            return result;
        }

        private MBeanInfo createMBeanInfo() {
            ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
            attrs.add(new MBeanAttributeInfo(ATT_TAGS, String.class.getName(), "Tags", true, false, false));
            attrs.add(new MBeanAttributeInfo(ATT_STATUS, String.class.getName(), "Status", true, false, false));
            MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo(ATT_TAGS, "java.lang.String", "Comma separated list of tags")};
            ArrayList<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();
            ops.add(new MBeanOperationInfo(OP_RESET, "Resets this testing mechanism and removes the failing HC", new MBeanParameterInfo[0], "java.lang.String", 1));
            ops.add(new MBeanOperationInfo(OP_ADD_CRITICAL_RESULT_FOR_TAGS, "Adds a critical result for the given tags", params, "java.lang.String", 1));
            ops.add(new MBeanOperationInfo(OP_ADD_WARN_RESULT_FOR_TAGS, "Adds a warn result for the given tags", params, "java.lang.String", 1));
            return new MBeanInfo(this.getClass().getName(), "Adjustable Health Check", attrs.toArray(new MBeanAttributeInfo[attrs.size()]), null, ops.toArray(new MBeanOperationInfo[ops.size()]), null);
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            return this.mbeanInfo;
        }

        @Override
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            if (OP_RESET.equals(actionName)) {
                this.tags = Arrays.asList("");
                this.status = STATUS_INACTIVE;
                JmxAdjustableStatusForTesting.this.unregisterDynamicTestingHealthCheck();
                LOG.info("JMX-adjustable Health Check for testing was reset");
                return "Reset successful";
            }
            if (OP_ADD_CRITICAL_RESULT_FOR_TAGS.equals(actionName)) {
                String[] newTags = params[0].toString().split("[,; ]+");
                this.tags = Arrays.asList(newTags);
                Result.Status critical = Result.Status.CRITICAL;
                this.status = critical.toString();
                JmxAdjustableStatusForTesting.this.registerDynamicTestingHealthCheck(critical, newTags);
                LOG.info("Activated JMX-adjustable Health Check with status CRITICAL and tags " + StringUtils.join(this.tags, (String)","));
                return "Added check with result CRITICAL";
            }
            if (OP_ADD_WARN_RESULT_FOR_TAGS.equals(actionName)) {
                String[] newTags = params[0].toString().split("[,; ]+");
                this.tags = Arrays.asList(newTags);
                Result.Status warn = Result.Status.WARN;
                this.status = warn.toString();
                JmxAdjustableStatusForTesting.this.registerDynamicTestingHealthCheck(warn, newTags);
                LOG.info("Activated JMX-adjustable Health Check with status WARN and tags " + StringUtils.join(this.tags, (String)","));
                return "Added check with result WARN";
            }
            throw new MBeanException(new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support operation " + actionName));
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new MBeanException(new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support setting attributes."));
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            return new AttributeList();
        }
    }

    class DynamicTestingHealthCheck
    implements HealthCheck {
        private final Result.Status status;

        DynamicTestingHealthCheck(Result.Status status) {
            this.status = status;
        }

        public Result execute() {
            FormattingResultLog resultLog = new FormattingResultLog();
            resultLog.add(new ResultLog.Entry(this.status, "Set by JMX bean org.apache.sling.healthcheck:type=AdjustableHealthCheckForTesting (someone from IT operations is configuring this instance)"));
            return new Result((ResultLog)resultLog);
        }
    }
}

