/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.servlets;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Paths Servlet Node Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.servlet.paths", value={"/testing/PathsServletNodeServlet"})})
public class PathsServletNodeServlet
extends SlingAllMethodsServlet {
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        try {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            if ("create".equals(action)) {
                Node testing = JcrUtils.getOrAddNode((Node)session.getRootNode(), (String)"testing", (String)"nt:unstructured");
                Node servlet = JcrUtils.getOrAddNode((Node)testing, (String)"PathsServlet", (String)"nt:unstructured");
                JcrUtils.getOrAddNode((Node)servlet, (String)"foo", (String)"nt:unstructured");
                if (session.hasPendingChanges()) {
                    session.save();
                    response.setStatus(201);
                }
            } else if ("delete".equals(action) && session.nodeExists("/testing/PathsServlet/foo")) {
                session.getNode("/testing/PathsServlet/foo").remove();
                if (session.hasPendingChanges()) {
                    session.save();
                }
                response.setStatus(204);
            }
            response.getWriter().println("ok");
        }
        catch (RepositoryException e) {
            throw new ServletException("Unable to create or delete test node.", (Throwable)e);
        }
    }
}

