/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.remote.ide;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererFactory;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.remote.ide.ExecutionResult;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=false)
@Service
public class SerializedRenderer
extends RunListener
implements Renderer,
RendererFactory {
    public static final String EXTENSION = "serialized";
    private ObjectOutputStream outputStream;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Renderer createRenderer() {
        return new SerializedRenderer();
    }

    public boolean appliesTo(TestSelector s) {
        return EXTENSION.equals(s.getExtension());
    }

    public String getExtension() {
        return EXTENSION;
    }

    public void setup(HttpServletResponse response, String pageTitle) throws IOException, UnsupportedEncodingException {
        response.setContentType("application/x-java-serialized-object");
        this.outputStream = new ObjectOutputStream((OutputStream)response.getOutputStream());
    }

    public void cleanup() {
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            this.log.warn("Exception in cleanup()", (Throwable)e);
        }
        this.outputStream = null;
    }

    public RunListener getRunListener() {
        return this;
    }

    public void info(String role, String info) {
    }

    public void link(String info, String url, String method) {
    }

    public void list(String role, Collection<String> data) {
    }

    public void title(int level, String title) {
    }

    public void testRunFinished(Result result) throws IOException {
        ExecutionResult er = new ExecutionResult(result);
        this.outputStream.writeObject(er);
    }
}

