/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.bundleresource.impl.BundleResource;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.BundleResourceIterator;
import org.apache.sling.bundleresource.impl.PathMapping;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class BundleResourceProvider
extends ResourceProvider<Object> {
    public static final String PROP_BUNDLE = BundleResourceProvider.class.getName();
    private final BundleResourceCache cache;
    private final PathMapping root;
    private volatile ServiceRegistration<ResourceProvider> serviceRegistration;

    public BundleResourceProvider(BundleResourceCache cache, PathMapping root) {
        this.cache = cache;
        this.root = root;
    }

    long registerService() {
        Bundle bundle = this.cache.getBundle();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.description", "Provider of bundle based resources from bundle " + String.valueOf(bundle.getBundleId()));
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("provider.root", this.root.getResourceRoot());
        ((Dictionary)props).put(PROP_BUNDLE, bundle.getBundleId());
        this.serviceRegistration = bundle.getBundleContext().registerService(ResourceProvider.class, (Object)this, props);
        return (Long)this.serviceRegistration.getReference().getProperty("service.id");
    }

    void unregisterService() {
        if (this.serviceRegistration != null) {
            try {
                this.serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.serviceRegistration = null;
        }
    }

    public Resource getResource(ResolveContext<Object> ctx, String resourcePath, ResourceContext resourceContext, Resource parent) {
        PathMapping mappedPath = this.getMappedPath(resourcePath);
        if (mappedPath != null) {
            boolean isFolder;
            String entryPath = mappedPath.getEntryPath(resourcePath);
            URL entry = this.cache.getEntry(entryPath.concat("/"));
            boolean bl = isFolder = entry != null;
            if (entry == null && (entry = this.cache.getEntry(entryPath)) == null && this.root.getJSONPropertiesExtension() != null) {
                entry = this.cache.getEntry(entryPath + this.root.getJSONPropertiesExtension());
            }
            if (!(entry == null || this.root.getJSONPropertiesExtension() != null && entryPath.endsWith(this.root.getJSONPropertiesExtension()))) {
                return new BundleResource(ctx.getResourceResolver(), this.cache, mappedPath, resourcePath, null, isFolder);
            }
            if (this.root.getJSONPropertiesExtension() != null) {
                String parentPath = ResourceUtil.getParent((String)resourcePath);
                while (parentPath != null) {
                    Resource childResource;
                    Resource rsrc = this.getResource(ctx, parentPath, resourceContext, null);
                    if (rsrc != null && (childResource = ((BundleResource)rsrc).getChildResource(resourcePath.substring(parentPath.length() + 1))) != null) {
                        return childResource;
                    }
                    if ((parentPath = ResourceUtil.getParent((String)parentPath)) == null || this.getMappedPath(parentPath) != null) continue;
                    parentPath = null;
                }
            }
        }
        return null;
    }

    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
        if (parent instanceof BundleResource && ((BundleResource)parent).getBundle() == this.cache) {
            return new BundleResourceIterator((BundleResource)parent);
        }
        String parentPath = parent.getPath();
        PathMapping mappedPath = this.getMappedPath(parentPath);
        if (mappedPath != null) {
            return new BundleResourceIterator(parent.getResourceResolver(), this.cache, mappedPath, parentPath, null);
        }
        return null;
    }

    BundleResourceCache getBundleResourceCache() {
        return this.cache;
    }

    PathMapping getMappedPath() {
        return this.root;
    }

    private PathMapping getMappedPath(String resourcePath) {
        if (this.root.isChild(resourcePath)) {
            return this.root;
        }
        return null;
    }
}

