/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.checks;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.ErrorHolder;
import org.apache.jackrabbit.oak.composite.checks.MountedNodeStoreChecker;
import org.apache.jackrabbit.oak.composite.checks.NodeStoreChecks;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={NodeStoreChecks.class})
public class NodeStoreChecksService
implements NodeStoreChecks {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindChecker", unbind="unbindChecker", referenceInterface=MountedNodeStoreChecker.class)
    private List<MountedNodeStoreChecker<?>> checkers = new CopyOnWriteArrayList();
    @Reference
    private MountInfoProvider mip;

    public NodeStoreChecksService() {
    }

    public NodeStoreChecksService(MountInfoProvider mip, List<MountedNodeStoreChecker<?>> checkers) {
        this.checkers = checkers;
        this.mip = mip;
    }

    @Override
    public void check(NodeStore globalStore, MountedNodeStore mountedStore) {
        ErrorHolder errorHolder = new ErrorHolder();
        this.checkers.forEach(c -> {
            this.log.info("Checking NodeStore from mount {} with {}", (Object)mountedStore.getMount().getName(), c);
            this.check(mountedStore, errorHolder, globalStore, (MountedNodeStoreChecker)c);
            this.log.info("Check complete");
        });
        errorHolder.end();
    }

    private <T> void check(MountedNodeStore mountedStore, ErrorHolder errorHolder, NodeStore globalStore, MountedNodeStoreChecker<T> c) {
        T context = c.createContext(globalStore, this.mip);
        Tree mountRoot = TreeFactory.createReadOnlyTree((NodeState)mountedStore.getNodeStore().getRoot());
        this.visit(mountRoot, mountedStore, errorHolder, context, c);
    }

    private <T> void visit(Tree tree, MountedNodeStore mountedStore, ErrorHolder errorHolder, T context, MountedNodeStoreChecker<T> c) {
        Mount mount = mountedStore.getMount();
        boolean under = mount.isUnder(tree.getPath());
        boolean mounted = mount.isMounted(tree.getPath());
        boolean keepGoing = true;
        if (mounted) {
            keepGoing = c.check(mountedStore, tree, errorHolder, context);
        }
        if ((mounted || under) && keepGoing) {
            tree.getChildren().forEach(child -> this.visit((Tree)child, mountedStore, errorHolder, context, c));
        }
    }

    protected void bindChecker(MountedNodeStoreChecker<?> checker) {
        this.checkers.add(checker);
    }

    protected void unbindChecker(MountedNodeStoreChecker<?> checker) {
        this.checkers.remove(checker);
    }

    protected void bindMip(MountInfoProvider mountInfoProvider) {
        this.mip = mountInfoProvider;
    }

    protected void unbindMip(MountInfoProvider mountInfoProvider) {
        if (this.mip == mountInfoProvider) {
            this.mip = null;
        }
    }
}

