/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.composite.CompositeCheckpointMBean;
import org.apache.jackrabbit.oak.composite.CompositeNodeStore;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreStats;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreStatsMBean;
import org.apache.jackrabbit.oak.composite.InitialContentMigrator;
import org.apache.jackrabbit.oak.composite.checks.NodeStoreChecks;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.ObserverTracker;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
public class CompositeNodeStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeNodeStoreService.class);
    private static final String GLOBAL_ROLE = "composite-global";
    private static final String MOUNT_ROLE_PREFIX = "composite-mount-";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private MountInfoProvider mountInfoProvider;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindNodeStore", unbind="unbindNodeStore", referenceInterface=NodeStoreProvider.class, target="(!(service.pid=org.apache.jackrabbit.oak.composite.CompositeNodeStore))")
    private List<NodeStoreWithProps> nodeStores = new ArrayList<NodeStoreWithProps>();
    @Reference
    private NodeStoreChecks checks;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    @Property(label="Ignore read only writes", unbounded=PropertyUnbounded.ARRAY, description="Writes to these read-only paths won't fail the commit")
    private static final String PROP_IGNORE_READ_ONLY_WRITES = "ignoreReadOnlyWrites";
    @Property(label="Read-only mounts", description="The partial stores should be configured as read-only", boolValue={true})
    private static final String PROP_PARTIAL_READ_ONLY = "partialReadOnly";
    @Property(label="Pre-populate seed mount", description="Setting this parameter to a mount name will enable pre-populating the empty default store")
    private static final String PROP_SEED_MOUNT = "seedMount";
    @Property(label="Gather path statistics", description="Whether the CompositeNodeStoreStatsMBean should gather information about the most popular paths (may be expensive)", boolValue={false})
    private static final String PATH_STATS = "pathStats";
    private ComponentContext context;
    private Set<NodeStoreProvider> nodeStoresInUse = Sets.newIdentityHashSet();
    private ServiceRegistration nsReg;
    private Closer mbeanRegistrations;
    private ObserverTracker observerTracker;
    private String[] ignoreReadOnlyWritePaths;
    private boolean partialReadOnly;
    private String seedMount;
    private boolean pathStats;

    @Activate
    protected void activate(ComponentContext context, Map<String, ?> config) throws IOException, CommitFailedException {
        this.context = context;
        this.ignoreReadOnlyWritePaths = PropertiesUtil.toStringArray(config.get(PROP_IGNORE_READ_ONLY_WRITES), (String[])new String[0]);
        this.partialReadOnly = PropertiesUtil.toBoolean(config.get(PROP_PARTIAL_READ_ONLY), (boolean)true);
        this.seedMount = PropertiesUtil.toString(config.get(PROP_SEED_MOUNT), null);
        this.pathStats = PropertiesUtil.toBoolean(config.get(PATH_STATS), (boolean)false);
        this.registerCompositeNodeStore();
    }

    @Deactivate
    protected void deactivate() throws IOException {
        this.unregisterCompositeNodeStore();
    }

    private void registerCompositeNodeStore() throws IOException, CommitFailedException {
        if (this.nsReg != null) {
            return;
        }
        NodeStoreWithProps globalNs = null;
        HashSet<String> availableMounts = new HashSet<String>();
        for (NodeStoreWithProps ns : this.nodeStores) {
            if (this.isGlobalNodeStore(ns)) {
                globalNs = ns;
                continue;
            }
            availableMounts.add(this.getMountName(ns));
        }
        if (globalNs == null) {
            LOG.info("Composite node store registration is deferred until there's a global node store registered in OSGi");
            return;
        }
        LOG.info("Found global node store: {}", (Object)globalNs.getDescription());
        for (Object m : this.mountInfoProvider.getNonDefaultMounts()) {
            if (availableMounts.contains(m.getName())) continue;
            LOG.info("Composite node store registration is deferred until there's mount {} registered in OSGi", (Object)m.getName());
            return;
        }
        LOG.info("Node stores for all configured mounts are available");
        CompositeNodeStore.Builder builder = new CompositeNodeStore.Builder(this.mountInfoProvider, globalNs.getNodeStoreProvider().getNodeStore());
        this.nodeStoresInUse.add(globalNs.getNodeStoreProvider());
        builder.with(this.checks);
        builder.setPartialReadOnly(this.partialReadOnly);
        for (String p : this.ignoreReadOnlyWritePaths) {
            builder.addIgnoredReadOnlyWritePath(p);
        }
        for (NodeStoreWithProps ns : this.nodeStores) {
            String mountName;
            if (this.isGlobalNodeStore(ns) || (mountName = this.getMountName(ns)) == null) continue;
            builder.addMount(mountName, ns.getNodeStoreProvider().getNodeStore());
            LOG.info("Mounting {} as {}", (Object)ns.getDescription(), (Object)mountName);
            this.nodeStoresInUse.add(ns.getNodeStoreProvider());
            if (!mountName.equals(this.seedMount)) continue;
            new InitialContentMigrator(globalNs.nodeStore.getNodeStore(), ns.getNodeStoreProvider().getNodeStore(), this.mountInfoProvider.getMountByName(this.seedMount)).migrate();
        }
        CompositeNodeStoreStats nodeStateStats = new CompositeNodeStoreStats(this.statisticsProvider, "NODE_STATE", this.pathStats);
        CompositeNodeStoreStats nodeBuilderStats = new CompositeNodeStoreStats(this.statisticsProvider, "NODE_BUILDER", this.pathStats);
        builder.with(nodeStateStats, nodeBuilderStats);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", CompositeNodeStore.class.getName());
        ((Dictionary)props).put("oak.nodestore.description", new String[]{"nodeStoreType=compositeStore"});
        CompositeNodeStore store = builder.build();
        this.observerTracker = new ObserverTracker((Observable)store);
        this.observerTracker.start(this.context.getBundleContext());
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        this.mbeanRegistrations = Closer.create();
        this.registerMBean((Whiteboard)whiteboard, CheckpointMBean.class, new CompositeCheckpointMBean(store), "CheckpointManager", "Composite node store checkpoint management");
        this.registerMBean((Whiteboard)whiteboard, CompositeNodeStoreStatsMBean.class, nodeStateStats, "CompositeNodeStoreStats", "Composite node store statistics (node state)");
        this.registerMBean((Whiteboard)whiteboard, CompositeNodeStoreStatsMBean.class, nodeBuilderStats, "CompositeNodeStoreStats", "Composite node store statistics (node builder)");
        LOG.info("Registering the composite node store");
        this.nsReg = this.context.getBundleContext().registerService(new String[]{NodeStore.class.getName()}, (Object)store, props);
    }

    private <T> void registerMBean(Whiteboard whiteboard, Class<T> iface, T bean, String type, String name) {
        Registration reg = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, iface, bean, (String)type, (String)name);
        this.mbeanRegistrations.register(() -> reg.unregister());
    }

    private boolean isGlobalNodeStore(NodeStoreWithProps ns) {
        return GLOBAL_ROLE.equals(ns.getRole());
    }

    private String getMountName(NodeStoreWithProps ns) {
        String role = ns.getRole();
        if (role == null) {
            return null;
        }
        if (!role.startsWith(MOUNT_ROLE_PREFIX)) {
            return null;
        }
        return role.substring(MOUNT_ROLE_PREFIX.length());
    }

    private void unregisterCompositeNodeStore() throws IOException {
        if (this.nsReg != null) {
            LOG.info("Unregistering the composite node store");
            this.nsReg.unregister();
            this.nsReg = null;
        }
        if (this.mbeanRegistrations != null) {
            this.mbeanRegistrations.close();
            this.mbeanRegistrations = null;
        }
        if (this.observerTracker != null) {
            this.observerTracker.stop();
            this.observerTracker = null;
        }
        this.nodeStoresInUse.clear();
    }

    protected void bindNodeStore(NodeStoreProvider ns, Map<String, ?> config) throws IOException, CommitFailedException {
        NodeStoreWithProps newNs = new NodeStoreWithProps(ns, config);
        this.nodeStores.add(newNs);
        if (this.context == null) {
            LOG.info("bindNodeStore: context is null, delaying reconfiguration");
            return;
        }
        if (this.nsReg == null) {
            this.registerCompositeNodeStore();
        }
    }

    protected void unbindNodeStore(NodeStoreProvider ns) throws IOException {
        Iterator<NodeStoreWithProps> it = this.nodeStores.iterator();
        while (it.hasNext()) {
            if (it.next().getNodeStoreProvider() != ns) continue;
            it.remove();
        }
        if (this.context == null) {
            LOG.info("unbindNodeStore: context is null, delaying reconfiguration");
            return;
        }
        if (this.nsReg != null && this.nodeStoresInUse.contains(ns)) {
            this.unregisterCompositeNodeStore();
        }
    }

    protected void bindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    protected void unbindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        if (this.mountInfoProvider == mountInfoProvider) {
            this.mountInfoProvider = null;
        }
    }

    protected void bindChecks(NodeStoreChecks nodeStoreChecks) {
        this.checks = nodeStoreChecks;
    }

    protected void unbindChecks(NodeStoreChecks nodeStoreChecks) {
        if (this.checks == nodeStoreChecks) {
            this.checks = null;
        }
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }

    private static class NodeStoreWithProps {
        private final NodeStoreProvider nodeStore;
        private final Map<String, ?> props;

        public NodeStoreWithProps(NodeStoreProvider nodeStore, Map<String, ?> props) {
            this.nodeStore = nodeStore;
            this.props = props;
        }

        public NodeStoreProvider getNodeStoreProvider() {
            return this.nodeStore;
        }

        public Map<String, ?> getProps() {
            return this.props;
        }

        public String getRole() {
            return PropertiesUtil.toString(this.props.get("role"), null);
        }

        public String getDescription() {
            return PropertiesUtil.toString(this.getProps().get("oak.nodestore.description"), (String)this.getNodeStoreProvider().getClass().toString());
        }
    }
}

